/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.types;

import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.util.PropertyValueHandler;
import net.infonode.properties.util.ValueHandlerProperty;
import net.infonode.util.ArrayUtil;

public class EnumProperty
extends ValueHandlerProperty {
    private Object[] validValues;

    public EnumProperty(PropertyGroup group, String name, Class type, String description, PropertyValueHandler valueHandler, Object[] validValues) {
        super(group, name, type, description, valueHandler);
        this.validValues = (Object[])validValues.clone();
    }

    @Override
    public void setValue(Object object, Object value) {
        if (!ArrayUtil.contains(this.validValues, value)) {
            throw new IllegalArgumentException("Invalid enum value!");
        }
        super.setValue(object, value);
    }

    public Object[] getValidValues() {
        return (Object[])this.validValues.clone();
    }

    @Override
    public Object getValue(Object object) {
        Object value = super.getValue(object);
        return value == null ? this.validValues[0] : value;
    }
}

