/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import org.freeplane.features.map.DocuMapAttribute;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.main.application.ConnectedToMenuView;
import org.freeplane.main.application.MapViewDockingWindows;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewScrollPane;
import org.freeplane.view.swing.map.overview.MapViewPane;

class MapViewSerializer
implements ViewSerializer {
    private Collection<View> viewsToBeRemoved = new ArrayList<View>();

    MapViewSerializer() {
    }

    public void writeView(View view, ObjectOutputStream out) throws IOException {
        MapView mapView;
        Component component;
        if (view.isDisplayable() && (component = MapViewDockingWindows.getContainedMapView(view)) instanceof MapView && (mapView = (MapView)component).getModeController().getModeName().equals("MindMap") && !mapView.getMap().containsExtension(DocuMapAttribute.class)) {
            out.writeBoolean(true);
            out.writeUTF(mapView.getModeController().getModeName());
            out.writeObject(mapView.getMap().getURL());
            return;
        }
        out.writeBoolean(false);
    }

    public View readView(ObjectInputStream in) throws IOException {
        try {
            if (in.readBoolean()) {
                Object pNewMap;
                String modeName = in.readUTF();
                URL mapUrl = (URL)in.readObject();
                if (mapUrl == null) {
                    return this.newViewToBeRemoved();
                }
                Controller controller = Controller.getCurrentController();
                controller.selectMode(modeName);
                ModeController modeController = Controller.getCurrentModeController();
                MapController mapController = modeController.getMapController();
                mapController.openMap(mapUrl);
                MapView mapViewComponent = (MapView)controller.getMapViewManager().getMapViewComponent();
                if (mapViewComponent.getParent() == null) {
                    pNewMap = mapViewComponent;
                } else {
                    mapController.createMapView(mapViewComponent.getMap());
                    pNewMap = controller.getMapViewManager().getMapViewComponent();
                }
                return this.newDockedView((Component)pNewMap, pNewMap.getName());
            }
            return this.newViewToBeRemoved();
        }
        catch (Exception e) {
            return this.newViewToBeRemoved();
        }
    }

    private View newViewToBeRemoved() {
        View view = new View("", null, (Component)new JPanel());
        this.viewsToBeRemoved.add(view);
        return view;
    }

    protected View newDockedView(Component pNewMap, String title) {
        if (pNewMap.getParent() != null) {
            return null;
        }
        MapViewScrollPane mapViewScrollPane = new MapViewScrollPane();
        mapViewScrollPane.getViewport().setView(pNewMap);
        MapViewPane mapViewPane = new MapViewPane((JScrollPane)mapViewScrollPane);
        mapViewScrollPane.addViewportReservedAreaSupplier(() -> ((MapViewPane)mapViewPane).getMapOverviewReservedArea());
        ConnectedToMenuView viewFrame = new ConnectedToMenuView(title, null, (Component)mapViewPane);
        return viewFrame;
    }

    public void removeDummyViews() {
        for (View view : this.viewsToBeRemoved) {
            view.close();
        }
        this.viewsToBeRemoved.clear();
    }
}

