#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-ddFUeGz7dv5wzZpte5qAd
key:                  postgrest-10.0.0-ddFUeGz7dv5wzZpte5qAd
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  5e02fa7caf733295b88cdcf51dc8e6d1
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-ddFUeGz7dv5wzZpte5qAd
depends:
    HTTP-4000.4.1-JtRIgU9Z4IjIeZcvqE1nDr
    Ranged-sets-0.5.0-Etbos8XW298JmpgDZLCgMF
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E
    auto-update-0.1.6-7cEFWtyqt56DaBjgwZVGhv base-4.18.2.1
    base64-bytestring-1.2.1.0-yECTd8pImc5tCLSmRqH7t bytestring-0.11.5.3
    case-insensitive-1.2.1.0-5HTh5m1rt1RHDEKgWxawKc
    cassava-0.5.4.1-KWNl5rPnZL4HqDsgurlU6b
    configurator-pg-0.2.10-7rhh5FIIMkJKbSqVWsrF68 containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-jXBNFjaa6FCadOlmmPVD
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-Eu0rOxyXR5UB1q7HEFqUst
    hasql-dynamic-statements-0.3.1.1-FGa7JDiBjIREcbCpD8Rgrt
    hasql-notifications-0.2.0.5-H6zCtEPhu8i7028veify09
    hasql-pool-0.5.2.2-48rTdmabZxY2otqnVv0ulg
    hasql-transaction-1.0.1.1-73xBwajW92F2iJ64YlYIsK
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-47H2c8g9PRZ51oXX8MMJrI
    insert-ordered-containers-0.2.5.3-BLBRe9rvh137fX99UdqwxP
    interpolatedstring-perl6-1.0.2-90eHS8ecC37HIaYNFYhdxM
    jose-0.10-G0ndMPrilMjLwojMQDtU2U lens-5.3.3-BkxjKs9BZyaIo4WbxLEcF5
    lens-aeson-1.2.3-6HVSbAXJ7lzDDY9Enmr7ej mtl-2.3.1
    network-3.1.4.0-IebBekr390i8Nw6inuvzzb
    network-uri-2.6.4.2-IQdxby3Fv1vL3jfFaSRPYt
    optparse-applicative-0.18.1.0-GNgTM1Z51EJ46yTCRGWgwm
    parsec-3.1.16.1 protolude-0.3.5-7PK8GterzSKCPpwZnd0DXW
    regex-tdfa-1.3.2.5-LVEu1APtYIwJMYGWcCftyg
    retry-0.9.3.1-3CdWHnDxs6WD2kDl79MliP
    scientific-0.3.8.0-DJ6xks3YjY5SsKPtBx4Fi
    swagger2-2.8.10-IPUxEQq2zvC87o89dW78fo text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA
    vault-0.3.1.5-3NT2ZmKxNtOCa9B8iilwVI
    vector-0.13.2.0-6vtrErFI1tV1Z02auPMCSS
    wai-3.2.4-29lPZrUTVnS94Mmm983Wpw
    wai-cors-0.2.7-3ssgbTolj8cJEaO2V2YfOK
    wai-extra-3.1.18-AFygdGMBury4EFoszcDuf4
    wai-logger-2.5.0-8nPdfjtPY3N2sb79OtjDWy
    warp-3.4.0-FMWkdBE2f7G7xiJ74SO0dX

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

