/************************************************************************
 **
 **  @file   vabstractarc.h
 **  @author Roman Telezhynskyi <dismine(at)gmail.com>
 **  @date   10 4, 2016
 **
 **  @brief
 **  @copyright
 **  This source code is part of the Valentina project, a pattern making
 **  program, whose allow create and modeling patterns of clothing.
 **  Copyright (C) 2016 Valentina project
 **  <https://gitlab.com/smart-pattern/valentina> All Rights Reserved.
 **
 **  Valentina is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Valentina is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Valentina.  If not, see <http://www.gnu.org/licenses/>.
 **
 *************************************************************************/

#ifndef VABSTRACTARC_H
#define VABSTRACTARC_H

#include <qcompilerdetection.h>
#include <QSharedDataPointer>
#include <QString>
#include <QtGlobal>

#include "../ifc/ifcdef.h"
#include "vabstractcurve.h"
#include "vgeometrydef.h"

class VAbstractArcData;
class VPointF;

QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wsuggest-final-types")

class VAbstractArc : public VAbstractCurve
{
public:
    explicit VAbstractArc(const GOType &type, const quint32 &idObject = NULL_ID, const Draw &mode = Draw::Calculation);
    VAbstractArc(const GOType &type, const VPointF &center, qreal f1, const QString &formulaF1, qreal f2,
                 const QString &formulaF2, quint32 idObject = 0, Draw mode = Draw::Calculation);
    VAbstractArc(const GOType &type, const VPointF &center, qreal f1, qreal f2, quint32 idObject = 0,
                 Draw mode = Draw::Calculation);
    VAbstractArc(const GOType &type, const QString &formulaLength, const VPointF &center, qreal f1,
                 const QString &formulaF1, quint32 idObject = 0, Draw mode = Draw::Calculation);
    VAbstractArc(const GOType &type, const VPointF &center, qreal f1, quint32 idObject = 0,
                 Draw mode = Draw::Calculation);
    VAbstractArc(const VAbstractArc &arc);
    ~VAbstractArc() override;

    auto operator= (const VAbstractArc &arc) -> VAbstractArc&;
#ifdef Q_COMPILER_RVALUE_REFS
    VAbstractArc(VAbstractArc &&arc) Q_DECL_NOTHROW;
    auto operator=(VAbstractArc &&arc) Q_DECL_NOTHROW -> VAbstractArc &;
#endif

    auto GetFormulaF1 () const -> QString;
    void SetFormulaF1 (const QString &formula, qreal value);
    auto GetStartAngle () const -> qreal override;

    auto GetFormulaF2 () const -> QString;
    void SetFormulaF2 (const QString &formula, qreal value);
    auto GetEndAngle () const -> qreal override;

    auto GetCenter () const -> VPointF;
    void SetCenter (const VPointF &point);

    auto GetFormulaLength () const -> QString;
    void SetFormulaLength (const QString &formula, qreal value);

    void setId(const quint32 &id) override;
    auto NameForHistory(const QString &toolName) const -> QString override;

    auto IsFlipped() const -> bool;
    auto AngleArc() const -> qreal;
protected:
    void SetFlipped(bool value);
    virtual void FindF2(qreal length)=0;
    void SetFormulaLength(const QString &formula);
private:
    QSharedDataPointer<VAbstractArcData> d;
};

QT_WARNING_POP

#endif // VABSTRACTARC_H
