#![allow(dead_code)]
pub const BROTLI_NUM_BLOCK_LEN_SYMBOLS: usize = 26;
pub static kInsBase: [u32; 24] = [0u32, 1u32, 2u32, 3u32, 4u32, 5u32, 6u32, 8u32, 10u32, 14u32,
                                  18u32, 26u32, 34u32, 50u32, 66u32, 98u32, 130u32, 194u32,
                                  322u32, 578u32, 1090u32, 2114u32, 6210u32, 22594u32];

pub static kInsExtra: [u32; 24] = [0u32, 0u32, 0u32, 0u32, 0u32, 0u32, 1u32, 1u32, 2u32, 2u32,
                                   3u32, 3u32, 4u32, 4u32, 5u32, 5u32, 6u32, 7u32, 8u32, 9u32,
                                   10u32, 12u32, 14u32, 24u32];

pub static kCopyBase: [u32; 24] = [2u32, 3u32, 4u32, 5u32, 6u32, 7u32, 8u32, 9u32, 10u32, 12u32,
                                   14u32, 18u32, 22u32, 30u32, 38u32, 54u32, 70u32, 102u32,
                                   134u32, 198u32, 326u32, 582u32, 1094u32, 2118u32];

pub static kCopyExtra: [u32; 24] = [0u32, 0u32, 0u32, 0u32, 0u32, 0u32, 0u32, 0u32, 1u32, 1u32,
                                    2u32, 2u32, 3u32, 3u32, 4u32, 4u32, 5u32, 5u32, 6u32, 7u32,
                                    8u32, 9u32, 10u32, 24u32];

/* Common context lookup table for all context modes. */
static kContextLookup:[u8;2048] = [
  /* CONTEXT_LSB6, last byte. */
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,

  /* CONTEXT_LSB6, second last byte, */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

  /* CONTEXT_MSB6, last byte. */
   0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
   4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
   8,  8,  8,  8,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 11,
  12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15,
  16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19,
  20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23,
  24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27,
  28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31,
  32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35,
  36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 39,
  40, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43,
  44, 44, 44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47,
  48, 48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 51, 51, 51, 51,
  52, 52, 52, 52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, 55, 55,
  56, 56, 56, 56, 57, 57, 57, 57, 58, 58, 58, 58, 59, 59, 59, 59,
  60, 60, 60, 60, 61, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63,

  /* CONTEXT_MSB6, second last byte, */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

  /* CONTEXT_UTF8, last byte. */
  /* ASCII range. */
   0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  4,  0,  0,  4,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   8, 12, 16, 12, 12, 20, 12, 16, 24, 28, 12, 12, 32, 12, 36, 12,
  44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 32, 32, 24, 40, 28, 12,
  12, 48, 52, 52, 52, 48, 52, 52, 52, 48, 52, 52, 52, 52, 52, 48,
  52, 52, 52, 52, 52, 48, 52, 52, 52, 52, 52, 24, 12, 28, 12, 12,
  12, 56, 60, 60, 60, 56, 60, 60, 60, 56, 60, 60, 60, 60, 60, 56,
  60, 60, 60, 60, 60, 56, 60, 60, 60, 60, 60, 24, 12, 28, 12,  0,
  /* UTF8 continuation byte range. */
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  /* UTF8 lead byte range. */
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,

  /* CONTEXT_UTF8 second last byte. */
  /* ASCII range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,
  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 0,
  /* UTF8 continuation byte range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  /* UTF8 lead byte range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* CONTEXT_SIGNED, last byte, same as the above values shifted by 3 bits. */
   0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,

  /* CONTEXT_SIGNED, second last byte. */
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7,
];
pub const BROTLI_NUM_HISTOGRAM_DISTANCE_SYMBOLS:usize = 544;
pub const BROTLI_NUM_LITERAL_SYMBOLS:usize = 256;
pub const BROTLI_NUM_COMMAND_SYMBOLS:usize = 704;
pub const BROTLI_WINDOW_GAP: usize = 16;
pub const BROTLI_MAX_NPOSTFIX:usize = 3;
pub const BROTLI_MAX_NDIRECT:usize = 120;
#[inline(always)]
pub fn BROTLI_CONTEXT_LUT(mode: super::histogram::ContextType)->&'static[u8] {
    &kContextLookup[((mode as usize) << 9)..]
}
pub fn BROTLI_CONTEXT(P1: u8, P2:u8, LUT:&[u8])->u8 {
    (LUT)[P1 as usize] | ((LUT)[256 + P2 as usize])
}
pub static kZeroRepsBits: [usize; 704] = [0x0usize,
                                          0x0usize,
                                          0x0usize,
                                          0x7usize,
                                          0x17usize,
                                          0x27usize,
                                          0x37usize,
                                          0x47usize,
                                          0x57usize,
                                          0x67usize,
                                          0x77usize,
                                          0x770usize,
                                          0xb87usize,
                                          0x1387usize,
                                          0x1b87usize,
                                          0x2387usize,
                                          0x2b87usize,
                                          0x3387usize,
                                          0x3b87usize,
                                          0x397usize,
                                          0xb97usize,
                                          0x1397usize,
                                          0x1b97usize,
                                          0x2397usize,
                                          0x2b97usize,
                                          0x3397usize,
                                          0x3b97usize,
                                          0x3a7usize,
                                          0xba7usize,
                                          0x13a7usize,
                                          0x1ba7usize,
                                          0x23a7usize,
                                          0x2ba7usize,
                                          0x33a7usize,
                                          0x3ba7usize,
                                          0x3b7usize,
                                          0xbb7usize,
                                          0x13b7usize,
                                          0x1bb7usize,
                                          0x23b7usize,
                                          0x2bb7usize,
                                          0x33b7usize,
                                          0x3bb7usize,
                                          0x3c7usize,
                                          0xbc7usize,
                                          0x13c7usize,
                                          0x1bc7usize,
                                          0x23c7usize,
                                          0x2bc7usize,
                                          0x33c7usize,
                                          0x3bc7usize,
                                          0x3d7usize,
                                          0xbd7usize,
                                          0x13d7usize,
                                          0x1bd7usize,
                                          0x23d7usize,
                                          0x2bd7usize,
                                          0x33d7usize,
                                          0x3bd7usize,
                                          0x3e7usize,
                                          0xbe7usize,
                                          0x13e7usize,
                                          0x1be7usize,
                                          0x23e7usize,
                                          0x2be7usize,
                                          0x33e7usize,
                                          0x3be7usize,
                                          0x3f7usize,
                                          0xbf7usize,
                                          0x13f7usize,
                                          0x1bf7usize,
                                          0x23f7usize,
                                          0x2bf7usize,
                                          0x33f7usize,
                                          0x3bf7usize,
                                          0x1c387usize,
                                          0x5c387usize,
                                          0x9c387usize,
                                          0xdc387usize,
                                          0x11c387usize,
                                          0x15c387usize,
                                          0x19c387usize,
                                          0x1dc387usize,
                                          0x1cb87usize,
                                          0x5cb87usize,
                                          0x9cb87usize,
                                          0xdcb87usize,
                                          0x11cb87usize,
                                          0x15cb87usize,
                                          0x19cb87usize,
                                          0x1dcb87usize,
                                          0x1d387usize,
                                          0x5d387usize,
                                          0x9d387usize,
                                          0xdd387usize,
                                          0x11d387usize,
                                          0x15d387usize,
                                          0x19d387usize,
                                          0x1dd387usize,
                                          0x1db87usize,
                                          0x5db87usize,
                                          0x9db87usize,
                                          0xddb87usize,
                                          0x11db87usize,
                                          0x15db87usize,
                                          0x19db87usize,
                                          0x1ddb87usize,
                                          0x1e387usize,
                                          0x5e387usize,
                                          0x9e387usize,
                                          0xde387usize,
                                          0x11e387usize,
                                          0x15e387usize,
                                          0x19e387usize,
                                          0x1de387usize,
                                          0x1eb87usize,
                                          0x5eb87usize,
                                          0x9eb87usize,
                                          0xdeb87usize,
                                          0x11eb87usize,
                                          0x15eb87usize,
                                          0x19eb87usize,
                                          0x1deb87usize,
                                          0x1f387usize,
                                          0x5f387usize,
                                          0x9f387usize,
                                          0xdf387usize,
                                          0x11f387usize,
                                          0x15f387usize,
                                          0x19f387usize,
                                          0x1df387usize,
                                          0x1fb87usize,
                                          0x5fb87usize,
                                          0x9fb87usize,
                                          0xdfb87usize,
                                          0x11fb87usize,
                                          0x15fb87usize,
                                          0x19fb87usize,
                                          0x1dfb87usize,
                                          0x1c397usize,
                                          0x5c397usize,
                                          0x9c397usize,
                                          0xdc397usize,
                                          0x11c397usize,
                                          0x15c397usize,
                                          0x19c397usize,
                                          0x1dc397usize,
                                          0x1cb97usize,
                                          0x5cb97usize,
                                          0x9cb97usize,
                                          0xdcb97usize,
                                          0x11cb97usize,
                                          0x15cb97usize,
                                          0x19cb97usize,
                                          0x1dcb97usize,
                                          0x1d397usize,
                                          0x5d397usize,
                                          0x9d397usize,
                                          0xdd397usize,
                                          0x11d397usize,
                                          0x15d397usize,
                                          0x19d397usize,
                                          0x1dd397usize,
                                          0x1db97usize,
                                          0x5db97usize,
                                          0x9db97usize,
                                          0xddb97usize,
                                          0x11db97usize,
                                          0x15db97usize,
                                          0x19db97usize,
                                          0x1ddb97usize,
                                          0x1e397usize,
                                          0x5e397usize,
                                          0x9e397usize,
                                          0xde397usize,
                                          0x11e397usize,
                                          0x15e397usize,
                                          0x19e397usize,
                                          0x1de397usize,
                                          0x1eb97usize,
                                          0x5eb97usize,
                                          0x9eb97usize,
                                          0xdeb97usize,
                                          0x11eb97usize,
                                          0x15eb97usize,
                                          0x19eb97usize,
                                          0x1deb97usize,
                                          0x1f397usize,
                                          0x5f397usize,
                                          0x9f397usize,
                                          0xdf397usize,
                                          0x11f397usize,
                                          0x15f397usize,
                                          0x19f397usize,
                                          0x1df397usize,
                                          0x1fb97usize,
                                          0x5fb97usize,
                                          0x9fb97usize,
                                          0xdfb97usize,
                                          0x11fb97usize,
                                          0x15fb97usize,
                                          0x19fb97usize,
                                          0x1dfb97usize,
                                          0x1c3a7usize,
                                          0x5c3a7usize,
                                          0x9c3a7usize,
                                          0xdc3a7usize,
                                          0x11c3a7usize,
                                          0x15c3a7usize,
                                          0x19c3a7usize,
                                          0x1dc3a7usize,
                                          0x1cba7usize,
                                          0x5cba7usize,
                                          0x9cba7usize,
                                          0xdcba7usize,
                                          0x11cba7usize,
                                          0x15cba7usize,
                                          0x19cba7usize,
                                          0x1dcba7usize,
                                          0x1d3a7usize,
                                          0x5d3a7usize,
                                          0x9d3a7usize,
                                          0xdd3a7usize,
                                          0x11d3a7usize,
                                          0x15d3a7usize,
                                          0x19d3a7usize,
                                          0x1dd3a7usize,
                                          0x1dba7usize,
                                          0x5dba7usize,
                                          0x9dba7usize,
                                          0xddba7usize,
                                          0x11dba7usize,
                                          0x15dba7usize,
                                          0x19dba7usize,
                                          0x1ddba7usize,
                                          0x1e3a7usize,
                                          0x5e3a7usize,
                                          0x9e3a7usize,
                                          0xde3a7usize,
                                          0x11e3a7usize,
                                          0x15e3a7usize,
                                          0x19e3a7usize,
                                          0x1de3a7usize,
                                          0x1eba7usize,
                                          0x5eba7usize,
                                          0x9eba7usize,
                                          0xdeba7usize,
                                          0x11eba7usize,
                                          0x15eba7usize,
                                          0x19eba7usize,
                                          0x1deba7usize,
                                          0x1f3a7usize,
                                          0x5f3a7usize,
                                          0x9f3a7usize,
                                          0xdf3a7usize,
                                          0x11f3a7usize,
                                          0x15f3a7usize,
                                          0x19f3a7usize,
                                          0x1df3a7usize,
                                          0x1fba7usize,
                                          0x5fba7usize,
                                          0x9fba7usize,
                                          0xdfba7usize,
                                          0x11fba7usize,
                                          0x15fba7usize,
                                          0x19fba7usize,
                                          0x1dfba7usize,
                                          0x1c3b7usize,
                                          0x5c3b7usize,
                                          0x9c3b7usize,
                                          0xdc3b7usize,
                                          0x11c3b7usize,
                                          0x15c3b7usize,
                                          0x19c3b7usize,
                                          0x1dc3b7usize,
                                          0x1cbb7usize,
                                          0x5cbb7usize,
                                          0x9cbb7usize,
                                          0xdcbb7usize,
                                          0x11cbb7usize,
                                          0x15cbb7usize,
                                          0x19cbb7usize,
                                          0x1dcbb7usize,
                                          0x1d3b7usize,
                                          0x5d3b7usize,
                                          0x9d3b7usize,
                                          0xdd3b7usize,
                                          0x11d3b7usize,
                                          0x15d3b7usize,
                                          0x19d3b7usize,
                                          0x1dd3b7usize,
                                          0x1dbb7usize,
                                          0x5dbb7usize,
                                          0x9dbb7usize,
                                          0xddbb7usize,
                                          0x11dbb7usize,
                                          0x15dbb7usize,
                                          0x19dbb7usize,
                                          0x1ddbb7usize,
                                          0x1e3b7usize,
                                          0x5e3b7usize,
                                          0x9e3b7usize,
                                          0xde3b7usize,
                                          0x11e3b7usize,
                                          0x15e3b7usize,
                                          0x19e3b7usize,
                                          0x1de3b7usize,
                                          0x1ebb7usize,
                                          0x5ebb7usize,
                                          0x9ebb7usize,
                                          0xdebb7usize,
                                          0x11ebb7usize,
                                          0x15ebb7usize,
                                          0x19ebb7usize,
                                          0x1debb7usize,
                                          0x1f3b7usize,
                                          0x5f3b7usize,
                                          0x9f3b7usize,
                                          0xdf3b7usize,
                                          0x11f3b7usize,
                                          0x15f3b7usize,
                                          0x19f3b7usize,
                                          0x1df3b7usize,
                                          0x1fbb7usize,
                                          0x5fbb7usize,
                                          0x9fbb7usize,
                                          0xdfbb7usize,
                                          0x11fbb7usize,
                                          0x15fbb7usize,
                                          0x19fbb7usize,
                                          0x1dfbb7usize,
                                          0x1c3c7usize,
                                          0x5c3c7usize,
                                          0x9c3c7usize,
                                          0xdc3c7usize,
                                          0x11c3c7usize,
                                          0x15c3c7usize,
                                          0x19c3c7usize,
                                          0x1dc3c7usize,
                                          0x1cbc7usize,
                                          0x5cbc7usize,
                                          0x9cbc7usize,
                                          0xdcbc7usize,
                                          0x11cbc7usize,
                                          0x15cbc7usize,
                                          0x19cbc7usize,
                                          0x1dcbc7usize,
                                          0x1d3c7usize,
                                          0x5d3c7usize,
                                          0x9d3c7usize,
                                          0xdd3c7usize,
                                          0x11d3c7usize,
                                          0x15d3c7usize,
                                          0x19d3c7usize,
                                          0x1dd3c7usize,
                                          0x1dbc7usize,
                                          0x5dbc7usize,
                                          0x9dbc7usize,
                                          0xddbc7usize,
                                          0x11dbc7usize,
                                          0x15dbc7usize,
                                          0x19dbc7usize,
                                          0x1ddbc7usize,
                                          0x1e3c7usize,
                                          0x5e3c7usize,
                                          0x9e3c7usize,
                                          0xde3c7usize,
                                          0x11e3c7usize,
                                          0x15e3c7usize,
                                          0x19e3c7usize,
                                          0x1de3c7usize,
                                          0x1ebc7usize,
                                          0x5ebc7usize,
                                          0x9ebc7usize,
                                          0xdebc7usize,
                                          0x11ebc7usize,
                                          0x15ebc7usize,
                                          0x19ebc7usize,
                                          0x1debc7usize,
                                          0x1f3c7usize,
                                          0x5f3c7usize,
                                          0x9f3c7usize,
                                          0xdf3c7usize,
                                          0x11f3c7usize,
                                          0x15f3c7usize,
                                          0x19f3c7usize,
                                          0x1df3c7usize,
                                          0x1fbc7usize,
                                          0x5fbc7usize,
                                          0x9fbc7usize,
                                          0xdfbc7usize,
                                          0x11fbc7usize,
                                          0x15fbc7usize,
                                          0x19fbc7usize,
                                          0x1dfbc7usize,
                                          0x1c3d7usize,
                                          0x5c3d7usize,
                                          0x9c3d7usize,
                                          0xdc3d7usize,
                                          0x11c3d7usize,
                                          0x15c3d7usize,
                                          0x19c3d7usize,
                                          0x1dc3d7usize,
                                          0x1cbd7usize,
                                          0x5cbd7usize,
                                          0x9cbd7usize,
                                          0xdcbd7usize,
                                          0x11cbd7usize,
                                          0x15cbd7usize,
                                          0x19cbd7usize,
                                          0x1dcbd7usize,
                                          0x1d3d7usize,
                                          0x5d3d7usize,
                                          0x9d3d7usize,
                                          0xdd3d7usize,
                                          0x11d3d7usize,
                                          0x15d3d7usize,
                                          0x19d3d7usize,
                                          0x1dd3d7usize,
                                          0x1dbd7usize,
                                          0x5dbd7usize,
                                          0x9dbd7usize,
                                          0xddbd7usize,
                                          0x11dbd7usize,
                                          0x15dbd7usize,
                                          0x19dbd7usize,
                                          0x1ddbd7usize,
                                          0x1e3d7usize,
                                          0x5e3d7usize,
                                          0x9e3d7usize,
                                          0xde3d7usize,
                                          0x11e3d7usize,
                                          0x15e3d7usize,
                                          0x19e3d7usize,
                                          0x1de3d7usize,
                                          0x1ebd7usize,
                                          0x5ebd7usize,
                                          0x9ebd7usize,
                                          0xdebd7usize,
                                          0x11ebd7usize,
                                          0x15ebd7usize,
                                          0x19ebd7usize,
                                          0x1debd7usize,
                                          0x1f3d7usize,
                                          0x5f3d7usize,
                                          0x9f3d7usize,
                                          0xdf3d7usize,
                                          0x11f3d7usize,
                                          0x15f3d7usize,
                                          0x19f3d7usize,
                                          0x1df3d7usize,
                                          0x1fbd7usize,
                                          0x5fbd7usize,
                                          0x9fbd7usize,
                                          0xdfbd7usize,
                                          0x11fbd7usize,
                                          0x15fbd7usize,
                                          0x19fbd7usize,
                                          0x1dfbd7usize,
                                          0x1c3e7usize,
                                          0x5c3e7usize,
                                          0x9c3e7usize,
                                          0xdc3e7usize,
                                          0x11c3e7usize,
                                          0x15c3e7usize,
                                          0x19c3e7usize,
                                          0x1dc3e7usize,
                                          0x1cbe7usize,
                                          0x5cbe7usize,
                                          0x9cbe7usize,
                                          0xdcbe7usize,
                                          0x11cbe7usize,
                                          0x15cbe7usize,
                                          0x19cbe7usize,
                                          0x1dcbe7usize,
                                          0x1d3e7usize,
                                          0x5d3e7usize,
                                          0x9d3e7usize,
                                          0xdd3e7usize,
                                          0x11d3e7usize,
                                          0x15d3e7usize,
                                          0x19d3e7usize,
                                          0x1dd3e7usize,
                                          0x1dbe7usize,
                                          0x5dbe7usize,
                                          0x9dbe7usize,
                                          0xddbe7usize,
                                          0x11dbe7usize,
                                          0x15dbe7usize,
                                          0x19dbe7usize,
                                          0x1ddbe7usize,
                                          0x1e3e7usize,
                                          0x5e3e7usize,
                                          0x9e3e7usize,
                                          0xde3e7usize,
                                          0x11e3e7usize,
                                          0x15e3e7usize,
                                          0x19e3e7usize,
                                          0x1de3e7usize,
                                          0x1ebe7usize,
                                          0x5ebe7usize,
                                          0x9ebe7usize,
                                          0xdebe7usize,
                                          0x11ebe7usize,
                                          0x15ebe7usize,
                                          0x19ebe7usize,
                                          0x1debe7usize,
                                          0x1f3e7usize,
                                          0x5f3e7usize,
                                          0x9f3e7usize,
                                          0xdf3e7usize,
                                          0x11f3e7usize,
                                          0x15f3e7usize,
                                          0x19f3e7usize,
                                          0x1df3e7usize,
                                          0x1fbe7usize,
                                          0x5fbe7usize,
                                          0x9fbe7usize,
                                          0xdfbe7usize,
                                          0x11fbe7usize,
                                          0x15fbe7usize,
                                          0x19fbe7usize,
                                          0x1dfbe7usize,
                                          0x1c3f7usize,
                                          0x5c3f7usize,
                                          0x9c3f7usize,
                                          0xdc3f7usize,
                                          0x11c3f7usize,
                                          0x15c3f7usize,
                                          0x19c3f7usize,
                                          0x1dc3f7usize,
                                          0x1cbf7usize,
                                          0x5cbf7usize,
                                          0x9cbf7usize,
                                          0xdcbf7usize,
                                          0x11cbf7usize,
                                          0x15cbf7usize,
                                          0x19cbf7usize,
                                          0x1dcbf7usize,
                                          0x1d3f7usize,
                                          0x5d3f7usize,
                                          0x9d3f7usize,
                                          0xdd3f7usize,
                                          0x11d3f7usize,
                                          0x15d3f7usize,
                                          0x19d3f7usize,
                                          0x1dd3f7usize,
                                          0x1dbf7usize,
                                          0x5dbf7usize,
                                          0x9dbf7usize,
                                          0xddbf7usize,
                                          0x11dbf7usize,
                                          0x15dbf7usize,
                                          0x19dbf7usize,
                                          0x1ddbf7usize,
                                          0x1e3f7usize,
                                          0x5e3f7usize,
                                          0x9e3f7usize,
                                          0xde3f7usize,
                                          0x11e3f7usize,
                                          0x15e3f7usize,
                                          0x19e3f7usize,
                                          0x1de3f7usize,
                                          0x1ebf7usize,
                                          0x5ebf7usize,
                                          0x9ebf7usize,
                                          0xdebf7usize,
                                          0x11ebf7usize,
                                          0x15ebf7usize,
                                          0x19ebf7usize,
                                          0x1debf7usize,
                                          0x1f3f7usize,
                                          0x5f3f7usize,
                                          0x9f3f7usize,
                                          0xdf3f7usize,
                                          0x11f3f7usize,
                                          0x15f3f7usize,
                                          0x19f3f7usize,
                                          0x1df3f7usize,
                                          0x1fbf7usize,
                                          0x5fbf7usize,
                                          0x9fbf7usize,
                                          0xdfbf7usize,
                                          0x11fbf7usize,
                                          0x15fbf7usize,
                                          0x19fbf7usize,
                                          0x1dfbf7usize,
                                          0xe1c387usize,
                                          0x2e1c387usize,
                                          0x4e1c387usize,
                                          0x6e1c387usize,
                                          0x8e1c387usize,
                                          0xae1c387usize,
                                          0xce1c387usize,
                                          0xee1c387usize,
                                          0xe5c387usize,
                                          0x2e5c387usize,
                                          0x4e5c387usize,
                                          0x6e5c387usize,
                                          0x8e5c387usize,
                                          0xae5c387usize,
                                          0xce5c387usize,
                                          0xee5c387usize,
                                          0xe9c387usize,
                                          0x2e9c387usize,
                                          0x4e9c387usize,
                                          0x6e9c387usize,
                                          0x8e9c387usize,
                                          0xae9c387usize,
                                          0xce9c387usize,
                                          0xee9c387usize,
                                          0xedc387usize,
                                          0x2edc387usize,
                                          0x4edc387usize,
                                          0x6edc387usize,
                                          0x8edc387usize,
                                          0xaedc387usize,
                                          0xcedc387usize,
                                          0xeedc387usize,
                                          0xf1c387usize,
                                          0x2f1c387usize,
                                          0x4f1c387usize,
                                          0x6f1c387usize,
                                          0x8f1c387usize,
                                          0xaf1c387usize,
                                          0xcf1c387usize,
                                          0xef1c387usize,
                                          0xf5c387usize,
                                          0x2f5c387usize,
                                          0x4f5c387usize,
                                          0x6f5c387usize,
                                          0x8f5c387usize,
                                          0xaf5c387usize,
                                          0xcf5c387usize,
                                          0xef5c387usize,
                                          0xf9c387usize,
                                          0x2f9c387usize,
                                          0x4f9c387usize,
                                          0x6f9c387usize,
                                          0x8f9c387usize,
                                          0xaf9c387usize,
                                          0xcf9c387usize,
                                          0xef9c387usize,
                                          0xfdc387usize,
                                          0x2fdc387usize,
                                          0x4fdc387usize,
                                          0x6fdc387usize,
                                          0x8fdc387usize,
                                          0xafdc387usize,
                                          0xcfdc387usize,
                                          0xefdc387usize,
                                          0xe1cb87usize,
                                          0x2e1cb87usize,
                                          0x4e1cb87usize,
                                          0x6e1cb87usize,
                                          0x8e1cb87usize,
                                          0xae1cb87usize,
                                          0xce1cb87usize,
                                          0xee1cb87usize,
                                          0xe5cb87usize,
                                          0x2e5cb87usize,
                                          0x4e5cb87usize,
                                          0x6e5cb87usize,
                                          0x8e5cb87usize,
                                          0xae5cb87usize,
                                          0xce5cb87usize,
                                          0xee5cb87usize,
                                          0xe9cb87usize,
                                          0x2e9cb87usize,
                                          0x4e9cb87usize,
                                          0x6e9cb87usize,
                                          0x8e9cb87usize,
                                          0xae9cb87usize,
                                          0xce9cb87usize,
                                          0xee9cb87usize,
                                          0xedcb87usize,
                                          0x2edcb87usize,
                                          0x4edcb87usize,
                                          0x6edcb87usize,
                                          0x8edcb87usize,
                                          0xaedcb87usize,
                                          0xcedcb87usize,
                                          0xeedcb87usize,
                                          0xf1cb87usize,
                                          0x2f1cb87usize,
                                          0x4f1cb87usize,
                                          0x6f1cb87usize,
                                          0x8f1cb87usize,
                                          0xaf1cb87usize,
                                          0xcf1cb87usize,
                                          0xef1cb87usize,
                                          0xf5cb87usize,
                                          0x2f5cb87usize,
                                          0x4f5cb87usize,
                                          0x6f5cb87usize,
                                          0x8f5cb87usize,
                                          0xaf5cb87usize,
                                          0xcf5cb87usize,
                                          0xef5cb87usize,
                                          0xf9cb87usize,
                                          0x2f9cb87usize,
                                          0x4f9cb87usize,
                                          0x6f9cb87usize,
                                          0x8f9cb87usize];

pub static kZeroRepsDepth: [u32; 704] =
  [0u32, 4u32, 8u32, 7u32, 7u32, 7u32, 7u32, 7u32, 7u32, 7u32, 7u32, 11u32, 14u32, 14u32, 14u32,
   14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32,
   14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32,
   14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32,
   14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32,
   14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 14u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32, 21u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32,
   28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32, 28u32];

pub static kUTF8ContextLookup: [u8; 512] =
  [0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   8, 12, 16, 12, 12, 20, 12, 16, 24, 28, 12, 12, 32, 12, 36, 12, 44, 44, 44, 44, 44, 44, 44, 44,
   44, 44, 32, 32, 24, 40, 28, 12, 12, 48, 52, 52, 52, 48, 52, 52, 52, 48, 52, 52, 52, 52, 52, 48,
   52, 52, 52, 52, 52, 48, 52, 52, 52, 52, 52, 24, 12, 28, 12, 12, 12, 56, 60, 60, 60, 56, 60, 60,
   60, 56, 60, 60, 60, 60, 60, 56, 60, 60, 60, 60, 60, 56, 60, 60, 60, 60, 60, 24, 12, 28, 12, 0,
   0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
   0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
   2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
   2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
   1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,
   1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2];

pub static kSigned3BitContextLookup: [u8; 256] =
  [0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
   3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
   3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
   4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
   4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
   5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
   5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7];

pub static kBrotliMinWindowBits: i32 = 10i32;

pub static kBrotliMaxWindowBits: i32 = 24i32;

pub static kCodeLengthDepth: [u8; 18] = [4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8),
                                         5i32 as (u8),
                                         5i32 as (u8),
                                         0i32 as (u8),
                                         4i32 as (u8),
                                         4i32 as (u8)];


pub static kStaticDistanceCodeDepth: [u8; 64] = [6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8),
                                                 6i32 as (u8)];

pub static kCodeLengthBits: [u32; 18] = [0u32, 8u32, 4u32, 12u32, 2u32, 10u32, 6u32, 14u32, 1u32,
                                         9u32, 5u32, 13u32, 3u32, 15u32, 31u32, 0u32, 11u32, 7u32];
pub static kNonZeroRepsBits: [usize; 704] = [0xbusize,
                                             0x1busize,
                                             0x2busize,
                                             0x3busize,
                                             0x2cbusize,
                                             0x6cbusize,
                                             0xacbusize,
                                             0xecbusize,
                                             0x2dbusize,
                                             0x6dbusize,
                                             0xadbusize,
                                             0xedbusize,
                                             0x2ebusize,
                                             0x6ebusize,
                                             0xaebusize,
                                             0xeebusize,
                                             0x2fbusize,
                                             0x6fbusize,
                                             0xafbusize,
                                             0xefbusize,
                                             0xb2cbusize,
                                             0x1b2cbusize,
                                             0x2b2cbusize,
                                             0x3b2cbusize,
                                             0xb6cbusize,
                                             0x1b6cbusize,
                                             0x2b6cbusize,
                                             0x3b6cbusize,
                                             0xbacbusize,
                                             0x1bacbusize,
                                             0x2bacbusize,
                                             0x3bacbusize,
                                             0xbecbusize,
                                             0x1becbusize,
                                             0x2becbusize,
                                             0x3becbusize,
                                             0xb2dbusize,
                                             0x1b2dbusize,
                                             0x2b2dbusize,
                                             0x3b2dbusize,
                                             0xb6dbusize,
                                             0x1b6dbusize,
                                             0x2b6dbusize,
                                             0x3b6dbusize,
                                             0xbadbusize,
                                             0x1badbusize,
                                             0x2badbusize,
                                             0x3badbusize,
                                             0xbedbusize,
                                             0x1bedbusize,
                                             0x2bedbusize,
                                             0x3bedbusize,
                                             0xb2ebusize,
                                             0x1b2ebusize,
                                             0x2b2ebusize,
                                             0x3b2ebusize,
                                             0xb6ebusize,
                                             0x1b6ebusize,
                                             0x2b6ebusize,
                                             0x3b6ebusize,
                                             0xbaebusize,
                                             0x1baebusize,
                                             0x2baebusize,
                                             0x3baebusize,
                                             0xbeebusize,
                                             0x1beebusize,
                                             0x2beebusize,
                                             0x3beebusize,
                                             0xb2fbusize,
                                             0x1b2fbusize,
                                             0x2b2fbusize,
                                             0x3b2fbusize,
                                             0xb6fbusize,
                                             0x1b6fbusize,
                                             0x2b6fbusize,
                                             0x3b6fbusize,
                                             0xbafbusize,
                                             0x1bafbusize,
                                             0x2bafbusize,
                                             0x3bafbusize,
                                             0xbefbusize,
                                             0x1befbusize,
                                             0x2befbusize,
                                             0x3befbusize,
                                             0x2cb2cbusize,
                                             0x6cb2cbusize,
                                             0xacb2cbusize,
                                             0xecb2cbusize,
                                             0x2db2cbusize,
                                             0x6db2cbusize,
                                             0xadb2cbusize,
                                             0xedb2cbusize,
                                             0x2eb2cbusize,
                                             0x6eb2cbusize,
                                             0xaeb2cbusize,
                                             0xeeb2cbusize,
                                             0x2fb2cbusize,
                                             0x6fb2cbusize,
                                             0xafb2cbusize,
                                             0xefb2cbusize,
                                             0x2cb6cbusize,
                                             0x6cb6cbusize,
                                             0xacb6cbusize,
                                             0xecb6cbusize,
                                             0x2db6cbusize,
                                             0x6db6cbusize,
                                             0xadb6cbusize,
                                             0xedb6cbusize,
                                             0x2eb6cbusize,
                                             0x6eb6cbusize,
                                             0xaeb6cbusize,
                                             0xeeb6cbusize,
                                             0x2fb6cbusize,
                                             0x6fb6cbusize,
                                             0xafb6cbusize,
                                             0xefb6cbusize,
                                             0x2cbacbusize,
                                             0x6cbacbusize,
                                             0xacbacbusize,
                                             0xecbacbusize,
                                             0x2dbacbusize,
                                             0x6dbacbusize,
                                             0xadbacbusize,
                                             0xedbacbusize,
                                             0x2ebacbusize,
                                             0x6ebacbusize,
                                             0xaebacbusize,
                                             0xeebacbusize,
                                             0x2fbacbusize,
                                             0x6fbacbusize,
                                             0xafbacbusize,
                                             0xefbacbusize,
                                             0x2cbecbusize,
                                             0x6cbecbusize,
                                             0xacbecbusize,
                                             0xecbecbusize,
                                             0x2dbecbusize,
                                             0x6dbecbusize,
                                             0xadbecbusize,
                                             0xedbecbusize,
                                             0x2ebecbusize,
                                             0x6ebecbusize,
                                             0xaebecbusize,
                                             0xeebecbusize,
                                             0x2fbecbusize,
                                             0x6fbecbusize,
                                             0xafbecbusize,
                                             0xefbecbusize,
                                             0x2cb2dbusize,
                                             0x6cb2dbusize,
                                             0xacb2dbusize,
                                             0xecb2dbusize,
                                             0x2db2dbusize,
                                             0x6db2dbusize,
                                             0xadb2dbusize,
                                             0xedb2dbusize,
                                             0x2eb2dbusize,
                                             0x6eb2dbusize,
                                             0xaeb2dbusize,
                                             0xeeb2dbusize,
                                             0x2fb2dbusize,
                                             0x6fb2dbusize,
                                             0xafb2dbusize,
                                             0xefb2dbusize,
                                             0x2cb6dbusize,
                                             0x6cb6dbusize,
                                             0xacb6dbusize,
                                             0xecb6dbusize,
                                             0x2db6dbusize,
                                             0x6db6dbusize,
                                             0xadb6dbusize,
                                             0xedb6dbusize,
                                             0x2eb6dbusize,
                                             0x6eb6dbusize,
                                             0xaeb6dbusize,
                                             0xeeb6dbusize,
                                             0x2fb6dbusize,
                                             0x6fb6dbusize,
                                             0xafb6dbusize,
                                             0xefb6dbusize,
                                             0x2cbadbusize,
                                             0x6cbadbusize,
                                             0xacbadbusize,
                                             0xecbadbusize,
                                             0x2dbadbusize,
                                             0x6dbadbusize,
                                             0xadbadbusize,
                                             0xedbadbusize,
                                             0x2ebadbusize,
                                             0x6ebadbusize,
                                             0xaebadbusize,
                                             0xeebadbusize,
                                             0x2fbadbusize,
                                             0x6fbadbusize,
                                             0xafbadbusize,
                                             0xefbadbusize,
                                             0x2cbedbusize,
                                             0x6cbedbusize,
                                             0xacbedbusize,
                                             0xecbedbusize,
                                             0x2dbedbusize,
                                             0x6dbedbusize,
                                             0xadbedbusize,
                                             0xedbedbusize,
                                             0x2ebedbusize,
                                             0x6ebedbusize,
                                             0xaebedbusize,
                                             0xeebedbusize,
                                             0x2fbedbusize,
                                             0x6fbedbusize,
                                             0xafbedbusize,
                                             0xefbedbusize,
                                             0x2cb2ebusize,
                                             0x6cb2ebusize,
                                             0xacb2ebusize,
                                             0xecb2ebusize,
                                             0x2db2ebusize,
                                             0x6db2ebusize,
                                             0xadb2ebusize,
                                             0xedb2ebusize,
                                             0x2eb2ebusize,
                                             0x6eb2ebusize,
                                             0xaeb2ebusize,
                                             0xeeb2ebusize,
                                             0x2fb2ebusize,
                                             0x6fb2ebusize,
                                             0xafb2ebusize,
                                             0xefb2ebusize,
                                             0x2cb6ebusize,
                                             0x6cb6ebusize,
                                             0xacb6ebusize,
                                             0xecb6ebusize,
                                             0x2db6ebusize,
                                             0x6db6ebusize,
                                             0xadb6ebusize,
                                             0xedb6ebusize,
                                             0x2eb6ebusize,
                                             0x6eb6ebusize,
                                             0xaeb6ebusize,
                                             0xeeb6ebusize,
                                             0x2fb6ebusize,
                                             0x6fb6ebusize,
                                             0xafb6ebusize,
                                             0xefb6ebusize,
                                             0x2cbaebusize,
                                             0x6cbaebusize,
                                             0xacbaebusize,
                                             0xecbaebusize,
                                             0x2dbaebusize,
                                             0x6dbaebusize,
                                             0xadbaebusize,
                                             0xedbaebusize,
                                             0x2ebaebusize,
                                             0x6ebaebusize,
                                             0xaebaebusize,
                                             0xeebaebusize,
                                             0x2fbaebusize,
                                             0x6fbaebusize,
                                             0xafbaebusize,
                                             0xefbaebusize,
                                             0x2cbeebusize,
                                             0x6cbeebusize,
                                             0xacbeebusize,
                                             0xecbeebusize,
                                             0x2dbeebusize,
                                             0x6dbeebusize,
                                             0xadbeebusize,
                                             0xedbeebusize,
                                             0x2ebeebusize,
                                             0x6ebeebusize,
                                             0xaebeebusize,
                                             0xeebeebusize,
                                             0x2fbeebusize,
                                             0x6fbeebusize,
                                             0xafbeebusize,
                                             0xefbeebusize,
                                             0x2cb2fbusize,
                                             0x6cb2fbusize,
                                             0xacb2fbusize,
                                             0xecb2fbusize,
                                             0x2db2fbusize,
                                             0x6db2fbusize,
                                             0xadb2fbusize,
                                             0xedb2fbusize,
                                             0x2eb2fbusize,
                                             0x6eb2fbusize,
                                             0xaeb2fbusize,
                                             0xeeb2fbusize,
                                             0x2fb2fbusize,
                                             0x6fb2fbusize,
                                             0xafb2fbusize,
                                             0xefb2fbusize,
                                             0x2cb6fbusize,
                                             0x6cb6fbusize,
                                             0xacb6fbusize,
                                             0xecb6fbusize,
                                             0x2db6fbusize,
                                             0x6db6fbusize,
                                             0xadb6fbusize,
                                             0xedb6fbusize,
                                             0x2eb6fbusize,
                                             0x6eb6fbusize,
                                             0xaeb6fbusize,
                                             0xeeb6fbusize,
                                             0x2fb6fbusize,
                                             0x6fb6fbusize,
                                             0xafb6fbusize,
                                             0xefb6fbusize,
                                             0x2cbafbusize,
                                             0x6cbafbusize,
                                             0xacbafbusize,
                                             0xecbafbusize,
                                             0x2dbafbusize,
                                             0x6dbafbusize,
                                             0xadbafbusize,
                                             0xedbafbusize,
                                             0x2ebafbusize,
                                             0x6ebafbusize,
                                             0xaebafbusize,
                                             0xeebafbusize,
                                             0x2fbafbusize,
                                             0x6fbafbusize,
                                             0xafbafbusize,
                                             0xefbafbusize,
                                             0x2cbefbusize,
                                             0x6cbefbusize,
                                             0xacbefbusize,
                                             0xecbefbusize,
                                             0x2dbefbusize,
                                             0x6dbefbusize,
                                             0xadbefbusize,
                                             0xedbefbusize,
                                             0x2ebefbusize,
                                             0x6ebefbusize,
                                             0xaebefbusize,
                                             0xeebefbusize,
                                             0x2fbefbusize,
                                             0x6fbefbusize,
                                             0xafbefbusize,
                                             0xefbefbusize,
                                             0xb2cb2cbusize,
                                             0x1b2cb2cbusize,
                                             0x2b2cb2cbusize,
                                             0x3b2cb2cbusize,
                                             0xb6cb2cbusize,
                                             0x1b6cb2cbusize,
                                             0x2b6cb2cbusize,
                                             0x3b6cb2cbusize,
                                             0xbacb2cbusize,
                                             0x1bacb2cbusize,
                                             0x2bacb2cbusize,
                                             0x3bacb2cbusize,
                                             0xbecb2cbusize,
                                             0x1becb2cbusize,
                                             0x2becb2cbusize,
                                             0x3becb2cbusize,
                                             0xb2db2cbusize,
                                             0x1b2db2cbusize,
                                             0x2b2db2cbusize,
                                             0x3b2db2cbusize,
                                             0xb6db2cbusize,
                                             0x1b6db2cbusize,
                                             0x2b6db2cbusize,
                                             0x3b6db2cbusize,
                                             0xbadb2cbusize,
                                             0x1badb2cbusize,
                                             0x2badb2cbusize,
                                             0x3badb2cbusize,
                                             0xbedb2cbusize,
                                             0x1bedb2cbusize,
                                             0x2bedb2cbusize,
                                             0x3bedb2cbusize,
                                             0xb2eb2cbusize,
                                             0x1b2eb2cbusize,
                                             0x2b2eb2cbusize,
                                             0x3b2eb2cbusize,
                                             0xb6eb2cbusize,
                                             0x1b6eb2cbusize,
                                             0x2b6eb2cbusize,
                                             0x3b6eb2cbusize,
                                             0xbaeb2cbusize,
                                             0x1baeb2cbusize,
                                             0x2baeb2cbusize,
                                             0x3baeb2cbusize,
                                             0xbeeb2cbusize,
                                             0x1beeb2cbusize,
                                             0x2beeb2cbusize,
                                             0x3beeb2cbusize,
                                             0xb2fb2cbusize,
                                             0x1b2fb2cbusize,
                                             0x2b2fb2cbusize,
                                             0x3b2fb2cbusize,
                                             0xb6fb2cbusize,
                                             0x1b6fb2cbusize,
                                             0x2b6fb2cbusize,
                                             0x3b6fb2cbusize,
                                             0xbafb2cbusize,
                                             0x1bafb2cbusize,
                                             0x2bafb2cbusize,
                                             0x3bafb2cbusize,
                                             0xbefb2cbusize,
                                             0x1befb2cbusize,
                                             0x2befb2cbusize,
                                             0x3befb2cbusize,
                                             0xb2cb6cbusize,
                                             0x1b2cb6cbusize,
                                             0x2b2cb6cbusize,
                                             0x3b2cb6cbusize,
                                             0xb6cb6cbusize,
                                             0x1b6cb6cbusize,
                                             0x2b6cb6cbusize,
                                             0x3b6cb6cbusize,
                                             0xbacb6cbusize,
                                             0x1bacb6cbusize,
                                             0x2bacb6cbusize,
                                             0x3bacb6cbusize,
                                             0xbecb6cbusize,
                                             0x1becb6cbusize,
                                             0x2becb6cbusize,
                                             0x3becb6cbusize,
                                             0xb2db6cbusize,
                                             0x1b2db6cbusize,
                                             0x2b2db6cbusize,
                                             0x3b2db6cbusize,
                                             0xb6db6cbusize,
                                             0x1b6db6cbusize,
                                             0x2b6db6cbusize,
                                             0x3b6db6cbusize,
                                             0xbadb6cbusize,
                                             0x1badb6cbusize,
                                             0x2badb6cbusize,
                                             0x3badb6cbusize,
                                             0xbedb6cbusize,
                                             0x1bedb6cbusize,
                                             0x2bedb6cbusize,
                                             0x3bedb6cbusize,
                                             0xb2eb6cbusize,
                                             0x1b2eb6cbusize,
                                             0x2b2eb6cbusize,
                                             0x3b2eb6cbusize,
                                             0xb6eb6cbusize,
                                             0x1b6eb6cbusize,
                                             0x2b6eb6cbusize,
                                             0x3b6eb6cbusize,
                                             0xbaeb6cbusize,
                                             0x1baeb6cbusize,
                                             0x2baeb6cbusize,
                                             0x3baeb6cbusize,
                                             0xbeeb6cbusize,
                                             0x1beeb6cbusize,
                                             0x2beeb6cbusize,
                                             0x3beeb6cbusize,
                                             0xb2fb6cbusize,
                                             0x1b2fb6cbusize,
                                             0x2b2fb6cbusize,
                                             0x3b2fb6cbusize,
                                             0xb6fb6cbusize,
                                             0x1b6fb6cbusize,
                                             0x2b6fb6cbusize,
                                             0x3b6fb6cbusize,
                                             0xbafb6cbusize,
                                             0x1bafb6cbusize,
                                             0x2bafb6cbusize,
                                             0x3bafb6cbusize,
                                             0xbefb6cbusize,
                                             0x1befb6cbusize,
                                             0x2befb6cbusize,
                                             0x3befb6cbusize,
                                             0xb2cbacbusize,
                                             0x1b2cbacbusize,
                                             0x2b2cbacbusize,
                                             0x3b2cbacbusize,
                                             0xb6cbacbusize,
                                             0x1b6cbacbusize,
                                             0x2b6cbacbusize,
                                             0x3b6cbacbusize,
                                             0xbacbacbusize,
                                             0x1bacbacbusize,
                                             0x2bacbacbusize,
                                             0x3bacbacbusize,
                                             0xbecbacbusize,
                                             0x1becbacbusize,
                                             0x2becbacbusize,
                                             0x3becbacbusize,
                                             0xb2dbacbusize,
                                             0x1b2dbacbusize,
                                             0x2b2dbacbusize,
                                             0x3b2dbacbusize,
                                             0xb6dbacbusize,
                                             0x1b6dbacbusize,
                                             0x2b6dbacbusize,
                                             0x3b6dbacbusize,
                                             0xbadbacbusize,
                                             0x1badbacbusize,
                                             0x2badbacbusize,
                                             0x3badbacbusize,
                                             0xbedbacbusize,
                                             0x1bedbacbusize,
                                             0x2bedbacbusize,
                                             0x3bedbacbusize,
                                             0xb2ebacbusize,
                                             0x1b2ebacbusize,
                                             0x2b2ebacbusize,
                                             0x3b2ebacbusize,
                                             0xb6ebacbusize,
                                             0x1b6ebacbusize,
                                             0x2b6ebacbusize,
                                             0x3b6ebacbusize,
                                             0xbaebacbusize,
                                             0x1baebacbusize,
                                             0x2baebacbusize,
                                             0x3baebacbusize,
                                             0xbeebacbusize,
                                             0x1beebacbusize,
                                             0x2beebacbusize,
                                             0x3beebacbusize,
                                             0xb2fbacbusize,
                                             0x1b2fbacbusize,
                                             0x2b2fbacbusize,
                                             0x3b2fbacbusize,
                                             0xb6fbacbusize,
                                             0x1b6fbacbusize,
                                             0x2b6fbacbusize,
                                             0x3b6fbacbusize,
                                             0xbafbacbusize,
                                             0x1bafbacbusize,
                                             0x2bafbacbusize,
                                             0x3bafbacbusize,
                                             0xbefbacbusize,
                                             0x1befbacbusize,
                                             0x2befbacbusize,
                                             0x3befbacbusize,
                                             0xb2cbecbusize,
                                             0x1b2cbecbusize,
                                             0x2b2cbecbusize,
                                             0x3b2cbecbusize,
                                             0xb6cbecbusize,
                                             0x1b6cbecbusize,
                                             0x2b6cbecbusize,
                                             0x3b6cbecbusize,
                                             0xbacbecbusize,
                                             0x1bacbecbusize,
                                             0x2bacbecbusize,
                                             0x3bacbecbusize,
                                             0xbecbecbusize,
                                             0x1becbecbusize,
                                             0x2becbecbusize,
                                             0x3becbecbusize,
                                             0xb2dbecbusize,
                                             0x1b2dbecbusize,
                                             0x2b2dbecbusize,
                                             0x3b2dbecbusize,
                                             0xb6dbecbusize,
                                             0x1b6dbecbusize,
                                             0x2b6dbecbusize,
                                             0x3b6dbecbusize,
                                             0xbadbecbusize,
                                             0x1badbecbusize,
                                             0x2badbecbusize,
                                             0x3badbecbusize,
                                             0xbedbecbusize,
                                             0x1bedbecbusize,
                                             0x2bedbecbusize,
                                             0x3bedbecbusize,
                                             0xb2ebecbusize,
                                             0x1b2ebecbusize,
                                             0x2b2ebecbusize,
                                             0x3b2ebecbusize,
                                             0xb6ebecbusize,
                                             0x1b6ebecbusize,
                                             0x2b6ebecbusize,
                                             0x3b6ebecbusize,
                                             0xbaebecbusize,
                                             0x1baebecbusize,
                                             0x2baebecbusize,
                                             0x3baebecbusize,
                                             0xbeebecbusize,
                                             0x1beebecbusize,
                                             0x2beebecbusize,
                                             0x3beebecbusize,
                                             0xb2fbecbusize,
                                             0x1b2fbecbusize,
                                             0x2b2fbecbusize,
                                             0x3b2fbecbusize,
                                             0xb6fbecbusize,
                                             0x1b6fbecbusize,
                                             0x2b6fbecbusize,
                                             0x3b6fbecbusize,
                                             0xbafbecbusize,
                                             0x1bafbecbusize,
                                             0x2bafbecbusize,
                                             0x3bafbecbusize,
                                             0xbefbecbusize,
                                             0x1befbecbusize,
                                             0x2befbecbusize,
                                             0x3befbecbusize,
                                             0xb2cb2dbusize,
                                             0x1b2cb2dbusize,
                                             0x2b2cb2dbusize,
                                             0x3b2cb2dbusize,
                                             0xb6cb2dbusize,
                                             0x1b6cb2dbusize,
                                             0x2b6cb2dbusize,
                                             0x3b6cb2dbusize,
                                             0xbacb2dbusize,
                                             0x1bacb2dbusize,
                                             0x2bacb2dbusize,
                                             0x3bacb2dbusize,
                                             0xbecb2dbusize,
                                             0x1becb2dbusize,
                                             0x2becb2dbusize,
                                             0x3becb2dbusize,
                                             0xb2db2dbusize,
                                             0x1b2db2dbusize,
                                             0x2b2db2dbusize,
                                             0x3b2db2dbusize,
                                             0xb6db2dbusize,
                                             0x1b6db2dbusize,
                                             0x2b6db2dbusize,
                                             0x3b6db2dbusize,
                                             0xbadb2dbusize,
                                             0x1badb2dbusize,
                                             0x2badb2dbusize,
                                             0x3badb2dbusize,
                                             0xbedb2dbusize,
                                             0x1bedb2dbusize,
                                             0x2bedb2dbusize,
                                             0x3bedb2dbusize,
                                             0xb2eb2dbusize,
                                             0x1b2eb2dbusize,
                                             0x2b2eb2dbusize,
                                             0x3b2eb2dbusize,
                                             0xb6eb2dbusize,
                                             0x1b6eb2dbusize,
                                             0x2b6eb2dbusize,
                                             0x3b6eb2dbusize,
                                             0xbaeb2dbusize,
                                             0x1baeb2dbusize,
                                             0x2baeb2dbusize,
                                             0x3baeb2dbusize,
                                             0xbeeb2dbusize,
                                             0x1beeb2dbusize,
                                             0x2beeb2dbusize,
                                             0x3beeb2dbusize,
                                             0xb2fb2dbusize,
                                             0x1b2fb2dbusize,
                                             0x2b2fb2dbusize,
                                             0x3b2fb2dbusize,
                                             0xb6fb2dbusize,
                                             0x1b6fb2dbusize,
                                             0x2b6fb2dbusize,
                                             0x3b6fb2dbusize,
                                             0xbafb2dbusize,
                                             0x1bafb2dbusize,
                                             0x2bafb2dbusize,
                                             0x3bafb2dbusize,
                                             0xbefb2dbusize,
                                             0x1befb2dbusize,
                                             0x2befb2dbusize,
                                             0x3befb2dbusize,
                                             0xb2cb6dbusize,
                                             0x1b2cb6dbusize,
                                             0x2b2cb6dbusize,
                                             0x3b2cb6dbusize,
                                             0xb6cb6dbusize,
                                             0x1b6cb6dbusize,
                                             0x2b6cb6dbusize,
                                             0x3b6cb6dbusize,
                                             0xbacb6dbusize,
                                             0x1bacb6dbusize,
                                             0x2bacb6dbusize,
                                             0x3bacb6dbusize,
                                             0xbecb6dbusize,
                                             0x1becb6dbusize,
                                             0x2becb6dbusize,
                                             0x3becb6dbusize,
                                             0xb2db6dbusize,
                                             0x1b2db6dbusize,
                                             0x2b2db6dbusize,
                                             0x3b2db6dbusize,
                                             0xb6db6dbusize,
                                             0x1b6db6dbusize,
                                             0x2b6db6dbusize,
                                             0x3b6db6dbusize,
                                             0xbadb6dbusize,
                                             0x1badb6dbusize,
                                             0x2badb6dbusize,
                                             0x3badb6dbusize,
                                             0xbedb6dbusize,
                                             0x1bedb6dbusize,
                                             0x2bedb6dbusize,
                                             0x3bedb6dbusize,
                                             0xb2eb6dbusize,
                                             0x1b2eb6dbusize,
                                             0x2b2eb6dbusize,
                                             0x3b2eb6dbusize,
                                             0xb6eb6dbusize,
                                             0x1b6eb6dbusize,
                                             0x2b6eb6dbusize,
                                             0x3b6eb6dbusize,
                                             0xbaeb6dbusize,
                                             0x1baeb6dbusize,
                                             0x2baeb6dbusize,
                                             0x3baeb6dbusize];

pub static kNonZeroRepsDepth: [u32; 704] =
  [6u32, 6u32, 6u32, 6u32, 12u32, 12u32, 12u32, 12u32, 12u32, 12u32, 12u32, 12u32, 12u32, 12u32,
   12u32, 12u32, 12u32, 12u32, 12u32, 12u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32,
   18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32,
   18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32,
   18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32,
   18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32, 18u32,
   18u32, 18u32, 18u32, 18u32, 18u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32, 24u32,
   24u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32, 30u32,
   30u32];

pub static kStaticCommandCodeDepth: [u8; 704] = [9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 9i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8),
                                                 11i32 as (u8)];


pub static kStaticDistanceCodeBits: [u16; 64] = [0i32 as (u16),
                                                 32i32 as (u16),
                                                 16i32 as (u16),
                                                 48i32 as (u16),
                                                 8i32 as (u16),
                                                 40i32 as (u16),
                                                 24i32 as (u16),
                                                 56i32 as (u16),
                                                 4i32 as (u16),
                                                 36i32 as (u16),
                                                 20i32 as (u16),
                                                 52i32 as (u16),
                                                 12i32 as (u16),
                                                 44i32 as (u16),
                                                 28i32 as (u16),
                                                 60i32 as (u16),
                                                 2i32 as (u16),
                                                 34i32 as (u16),
                                                 18i32 as (u16),
                                                 50i32 as (u16),
                                                 10i32 as (u16),
                                                 42i32 as (u16),
                                                 26i32 as (u16),
                                                 58i32 as (u16),
                                                 6i32 as (u16),
                                                 38i32 as (u16),
                                                 22i32 as (u16),
                                                 54i32 as (u16),
                                                 14i32 as (u16),
                                                 46i32 as (u16),
                                                 30i32 as (u16),
                                                 62i32 as (u16),
                                                 1i32 as (u16),
                                                 33i32 as (u16),
                                                 17i32 as (u16),
                                                 49i32 as (u16),
                                                 9i32 as (u16),
                                                 41i32 as (u16),
                                                 25i32 as (u16),
                                                 57i32 as (u16),
                                                 5i32 as (u16),
                                                 37i32 as (u16),
                                                 21i32 as (u16),
                                                 53i32 as (u16),
                                                 13i32 as (u16),
                                                 45i32 as (u16),
                                                 29i32 as (u16),
                                                 61i32 as (u16),
                                                 3i32 as (u16),
                                                 35i32 as (u16),
                                                 19i32 as (u16),
                                                 51i32 as (u16),
                                                 11i32 as (u16),
                                                 43i32 as (u16),
                                                 27i32 as (u16),
                                                 59i32 as (u16),
                                                 7i32 as (u16),
                                                 39i32 as (u16),
                                                 23i32 as (u16),
                                                 55i32 as (u16),
                                                 15i32 as (u16),
                                                 47i32 as (u16),
                                                 31i32 as (u16),
                                                 63i32 as (u16)];
pub static kStaticCommandCodeBits: [u16; 704] = [0i32 as (u16),
                                                 256i32 as (u16),
                                                 128i32 as (u16),
                                                 384i32 as (u16),
                                                 64i32 as (u16),
                                                 320i32 as (u16),
                                                 192i32 as (u16),
                                                 448i32 as (u16),
                                                 32i32 as (u16),
                                                 288i32 as (u16),
                                                 160i32 as (u16),
                                                 416i32 as (u16),
                                                 96i32 as (u16),
                                                 352i32 as (u16),
                                                 224i32 as (u16),
                                                 480i32 as (u16),
                                                 16i32 as (u16),
                                                 272i32 as (u16),
                                                 144i32 as (u16),
                                                 400i32 as (u16),
                                                 80i32 as (u16),
                                                 336i32 as (u16),
                                                 208i32 as (u16),
                                                 464i32 as (u16),
                                                 48i32 as (u16),
                                                 304i32 as (u16),
                                                 176i32 as (u16),
                                                 432i32 as (u16),
                                                 112i32 as (u16),
                                                 368i32 as (u16),
                                                 240i32 as (u16),
                                                 496i32 as (u16),
                                                 8i32 as (u16),
                                                 264i32 as (u16),
                                                 136i32 as (u16),
                                                 392i32 as (u16),
                                                 72i32 as (u16),
                                                 328i32 as (u16),
                                                 200i32 as (u16),
                                                 456i32 as (u16),
                                                 40i32 as (u16),
                                                 296i32 as (u16),
                                                 168i32 as (u16),
                                                 424i32 as (u16),
                                                 104i32 as (u16),
                                                 360i32 as (u16),
                                                 232i32 as (u16),
                                                 488i32 as (u16),
                                                 24i32 as (u16),
                                                 280i32 as (u16),
                                                 152i32 as (u16),
                                                 408i32 as (u16),
                                                 88i32 as (u16),
                                                 344i32 as (u16),
                                                 216i32 as (u16),
                                                 472i32 as (u16),
                                                 56i32 as (u16),
                                                 312i32 as (u16),
                                                 184i32 as (u16),
                                                 440i32 as (u16),
                                                 120i32 as (u16),
                                                 376i32 as (u16),
                                                 248i32 as (u16),
                                                 504i32 as (u16),
                                                 4i32 as (u16),
                                                 260i32 as (u16),
                                                 132i32 as (u16),
                                                 388i32 as (u16),
                                                 68i32 as (u16),
                                                 324i32 as (u16),
                                                 196i32 as (u16),
                                                 452i32 as (u16),
                                                 36i32 as (u16),
                                                 292i32 as (u16),
                                                 164i32 as (u16),
                                                 420i32 as (u16),
                                                 100i32 as (u16),
                                                 356i32 as (u16),
                                                 228i32 as (u16),
                                                 484i32 as (u16),
                                                 20i32 as (u16),
                                                 276i32 as (u16),
                                                 148i32 as (u16),
                                                 404i32 as (u16),
                                                 84i32 as (u16),
                                                 340i32 as (u16),
                                                 212i32 as (u16),
                                                 468i32 as (u16),
                                                 52i32 as (u16),
                                                 308i32 as (u16),
                                                 180i32 as (u16),
                                                 436i32 as (u16),
                                                 116i32 as (u16),
                                                 372i32 as (u16),
                                                 244i32 as (u16),
                                                 500i32 as (u16),
                                                 12i32 as (u16),
                                                 268i32 as (u16),
                                                 140i32 as (u16),
                                                 396i32 as (u16),
                                                 76i32 as (u16),
                                                 332i32 as (u16),
                                                 204i32 as (u16),
                                                 460i32 as (u16),
                                                 44i32 as (u16),
                                                 300i32 as (u16),
                                                 172i32 as (u16),
                                                 428i32 as (u16),
                                                 108i32 as (u16),
                                                 364i32 as (u16),
                                                 236i32 as (u16),
                                                 492i32 as (u16),
                                                 28i32 as (u16),
                                                 284i32 as (u16),
                                                 156i32 as (u16),
                                                 412i32 as (u16),
                                                 92i32 as (u16),
                                                 348i32 as (u16),
                                                 220i32 as (u16),
                                                 476i32 as (u16),
                                                 60i32 as (u16),
                                                 316i32 as (u16),
                                                 188i32 as (u16),
                                                 444i32 as (u16),
                                                 124i32 as (u16),
                                                 380i32 as (u16),
                                                 252i32 as (u16),
                                                 508i32 as (u16),
                                                 2i32 as (u16),
                                                 258i32 as (u16),
                                                 130i32 as (u16),
                                                 386i32 as (u16),
                                                 66i32 as (u16),
                                                 322i32 as (u16),
                                                 194i32 as (u16),
                                                 450i32 as (u16),
                                                 34i32 as (u16),
                                                 290i32 as (u16),
                                                 162i32 as (u16),
                                                 418i32 as (u16),
                                                 98i32 as (u16),
                                                 354i32 as (u16),
                                                 226i32 as (u16),
                                                 482i32 as (u16),
                                                 18i32 as (u16),
                                                 274i32 as (u16),
                                                 146i32 as (u16),
                                                 402i32 as (u16),
                                                 82i32 as (u16),
                                                 338i32 as (u16),
                                                 210i32 as (u16),
                                                 466i32 as (u16),
                                                 50i32 as (u16),
                                                 306i32 as (u16),
                                                 178i32 as (u16),
                                                 434i32 as (u16),
                                                 114i32 as (u16),
                                                 370i32 as (u16),
                                                 242i32 as (u16),
                                                 498i32 as (u16),
                                                 10i32 as (u16),
                                                 266i32 as (u16),
                                                 138i32 as (u16),
                                                 394i32 as (u16),
                                                 74i32 as (u16),
                                                 330i32 as (u16),
                                                 202i32 as (u16),
                                                 458i32 as (u16),
                                                 42i32 as (u16),
                                                 298i32 as (u16),
                                                 170i32 as (u16),
                                                 426i32 as (u16),
                                                 106i32 as (u16),
                                                 362i32 as (u16),
                                                 234i32 as (u16),
                                                 490i32 as (u16),
                                                 26i32 as (u16),
                                                 282i32 as (u16),
                                                 154i32 as (u16),
                                                 410i32 as (u16),
                                                 90i32 as (u16),
                                                 346i32 as (u16),
                                                 218i32 as (u16),
                                                 474i32 as (u16),
                                                 58i32 as (u16),
                                                 314i32 as (u16),
                                                 186i32 as (u16),
                                                 442i32 as (u16),
                                                 122i32 as (u16),
                                                 378i32 as (u16),
                                                 250i32 as (u16),
                                                 506i32 as (u16),
                                                 6i32 as (u16),
                                                 262i32 as (u16),
                                                 134i32 as (u16),
                                                 390i32 as (u16),
                                                 70i32 as (u16),
                                                 326i32 as (u16),
                                                 198i32 as (u16),
                                                 454i32 as (u16),
                                                 38i32 as (u16),
                                                 294i32 as (u16),
                                                 166i32 as (u16),
                                                 422i32 as (u16),
                                                 102i32 as (u16),
                                                 358i32 as (u16),
                                                 230i32 as (u16),
                                                 486i32 as (u16),
                                                 22i32 as (u16),
                                                 278i32 as (u16),
                                                 150i32 as (u16),
                                                 406i32 as (u16),
                                                 86i32 as (u16),
                                                 342i32 as (u16),
                                                 214i32 as (u16),
                                                 470i32 as (u16),
                                                 54i32 as (u16),
                                                 310i32 as (u16),
                                                 182i32 as (u16),
                                                 438i32 as (u16),
                                                 118i32 as (u16),
                                                 374i32 as (u16),
                                                 246i32 as (u16),
                                                 502i32 as (u16),
                                                 14i32 as (u16),
                                                 270i32 as (u16),
                                                 142i32 as (u16),
                                                 398i32 as (u16),
                                                 78i32 as (u16),
                                                 334i32 as (u16),
                                                 206i32 as (u16),
                                                 462i32 as (u16),
                                                 46i32 as (u16),
                                                 302i32 as (u16),
                                                 174i32 as (u16),
                                                 430i32 as (u16),
                                                 110i32 as (u16),
                                                 366i32 as (u16),
                                                 238i32 as (u16),
                                                 494i32 as (u16),
                                                 30i32 as (u16),
                                                 286i32 as (u16),
                                                 158i32 as (u16),
                                                 414i32 as (u16),
                                                 94i32 as (u16),
                                                 350i32 as (u16),
                                                 222i32 as (u16),
                                                 478i32 as (u16),
                                                 62i32 as (u16),
                                                 318i32 as (u16),
                                                 190i32 as (u16),
                                                 446i32 as (u16),
                                                 126i32 as (u16),
                                                 382i32 as (u16),
                                                 254i32 as (u16),
                                                 510i32 as (u16),
                                                 1i32 as (u16),
                                                 257i32 as (u16),
                                                 129i32 as (u16),
                                                 385i32 as (u16),
                                                 65i32 as (u16),
                                                 321i32 as (u16),
                                                 193i32 as (u16),
                                                 449i32 as (u16),
                                                 33i32 as (u16),
                                                 289i32 as (u16),
                                                 161i32 as (u16),
                                                 417i32 as (u16),
                                                 97i32 as (u16),
                                                 353i32 as (u16),
                                                 225i32 as (u16),
                                                 481i32 as (u16),
                                                 17i32 as (u16),
                                                 273i32 as (u16),
                                                 145i32 as (u16),
                                                 401i32 as (u16),
                                                 81i32 as (u16),
                                                 337i32 as (u16),
                                                 209i32 as (u16),
                                                 465i32 as (u16),
                                                 49i32 as (u16),
                                                 305i32 as (u16),
                                                 177i32 as (u16),
                                                 433i32 as (u16),
                                                 113i32 as (u16),
                                                 369i32 as (u16),
                                                 241i32 as (u16),
                                                 497i32 as (u16),
                                                 9i32 as (u16),
                                                 265i32 as (u16),
                                                 137i32 as (u16),
                                                 393i32 as (u16),
                                                 73i32 as (u16),
                                                 329i32 as (u16),
                                                 201i32 as (u16),
                                                 457i32 as (u16),
                                                 41i32 as (u16),
                                                 297i32 as (u16),
                                                 169i32 as (u16),
                                                 425i32 as (u16),
                                                 105i32 as (u16),
                                                 361i32 as (u16),
                                                 233i32 as (u16),
                                                 489i32 as (u16),
                                                 25i32 as (u16),
                                                 281i32 as (u16),
                                                 153i32 as (u16),
                                                 409i32 as (u16),
                                                 89i32 as (u16),
                                                 345i32 as (u16),
                                                 217i32 as (u16),
                                                 473i32 as (u16),
                                                 57i32 as (u16),
                                                 313i32 as (u16),
                                                 185i32 as (u16),
                                                 441i32 as (u16),
                                                 121i32 as (u16),
                                                 377i32 as (u16),
                                                 249i32 as (u16),
                                                 505i32 as (u16),
                                                 5i32 as (u16),
                                                 261i32 as (u16),
                                                 133i32 as (u16),
                                                 389i32 as (u16),
                                                 69i32 as (u16),
                                                 325i32 as (u16),
                                                 197i32 as (u16),
                                                 453i32 as (u16),
                                                 37i32 as (u16),
                                                 293i32 as (u16),
                                                 165i32 as (u16),
                                                 421i32 as (u16),
                                                 101i32 as (u16),
                                                 357i32 as (u16),
                                                 229i32 as (u16),
                                                 485i32 as (u16),
                                                 21i32 as (u16),
                                                 277i32 as (u16),
                                                 149i32 as (u16),
                                                 405i32 as (u16),
                                                 85i32 as (u16),
                                                 341i32 as (u16),
                                                 213i32 as (u16),
                                                 469i32 as (u16),
                                                 53i32 as (u16),
                                                 309i32 as (u16),
                                                 181i32 as (u16),
                                                 437i32 as (u16),
                                                 117i32 as (u16),
                                                 373i32 as (u16),
                                                 245i32 as (u16),
                                                 501i32 as (u16),
                                                 13i32 as (u16),
                                                 269i32 as (u16),
                                                 141i32 as (u16),
                                                 397i32 as (u16),
                                                 77i32 as (u16),
                                                 333i32 as (u16),
                                                 205i32 as (u16),
                                                 461i32 as (u16),
                                                 45i32 as (u16),
                                                 301i32 as (u16),
                                                 173i32 as (u16),
                                                 429i32 as (u16),
                                                 109i32 as (u16),
                                                 365i32 as (u16),
                                                 237i32 as (u16),
                                                 493i32 as (u16),
                                                 29i32 as (u16),
                                                 285i32 as (u16),
                                                 157i32 as (u16),
                                                 413i32 as (u16),
                                                 93i32 as (u16),
                                                 349i32 as (u16),
                                                 221i32 as (u16),
                                                 477i32 as (u16),
                                                 61i32 as (u16),
                                                 317i32 as (u16),
                                                 189i32 as (u16),
                                                 445i32 as (u16),
                                                 125i32 as (u16),
                                                 381i32 as (u16),
                                                 253i32 as (u16),
                                                 509i32 as (u16),
                                                 3i32 as (u16),
                                                 259i32 as (u16),
                                                 131i32 as (u16),
                                                 387i32 as (u16),
                                                 67i32 as (u16),
                                                 323i32 as (u16),
                                                 195i32 as (u16),
                                                 451i32 as (u16),
                                                 35i32 as (u16),
                                                 291i32 as (u16),
                                                 163i32 as (u16),
                                                 419i32 as (u16),
                                                 99i32 as (u16),
                                                 355i32 as (u16),
                                                 227i32 as (u16),
                                                 483i32 as (u16),
                                                 19i32 as (u16),
                                                 275i32 as (u16),
                                                 147i32 as (u16),
                                                 403i32 as (u16),
                                                 83i32 as (u16),
                                                 339i32 as (u16),
                                                 211i32 as (u16),
                                                 467i32 as (u16),
                                                 51i32 as (u16),
                                                 307i32 as (u16),
                                                 179i32 as (u16),
                                                 435i32 as (u16),
                                                 115i32 as (u16),
                                                 371i32 as (u16),
                                                 243i32 as (u16),
                                                 499i32 as (u16),
                                                 11i32 as (u16),
                                                 267i32 as (u16),
                                                 139i32 as (u16),
                                                 395i32 as (u16),
                                                 75i32 as (u16),
                                                 331i32 as (u16),
                                                 203i32 as (u16),
                                                 459i32 as (u16),
                                                 43i32 as (u16),
                                                 299i32 as (u16),
                                                 171i32 as (u16),
                                                 427i32 as (u16),
                                                 107i32 as (u16),
                                                 363i32 as (u16),
                                                 235i32 as (u16),
                                                 491i32 as (u16),
                                                 27i32 as (u16),
                                                 283i32 as (u16),
                                                 155i32 as (u16),
                                                 411i32 as (u16),
                                                 91i32 as (u16),
                                                 347i32 as (u16),
                                                 219i32 as (u16),
                                                 475i32 as (u16),
                                                 59i32 as (u16),
                                                 315i32 as (u16),
                                                 187i32 as (u16),
                                                 443i32 as (u16),
                                                 123i32 as (u16),
                                                 379i32 as (u16),
                                                 251i32 as (u16),
                                                 507i32 as (u16),
                                                 7i32 as (u16),
                                                 1031i32 as (u16),
                                                 519i32 as (u16),
                                                 1543i32 as (u16),
                                                 263i32 as (u16),
                                                 1287i32 as (u16),
                                                 775i32 as (u16),
                                                 1799i32 as (u16),
                                                 135i32 as (u16),
                                                 1159i32 as (u16),
                                                 647i32 as (u16),
                                                 1671i32 as (u16),
                                                 391i32 as (u16),
                                                 1415i32 as (u16),
                                                 903i32 as (u16),
                                                 1927i32 as (u16),
                                                 71i32 as (u16),
                                                 1095i32 as (u16),
                                                 583i32 as (u16),
                                                 1607i32 as (u16),
                                                 327i32 as (u16),
                                                 1351i32 as (u16),
                                                 839i32 as (u16),
                                                 1863i32 as (u16),
                                                 199i32 as (u16),
                                                 1223i32 as (u16),
                                                 711i32 as (u16),
                                                 1735i32 as (u16),
                                                 455i32 as (u16),
                                                 1479i32 as (u16),
                                                 967i32 as (u16),
                                                 1991i32 as (u16),
                                                 39i32 as (u16),
                                                 1063i32 as (u16),
                                                 551i32 as (u16),
                                                 1575i32 as (u16),
                                                 295i32 as (u16),
                                                 1319i32 as (u16),
                                                 807i32 as (u16),
                                                 1831i32 as (u16),
                                                 167i32 as (u16),
                                                 1191i32 as (u16),
                                                 679i32 as (u16),
                                                 1703i32 as (u16),
                                                 423i32 as (u16),
                                                 1447i32 as (u16),
                                                 935i32 as (u16),
                                                 1959i32 as (u16),
                                                 103i32 as (u16),
                                                 1127i32 as (u16),
                                                 615i32 as (u16),
                                                 1639i32 as (u16),
                                                 359i32 as (u16),
                                                 1383i32 as (u16),
                                                 871i32 as (u16),
                                                 1895i32 as (u16),
                                                 231i32 as (u16),
                                                 1255i32 as (u16),
                                                 743i32 as (u16),
                                                 1767i32 as (u16),
                                                 487i32 as (u16),
                                                 1511i32 as (u16),
                                                 999i32 as (u16),
                                                 2023i32 as (u16),
                                                 23i32 as (u16),
                                                 1047i32 as (u16),
                                                 535i32 as (u16),
                                                 1559i32 as (u16),
                                                 279i32 as (u16),
                                                 1303i32 as (u16),
                                                 791i32 as (u16),
                                                 1815i32 as (u16),
                                                 151i32 as (u16),
                                                 1175i32 as (u16),
                                                 663i32 as (u16),
                                                 1687i32 as (u16),
                                                 407i32 as (u16),
                                                 1431i32 as (u16),
                                                 919i32 as (u16),
                                                 1943i32 as (u16),
                                                 87i32 as (u16),
                                                 1111i32 as (u16),
                                                 599i32 as (u16),
                                                 1623i32 as (u16),
                                                 343i32 as (u16),
                                                 1367i32 as (u16),
                                                 855i32 as (u16),
                                                 1879i32 as (u16),
                                                 215i32 as (u16),
                                                 1239i32 as (u16),
                                                 727i32 as (u16),
                                                 1751i32 as (u16),
                                                 471i32 as (u16),
                                                 1495i32 as (u16),
                                                 983i32 as (u16),
                                                 2007i32 as (u16),
                                                 55i32 as (u16),
                                                 1079i32 as (u16),
                                                 567i32 as (u16),
                                                 1591i32 as (u16),
                                                 311i32 as (u16),
                                                 1335i32 as (u16),
                                                 823i32 as (u16),
                                                 1847i32 as (u16),
                                                 183i32 as (u16),
                                                 1207i32 as (u16),
                                                 695i32 as (u16),
                                                 1719i32 as (u16),
                                                 439i32 as (u16),
                                                 1463i32 as (u16),
                                                 951i32 as (u16),
                                                 1975i32 as (u16),
                                                 119i32 as (u16),
                                                 1143i32 as (u16),
                                                 631i32 as (u16),
                                                 1655i32 as (u16),
                                                 375i32 as (u16),
                                                 1399i32 as (u16),
                                                 887i32 as (u16),
                                                 1911i32 as (u16),
                                                 247i32 as (u16),
                                                 1271i32 as (u16),
                                                 759i32 as (u16),
                                                 1783i32 as (u16),
                                                 503i32 as (u16),
                                                 1527i32 as (u16),
                                                 1015i32 as (u16),
                                                 2039i32 as (u16),
                                                 15i32 as (u16),
                                                 1039i32 as (u16),
                                                 527i32 as (u16),
                                                 1551i32 as (u16),
                                                 271i32 as (u16),
                                                 1295i32 as (u16),
                                                 783i32 as (u16),
                                                 1807i32 as (u16),
                                                 143i32 as (u16),
                                                 1167i32 as (u16),
                                                 655i32 as (u16),
                                                 1679i32 as (u16),
                                                 399i32 as (u16),
                                                 1423i32 as (u16),
                                                 911i32 as (u16),
                                                 1935i32 as (u16),
                                                 79i32 as (u16),
                                                 1103i32 as (u16),
                                                 591i32 as (u16),
                                                 1615i32 as (u16),
                                                 335i32 as (u16),
                                                 1359i32 as (u16),
                                                 847i32 as (u16),
                                                 1871i32 as (u16),
                                                 207i32 as (u16),
                                                 1231i32 as (u16),
                                                 719i32 as (u16),
                                                 1743i32 as (u16),
                                                 463i32 as (u16),
                                                 1487i32 as (u16),
                                                 975i32 as (u16),
                                                 1999i32 as (u16),
                                                 47i32 as (u16),
                                                 1071i32 as (u16),
                                                 559i32 as (u16),
                                                 1583i32 as (u16),
                                                 303i32 as (u16),
                                                 1327i32 as (u16),
                                                 815i32 as (u16),
                                                 1839i32 as (u16),
                                                 175i32 as (u16),
                                                 1199i32 as (u16),
                                                 687i32 as (u16),
                                                 1711i32 as (u16),
                                                 431i32 as (u16),
                                                 1455i32 as (u16),
                                                 943i32 as (u16),
                                                 1967i32 as (u16),
                                                 111i32 as (u16),
                                                 1135i32 as (u16),
                                                 623i32 as (u16),
                                                 1647i32 as (u16),
                                                 367i32 as (u16),
                                                 1391i32 as (u16),
                                                 879i32 as (u16),
                                                 1903i32 as (u16),
                                                 239i32 as (u16),
                                                 1263i32 as (u16),
                                                 751i32 as (u16),
                                                 1775i32 as (u16),
                                                 495i32 as (u16),
                                                 1519i32 as (u16),
                                                 1007i32 as (u16),
                                                 2031i32 as (u16),
                                                 31i32 as (u16),
                                                 1055i32 as (u16),
                                                 543i32 as (u16),
                                                 1567i32 as (u16),
                                                 287i32 as (u16),
                                                 1311i32 as (u16),
                                                 799i32 as (u16),
                                                 1823i32 as (u16),
                                                 159i32 as (u16),
                                                 1183i32 as (u16),
                                                 671i32 as (u16),
                                                 1695i32 as (u16),
                                                 415i32 as (u16),
                                                 1439i32 as (u16),
                                                 927i32 as (u16),
                                                 1951i32 as (u16),
                                                 95i32 as (u16),
                                                 1119i32 as (u16),
                                                 607i32 as (u16),
                                                 1631i32 as (u16),
                                                 351i32 as (u16),
                                                 1375i32 as (u16),
                                                 863i32 as (u16),
                                                 1887i32 as (u16),
                                                 223i32 as (u16),
                                                 1247i32 as (u16),
                                                 735i32 as (u16),
                                                 1759i32 as (u16),
                                                 479i32 as (u16),
                                                 1503i32 as (u16),
                                                 991i32 as (u16),
                                                 2015i32 as (u16),
                                                 63i32 as (u16),
                                                 1087i32 as (u16),
                                                 575i32 as (u16),
                                                 1599i32 as (u16),
                                                 319i32 as (u16),
                                                 1343i32 as (u16),
                                                 831i32 as (u16),
                                                 1855i32 as (u16),
                                                 191i32 as (u16),
                                                 1215i32 as (u16),
                                                 703i32 as (u16),
                                                 1727i32 as (u16),
                                                 447i32 as (u16),
                                                 1471i32 as (u16),
                                                 959i32 as (u16),
                                                 1983i32 as (u16),
                                                 127i32 as (u16),
                                                 1151i32 as (u16),
                                                 639i32 as (u16),
                                                 1663i32 as (u16),
                                                 383i32 as (u16),
                                                 1407i32 as (u16),
                                                 895i32 as (u16),
                                                 1919i32 as (u16),
                                                 255i32 as (u16),
                                                 1279i32 as (u16),
                                                 767i32 as (u16),
                                                 1791i32 as (u16),
                                                 511i32 as (u16),
                                                 1535i32 as (u16),
                                                 1023i32 as (u16),
                                                 2047i32 as (u16)];
