// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ModbusDevice.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.modbus {
  public class Device : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("modbus.Device:1.0.0", null);

    public Device(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Device(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Device StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Device(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class DeviceID : ICloneable {
      public object Clone() {
        DeviceID copy = new DeviceID();
        copy.vendor = this.vendor;
        copy.code = this.code;
        copy.version = this.version;
        copy.url = this.url;
        copy.name = this.name;
        copy.model = this.model;
        copy.app = this.app;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["vendor"] = this.vendor;
        json["code"] = this.code;
        json["version"] = this.version;
        json["url"] = this.url;
        json["name"] = this.name;
        json["model"] = this.model;
        json["app"] = this.app;
        return json;
      }

      public static DeviceID Decode(LightJson.JsonObject json, Agent agent) {
        DeviceID inst = new DeviceID();
        inst.vendor = (string)json["vendor"];
        inst.code = (string)json["code"];
        inst.version = (string)json["version"];
        inst.url = (string)json["url"];
        inst.name = (string)json["name"];
        inst.model = (string)json["model"];
        inst.app = (string)json["app"];
        return inst;
      }

      public string vendor = "";
      public string code = "";
      public string version = "";
      public string url = "";
      public string name = "";
      public string model = "";
      public string app = "";
    }

    public class ReadDeviceIdentificationResult {
      public Com.Raritan.Idl.modbus.Device.DeviceID _ret_;
    }

    public ReadDeviceIdentificationResult readDeviceIdentification() {
      JsonObject _parameters = null;
      var _result = RpcCall("readDeviceIdentification", _parameters);
      var _ret = new ReadDeviceIdentificationResult();
      _ret._ret_ = Com.Raritan.Idl.modbus.Device.DeviceID.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest readDeviceIdentification(AsyncRpcResponse<ReadDeviceIdentificationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return readDeviceIdentification(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest readDeviceIdentification(AsyncRpcResponse<ReadDeviceIdentificationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("readDeviceIdentification", _parameters,
        _result => {
          try {
            var _ret = new ReadDeviceIdentificationResult();
            _ret._ret_ = Com.Raritan.Idl.modbus.Device.DeviceID.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
