/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2015 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_renderer.h>
#include <fcml_assembler.h>
#include "instructions_s_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_s_suite_init(void) {
    return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_s_suite_cleanup(void) {
    return FCML_TRUE;
}

void fcml_tf_instruction_SAHF(void) {

    FCML_I3264( "sahf", 0x9E );

    FCML_A64( "sahf", 0x9e );
}

void fcml_tf_instruction_SHL(void) {

    FCML_I32_M( "shl byte ptr [eax],01h", 2, FCML_MI( 0xc0, 0x20, 0x01 ), FCML_MI( 0xd0, 0x20 ) );
    FCML_I32_M( "shl al,01h", 2, FCML_MI( 0xc0, 0xe0, 0x01 ), FCML_MI( 0xd0, 0xe0 ) );
    FCML_I64_D( "shl al,01h", 0x48, 0xD0, 0xE0 );

    FCML_A64_M( "shlb $0x01,(%rax)", 2, FCML_MI( 0xc0, 0x20, 0x01 ), FCML_MI( 0xd0, 0x20 ) );
    FCML_A64_M( "shl $0x01,%al", 2, FCML_MI( 0xc0, 0xe0, 0x01 ), FCML_MI( 0xd0, 0xe0 ) );

    FCML_I32( "shl byte ptr [eax],cl", 0xD2, 0x20 );
    FCML_I32( "shl al,cl", 0xD2, 0xE0 );
    FCML_I64_D( "shl al,cl", 0x48, 0xD2, 0xE0 );

    FCML_A64( "shlb %cl,(%rax)", 0xd2, 0x20 );
    FCML_A64( "shl %cl,%al", 0xd2, 0xe0 );

    FCML_I32( "shl byte ptr [eax],0ffh", 0xC0, 0x20, 0xFF );
    FCML_I32( "shl al,0ffh", 0xC0, 0xE0, 0xFF );
    FCML_I64_D( "shl al,0ffh", 0x48, 0xC0, 0xE0, 0xFF );

    FCML_A64( "shlb $0xff,(%rax)", 0xc0, 0x20, 0xff );
    FCML_A64( "shl $0xff,%al", 0xc0, 0xe0, 0xff );

    FCML_I32_M( "shl dword ptr [eax],01h", 2, FCML_MI( 0xc1, 0x20, 0x01 ), FCML_MI( 0xd1, 0x20 ) );
    FCML_I32_M( "shl eax,01h", 2, FCML_MI( 0xc1, 0xe0, 0x01 ), FCML_MI( 0xd1, 0xe0 ) );
    FCML_I64_M( "shl rax,01h", 2, FCML_MI( 0x48, 0xc1, 0xe0, 0x01 ), FCML_MI( 0x48, 0xd1, 0xe0 ) );

    FCML_A64_M( "shll $0x01,(%rax)", 2, FCML_MI( 0xc1, 0x20, 0x01 ), FCML_MI( 0xd1, 0x20 ) );
    FCML_A32_M( "shll $0x01,(%eax)", 2, FCML_MI( 0xc1, 0x20, 0x01 ), FCML_MI( 0xd1, 0x20 ) );
    FCML_A64_M( "shlw $0x01,(%rax)", 2, FCML_MI( 0x66, 0xc1, 0x20, 0x01 ), FCML_MI( 0x66, 0xd1, 0x20 ) );
    FCML_A64_M( "shlq $0x01,(%rax)", 2, FCML_MI( 0x48, 0xc1, 0x20, 0x01 ), FCML_MI( 0x48, 0xd1, 0x20 ) );
    FCML_A64_M( "shl $0x01,%eax", 2, FCML_MI( 0xc1, 0xe0, 0x01 ), FCML_MI( 0xd1, 0xe0 ) );
    FCML_A64_M( "shl $0x01,%rax", 2, FCML_MI( 0x48, 0xc1, 0xe0, 0x01 ), FCML_MI( 0x48, 0xd1, 0xe0 ) );
    FCML_A64_M( "shl $0x01,%ax", 2, FCML_MI( 0x66, 0xc1, 0xe0, 0x01 ), FCML_MI( 0x66, 0xd1, 0xe0 ) );

    FCML_I32( "shl dword ptr [eax],cl", 0xD3, 0x20 );
    FCML_I32( "shl eax,cl", 0xD3, 0xE0 );
    FCML_I64( "shl rax,cl", 0x48, 0xD3, 0xE0 );

    FCML_A64( "shll %cl,(%rax)", 0xd3, 0x20 );
    FCML_A64( "shl %cl,%eax", 0xd3, 0xe0 );
    FCML_A64( "shl %cl,%rax", 0x48, 0xd3, 0xe0 );

    FCML_I32( "shl dword ptr [eax],0ffh", 0xC1, 0x20, 0xff );
    FCML_I32( "shl eax,0ffh", 0xC1, 0xE0, 0xff );
    FCML_I64( "shl rax,0ffh", 0x48, 0xC1, 0xE0, 0xff );

    FCML_A64( "shll $0xff,(%rax)", 0xc1, 0x20, 0xff );
    FCML_A64( "shl $0xff,%eax", 0xc1, 0xe0, 0xff );
    FCML_A64( "shl $0xff,%rax", 0x48, 0xc1, 0xe0, 0xff );
}

void fcml_tf_instruction_SAL(void) {

    FCML_I32_M_A( "sal byte ptr [eax],01h", 2, FCML_MI( 0xc0, 0x20, 0x01 ), FCML_MI( 0xd0, 0x20 ) );
    FCML_I32_M_A( "sal al,01h", 2, FCML_MI( 0xc0, 0xe0, 0x01 ), FCML_MI( 0xd0, 0xe0 ) );

    FCML_A64_M( "shlb $0x01,(%rax)", 2, FCML_MI( 0xc0, 0x20, 0x01 ), FCML_MI( 0xd0, 0x20 ) );
    FCML_A64_M( "shl $0x01,%al", 2, FCML_MI( 0xc0, 0xe0, 0x01 ), FCML_MI( 0xd0, 0xe0 ) );

    FCML_I32_A( "sal byte ptr [eax],cl", 0xD2, 0x20 );
    FCML_I32_A( "sal al,cl", 0xD2, 0xE0 );

    FCML_A64( "shlb %cl,(%rax)", 0xd2, 0x20 );
    FCML_A64( "shl %cl,%al", 0xd2, 0xe0 );

    FCML_I32_A( "sal byte ptr [eax],0ffh", 0xC0, 0x20, 0xFF );
    FCML_I32_A( "sal al,0ffh", 0xC0, 0xE0, 0xFF );

    FCML_A64( "shlb $0xff,(%rax)", 0xc0, 0x20, 0xff );
    FCML_A64( "shl $0xff,%al", 0xc0, 0xe0, 0xff );

    FCML_I32_M_A( "sal dword ptr [eax],01h", 2, FCML_MI( 0xc1, 0x20, 0x01 ), FCML_MI( 0xd1, 0x20 ) );
    FCML_I32_M_A( "sal eax,01h", 2, FCML_MI( 0xc1, 0xe0, 0x01 ), FCML_MI( 0xd1, 0xe0 ) );
    FCML_I64_M_A( "sal rax,01h", 2, FCML_MI( 0x48, 0xc1, 0xe0, 0x01 ), FCML_MI( 0x48, 0xd1, 0xe0 ) );

    FCML_A64_M_A( "shl $0x01,%rax", 2, FCML_MI( 0x48, 0xc1, 0xe0, 0x01 ), FCML_MI( 0x48, 0xd1, 0xe0 ) );

    FCML_I32_A( "sal dword ptr [eax],cl", 0xD3, 0x20 );
    FCML_I32_A( "sal eax,cl", 0xD3, 0xE0 );
    FCML_I64_A( "sal rax,cl", 0x48, 0xD3, 0xE0 );

    FCML_A64( "shll %cl,(%rax)", 0xd3, 0x20 );
    FCML_A64( "shl %cl,%eax", 0xd3, 0xe0 );
    FCML_A64( "shl %cl,%rax", 0x48, 0xd3, 0xe0 );

    FCML_I32_A( "sal dword ptr [eax],0ffh", 0xC1, 0x20, 0xff );
    FCML_I32_A( "sal eax,0ffh", 0xC1, 0xE0, 0xff );
    FCML_I64_A( "sal rax,0ffh", 0x48, 0xC1, 0xE0, 0xff );

    FCML_A64( "shll $0xff,(%rax)", 0xc1, 0x20, 0xff );
    FCML_A64( "shl $0xff,%eax", 0xc1, 0xe0, 0xff );
    FCML_A64( "shl $0xff,%rax", 0x48, 0xc1, 0xe0, 0xff );
}

void fcml_tf_instruction_SAR(void) {

    FCML_I32_M( "sar byte ptr [eax],01h", 2, FCML_MI( 0xc0, 0x38, 0x01 ), FCML_MI( 0xd0, 0x38 ) );
    FCML_I32_M( "sar al,01h", 2, FCML_MI( 0xc0, 0xf8, 0x01 ), FCML_MI( 0xd0, 0xf8 ) );
    FCML_I64_D( "sar al,01h", 0x48, 0xD0, 0xF8 );

    FCML_A64_M( "sarb $0x01,(%rax)", 2, FCML_MI( 0xc0, 0x38, 0x01 ), FCML_MI( 0xd0, 0x38 ) );
    FCML_A64_M( "sar $0x01,%al", 2, FCML_MI( 0xc0, 0xf8, 0x01 ), FCML_MI( 0xd0, 0xf8 ) );

    FCML_I32( "sar byte ptr [eax],cl", 0xD2, 0x38 );
    FCML_I32( "sar al,cl", 0xD2, 0xF8 );
    FCML_I64_D( "sar al,cl", 0x48, 0xD2, 0xF8 );

    FCML_A64( "sarb %cl,(%rax)", 0xd2, 0x38 );
    FCML_A64( "sar %cl,%al", 0xd2, 0xf8 );

    FCML_I32( "sar byte ptr [eax],0ffh", 0xC0, 0x38, 0xFF );
    FCML_I32( "sar al,0ffh", 0xC0, 0xF8, 0xFF );
    FCML_I64_D( "sar al,0ffh", 0x48, 0xC0, 0xF8, 0xFF );

    FCML_A64( "sarb $0xff,(%rax)", 0xc0, 0x38, 0xff );
    FCML_A64( "sar $0xff,%al", 0xc0, 0xf8, 0xff );

    FCML_I32_M( "sar dword ptr [eax],01h", 2, FCML_MI( 0xc1, 0x38, 0x01 ), FCML_MI( 0xd1, 0x38 ) );
    FCML_I32_M( "sar eax,01h", 2, FCML_MI( 0xc1, 0xf8, 0x01 ), FCML_MI( 0xd1, 0xf8 ) );
    FCML_I64_M( "sar rax,01h", 2, FCML_MI( 0x48, 0xc1, 0xf8, 0x01 ), FCML_MI( 0x48, 0xd1, 0xf8 ) );

    FCML_A64_M( "sarl $0x01,(%rax)", 2, FCML_MI( 0xc1, 0x38, 0x01 ), FCML_MI( 0xd1, 0x38 ) );
    FCML_A64_M( "sar $0x01,%eax", 2, FCML_MI( 0xc1, 0xf8, 0x01 ), FCML_MI( 0xd1, 0xf8 ) );
    FCML_A64_M( "sar $0x01,%rax", 2, FCML_MI( 0x48, 0xc1, 0xf8, 0x01 ), FCML_MI( 0x48, 0xd1, 0xf8 ) );

    FCML_I32( "sar dword ptr [eax],cl", 0xD3, 0x38 );
    FCML_I32( "sar eax,cl", 0xD3, 0xF8 );
    FCML_I64( "sar rax,cl", 0x48, 0xD3, 0xF8 );

    FCML_A64( "sarl %cl,(%rax)", 0xd3, 0x38 );
    FCML_A64( "sar %cl,%eax", 0xd3, 0xf8 );
    FCML_A64( "sar %cl,%rax", 0x48, 0xd3, 0xf8 );

    FCML_I32( "sar dword ptr [eax],0ffh", 0xC1, 0x38, 0xff );
    FCML_I32( "sar eax,0ffh", 0xC1, 0xF8, 0xff );
    FCML_I64( "sar rax,0ffh", 0x48, 0xC1, 0xF8, 0xff );

    FCML_A64( "sarl $0xff,(%rax)", 0xc1, 0x38, 0xff );
    FCML_A64( "sar $0xff,%eax", 0xc1, 0xf8, 0xff );
    FCML_A64( "sar $0xff,%rax", 0x48, 0xc1, 0xf8, 0xff );
}

void fcml_tf_instruction_SHR(void) {

    FCML_I32_M( "shr byte ptr [eax],01h", 2, FCML_MI( 0xc0, 0x28, 0x01 ), FCML_MI( 0xd0, 0x28 ) );
    FCML_I32_M( "shr al,01h", 2, FCML_MI( 0xc0, 0xe8, 0x01 ), FCML_MI( 0xd0, 0xe8 ) );
    FCML_I64_D( "shr al,01h", 0x48, 0xD0, 0xE8 );

    FCML_A64_M( "shrb $0x01,(%rax)", 2, FCML_MI( 0xc0, 0x28, 0x01 ), FCML_MI( 0xd0, 0x28 ) );
    FCML_A64_M( "shr $0x01,%al", 2, FCML_MI( 0xc0, 0xe8, 0x01 ), FCML_MI( 0xd0, 0xe8 ) );

    FCML_I32( "shr byte ptr [eax],cl", 0xD2, 0x28 );
    FCML_I32( "shr al,cl", 0xD2, 0xE8 );
    FCML_I64_D( "shr al,cl", 0x48, 0xD2, 0xE8 );

    FCML_A64( "shrb %cl,(%rax)", 0xd2, 0x28 );
    FCML_A64( "shr %cl,%al", 0xd2, 0xe8 );

    FCML_I32( "shr byte ptr [eax],0ffh", 0xC0, 0x28, 0xFF );
    FCML_I32( "shr al,0ffh", 0xC0, 0xE8, 0xFF );
    FCML_I64_D( "shr al,0ffh", 0x48, 0xC0, 0xE8, 0xFF );

    FCML_A64( "shrb $0xff,(%rax)", 0xc0, 0x28, 0xff );
    FCML_A64( "shr $0xff,%al", 0xc0, 0xe8, 0xff );

    FCML_I32_M( "shr dword ptr [eax],01h", 2, FCML_MI( 0xc1, 0x28, 0x01 ), FCML_MI( 0xd1, 0x28 ) );
    FCML_I32_M( "shr eax,01h", 2, FCML_MI( 0xc1, 0xe8, 0x01 ), FCML_MI( 0xd1, 0xe8 ) );
    FCML_I64_M( "shr rax,01h", 2, FCML_MI( 0x48, 0xc1, 0xe8, 0x01 ), FCML_MI( 0x48, 0xd1, 0xe8 ) );

    FCML_A64_M( "shrl $0x01,(%rax)", 2, FCML_MI( 0xc1, 0x28, 0x01 ), FCML_MI( 0xd1, 0x28 ) );
    FCML_A64_M( "shr $0x01,%eax", 2, FCML_MI( 0xc1, 0xe8, 0x01 ), FCML_MI( 0xd1, 0xe8 ) );

    FCML_I32( "shr dword ptr [eax],cl", 0xD3, 0x28 );
    FCML_I32( "shr eax,cl", 0xD3, 0xE8 );
    FCML_I64( "shr rax,cl", 0x48, 0xD3, 0xE8 );

    FCML_A64( "shrl %cl,(%rax)", 0xd3, 0x28 );
    FCML_A64( "shrq %cl,(%rax)", 0x48, 0xd3, 0x28 );
    FCML_A64( "shrw %cl,(%rax)", 0x66, 0xd3, 0x28 );
    FCML_A64( "shr %cl,%eax", 0xd3, 0xe8 );
    FCML_A64( "shr %cl,%rax", 0x48, 0xd3, 0xe8 );

    FCML_I32( "shr dword ptr [eax],0ffh", 0xC1, 0x28, 0xff );
    FCML_I32( "shr eax,0ffh", 0xC1, 0xE8, 0xff );
    FCML_I64( "shr rax,0ffh", 0x48, 0xC1, 0xE8, 0xff );

    FCML_A64( "shrl $0xff,(%rax)", 0xc1, 0x28, 0xff );
    FCML_A64( "shr $0xff,%rax", 0x48, 0xc1, 0xe8, 0xff );
}

void fcml_tf_instruction_SBB(void) {

    FCML_I32_M( "sbb al,42h", 2, FCML_MI( 0x80, 0xd8, 0x42 ), FCML_MI( 0x1c, 0x42 ) );

    FCML_I32_M( "sbb ax,8042h", 2, FCML_MI( 0x66, 0x81, 0xd8, 0x42, 0x80 ), FCML_MI( 0x66, 0x1d, 0x42, 0x80 ) );
    FCML_I32_M( "sbb eax,42806521h", 2, FCML_MI( 0x81, 0xd8, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x1d, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_M( "sbb ax,6521h", 2, FCML_MI( 0x66, 0x81, 0xd8, 0x21, 0x65 ), FCML_MI( 0x66, 0x1d, 0x21, 0x65 ) );

    FCML_I64_M( "sbb rax,0000000042806521h", 2, FCML_MI( 0x48, 0x81, 0xd8, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x48, 0x1d, 0x21, 0x65, 0x80, 0x42 ) );

    FCML_I32( "lock sbb byte ptr [eax],0ffh", 0xF0, 0x80, 0x18, 0xff );
    FCML_I32( "xacquire lock sbb byte ptr [eax],0ffh", 0xF2, 0xF0, 0x80, 0x18, 0xff );
    FCML_I32( "xrelease lock sbb byte ptr [eax],0ffh", 0xF3, 0xF0, 0x80, 0x18, 0xff );
    FCML_I32_M( "sbb al,0ffh", 2, FCML_MI( 0x80, 0xd8, 0xff ), FCML_MI( 0x1c, 0xff ) );
    FCML_I64_D( "sbb byte ptr [rax],0ffh", 0x48, 0x80, 0x18, 0xff );
    FCML_I64( "sbb byte ptr [rax],0ffh", 0x80, 0x18, 0xff );

    FCML_I32( "sbb ebp,04030201h", 0x81, 0xDD, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "sbb bp,0201h", 0x66, 0x81, 0xDD, 0x01, 0x02 );
    FCML_I64_D( "sbb bp,0201h", 0x67, 0x66, 0x40, 0x81, 0xDD, 0x01, 0x02 ); /* 32 bit mode doesn't not allow REX.*/

    FCML_I64( "sbb rbp,0000000004030201h", 0x48, 0x81, 0xDD, 0x01, 0x02, 0x03, 0x04 );

    FCML_I32_M( "lock sbb dword ptr [eax],0ffffffffh", 2, FCML_MI( 0xF0, 0x83, 0x18, 0xff ), FCML_MI( 0xF0, 0x81, 0x18, 0xff, 0xff, 0xff, 0xff ) );
    FCML_I32_M( "xacquire lock sbb dword ptr [eax],0ffffffffh", 2, FCML_MI( 0xF2, 0xF0, 0x83, 0x18, 0xff ), FCML_MI( 0xF2, 0xF0, 0x81, 0x18, 0xff, 0xff, 0xff, 0xff ) );
    FCML_I32_M( "xrelease lock sbb dword ptr [eax],0ffffffffh", 2, FCML_MI( 0xF3, 0xF0, 0x83, 0x18, 0xff ), FCML_MI( 0xF3, 0xF0, 0x81, 0x18, 0xff, 0xff, 0xff, 0xff ) );
    FCML_I32_M( "sbb word ptr [eax],0ffffh", 2, FCML_MI( 0x66, 0x83, 0x18, 0xff ), FCML_MI( 0x66, 0x81, 0x18, 0xff, 0xff ) );
    FCML_I32_M( "sbb eax,0ffffffffh", 3, FCML_MI( 0x83, 0xd8, 0xff ), FCML_MI( 0x81, 0xd8, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x1d, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I64_M( "lock sbb qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF0, 0x48, 0x83, 0x9f, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xF0, 0x48, 0x81, 0x9f, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "xacquire lock sbb qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF2, 0xF0, 0x48, 0x83, 0x9f, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xF2, 0xF0, 0x48, 0x81, 0x9f, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "xrelease lock sbb qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF3, 0xF0, 0x48, 0x83, 0x9f, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xF3, 0xF0, 0x48, 0x81, 0x9f, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "sbb qword ptr [rdi+0000000004030201h],0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x83, 0x9f, 0x01, 0x02, 0x03, 0x04, 0xff ), FCML_MI( 0x48, 0x81, 0x9f, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32( "sbb byte ptr [ebp+04030201h],ah", 0x18, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "sbb byte ptr [rbp+0000000004030201h],spl", 0x40, 0x18, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "sbb byte ptr [rbp+0000000000000001h],spl", 0x40, 0x18, 0x65, 0x01 );

    FCML_I32( "lock sbb dword ptr [ebp+04030201h],esp", 0xF0, 0x19, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xacquire lock sbb dword ptr [ebp+04030201h],esp", 0xF2, 0xF0, 0x19, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xrelease lock sbb dword ptr [ebp+04030201h],esp", 0xF3, 0xF0, 0x19, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "sbb word ptr [di+0201h],sp", 0x66, 0x67, 0x19, 0xa5, 0x01, 0x02 );
    FCML_I32( "sbb dword ptr [di+0201h],esp", 0x67, 0x19, 0xa5, 0x01, 0x02 );
    FCML_I64( "sbb qword ptr [r9+rcx*4+0000000000000001h],r12", 0x4D, 0x19, 0x64, 0x89, 0x01 );

    FCML_I32( "sbb ah,byte ptr [ebp+04030201h]", 0x1A, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "sbb spl,byte ptr [rbp+0000000004030201h]", 0x40, 0x1a, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "sbb spl,byte ptr [rbp+0000000000000001h]", 0x40, 0x1a, 0x65, 0x01 );

    FCML_I32( "sbb esp,dword ptr [ebp+04030201h]", 0x1B, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "sbb sp,word ptr [di+0201h]", 0x66, 0x67, 0x1b, 0xa5, 0x01, 0x02 );
    FCML_I32( "sbb esp,dword ptr [di+0201h]", 0x67, 0x1B, 0xa5, 0x01, 0x02 );
    FCML_I64( "sbb r12,qword ptr [r9+rcx*4+0000000000000001h]", 0x4D, 0x1B, 0x64, 0x89, 0x01 );

    FCML_A64_M( "sbb $0x8042,%ax", 2, FCML_MI( 0x66, 0x81, 0xd8, 0x42, 0x80 ), FCML_MI( 0x66, 0x1d, 0x42, 0x80 ) );
    FCML_A64( "lock sbbb $0xff,(%rax)", 0xf0, 0x80, 0x18, 0xff );
    FCML_A64_M( "sbbw $0xffff,(%rax)", 2, FCML_MI( 0x66, 0x83, 0x18, 0xff ), FCML_MI( 0x66, 0x81, 0x18, 0xff, 0xff ) );
    FCML_A64_M( "sbb $0xffffffff,%eax", 3, FCML_MI( 0x83, 0xd8, 0xff ), FCML_MI( 0x81, 0xd8, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x1d, 0xff, 0xff, 0xff, 0xff ) );
    FCML_A64( "sbb %sp,0x194d0201(%ebp)", 0x66, 0x67, 0x19, 0xa5, 0x01, 0x02, 0x4d, 0x19 );
}

void fcml_tf_instruction_SCAS(void) {

    FCML_I32( "repne scas byte ptr [edi]", 0xf2, 0xAE );

    FCML_I32( "scas dword ptr [edi]", 0xAF );
    FCML_I32( "scas word ptr [edi]", 0x66, 0xAF );
    FCML_I64( "scas qword ptr [rdi]", 0x48, 0xAF );

    FCML_I32_A( "repne scasb", 0xf2, 0xAE );
    FCML_I32_A( "repnz scasb", 0xf2, 0xAE );
    FCML_I32_A( "scasw", 0x66, 0xAF );
    FCML_I32_A( "scasd", 0xAF );
    FCML_I64_A( "scasq", 0x48, 0xAF );

    FCML_I32_D_RF( "repne scas byte ptr [edi]", FCML_REND_FLAG_REP_PREFIX_GROUP_1, 0xf2, 0xAE );
    FCML_I32_D_RF( "repnz scas byte ptr [edi]", FCML_REND_FLAG_REP_PREFIX_GROUP_2, 0xf2, 0xAE );

    FCML_A64( "scasl (%rdi)", 0xaf );
    FCML_A64( "scasw (%rdi)", 0x66, 0xaf );
    FCML_A64( "scasq (%rdi)", 0x48, 0xaf );
    FCML_A64_A( "scasl", 0xaf );
    FCML_A64_A( "scasw", 0x66, 0xaf );
    FCML_A64_A( "scasq", 0x48, 0xaf );
}

void fcml_tf_instruction_SETcc(void) {

    FCML_I32( "setnbe byte ptr [eax]", 0x0F, 0x97, 0x00 );
    FCML_I32( "setnbe al", 0x0F, 0x97, 0xC0 );
    FCML_I32( "setc al", 0x0F, 0x92, 0xC0 );
    FCML_I32_A( "setb al", 0x0F, 0x92, 0xC0 );
    FCML_I64_D( "setnbe al", 0x40, 0x0F, 0x97, 0xC0 );

    FCML_A64_A( "seta (%rax)", 0x0f, 0x97, 0x00 );
    FCML_A64_A( "seta %al", 0x0f, 0x97, 0xc0 );
    FCML_A64_A( "setb %al", 0x0f, 0x92, 0xc0 );
}

void fcml_tf_instruction_SFENCE(void) {

    FCML_I3264( "sfence", 0x0f, 0xae, 0xf8 );

    FCML_A64( "sfence", 0x0f, 0xae, 0xf8 );
}

void fcml_tf_instruction_SGDT(void) {

    FCML_I32( "sgdt [eax]", 0x0f, 0x01, 0x00 );
    FCML_I64( "sgdt [rax]", 0x0f, 0x01, 0x00 );

    FCML_A64( "sgdt (%rax)", 0x0f, 0x01, 0x00 );
    FCML_A64( "sgdt (%rax)", 0x0f, 0x01, 0x00 );
}

void fcml_tf_instruction_SHLD(void) {

    FCML_I32( "shld dword ptr [eax],eax,0ffh", 0x0f, 0xA4, 0x00, 0xFF );
    FCML_I32( "shld word ptr [eax],ax,0ffh", 0x66, 0x0f, 0xA4, 0x00, 0xFF );
    FCML_I64( "shld qword ptr [rax],rax,0ffh", 0x48, 0x0f, 0xA4, 0x00, 0xFF );

    FCML_I32( "shld dword ptr [eax],eax,cl", 0x0f, 0xA5, 0x00 );
    FCML_I32( "shld word ptr [eax],ax,cl", 0x66, 0x0f, 0xA5, 0x00 );
    FCML_I64( "shld qword ptr [rax],rax,cl", 0x48, 0x0f, 0xA5, 0x00 );

    FCML_A64( "shld $0xff,%eax,(%rax)", 0x0f, 0xa4, 0x00, 0xff );
    FCML_A64( "shld $0xff,%ax,(%rax)", 0x66, 0x0f, 0xa4, 0x00, 0xff );
    FCML_A64( "shld $0xff,%rax,(%rax)", 0x48, 0x0f, 0xa4, 0x00, 0xff );
    FCML_A64( "shld %cl,%eax,(%rax)", 0x0f, 0xa5, 0x00 );
    FCML_A64( "shld %cl,%ax,(%rax)", 0x66, 0x0f, 0xa5, 0x00 );
    FCML_A64( "shld %cl,%rax,(%rax)", 0x48, 0x0f, 0xa5, 0x00 );
}

void fcml_tf_instruction_SHRD(void) {

    FCML_I32( "shrd dword ptr [eax],eax,0ffh", 0x0f, 0xAC, 0x00, 0xFF );
    FCML_I32( "shrd word ptr [eax],ax,0ffh", 0x66, 0x0f, 0xAC, 0x00, 0xFF );
    FCML_I64( "shrd qword ptr [rax],rax,0ffh", 0x48, 0x0f, 0xAC, 0x00, 0xFF );

    FCML_I32( "shrd dword ptr [eax],eax,cl", 0x0f, 0xAD, 0x00 );
    FCML_I32( "shrd word ptr [eax],ax,cl", 0x66, 0x0f, 0xAD, 0x00 );
    FCML_I64( "shrd qword ptr [rax],rax,cl", 0x48, 0x0f, 0xAD, 0x00 );

    FCML_A64( "shrd $0xff,%eax,(%rax)", 0x0f, 0xac, 0x00, 0xff );
    FCML_A64( "shrd $0xff,%ax,(%rax)", 0x66, 0x0f, 0xac, 0x00, 0xff );
    FCML_A64( "shrd $0xff,%rax,(%rax)", 0x48, 0x0f, 0xac, 0x00, 0xff );
    FCML_A64( "shrd %cl,%eax,(%rax)", 0x0f, 0xad, 0x00 );
    FCML_A64( "shrd %cl,%ax,(%rax)", 0x66, 0x0f, 0xad, 0x00 );
    FCML_A64( "shrd %cl,%rax,(%rax)", 0x48, 0x0f, 0xad, 0x00 );
}

void fcml_tf_instruction_SKINIT(void) {

    FCML_I32( "skinit eax", 0x0F, 0x01, 0xDE );
    FCML_I64( "skinit eax", 0x0F, 0x01, 0xDE );

    FCML_A64_A( "skinit", 0x0f, 0x01, 0xde );
    FCML_A64_A( "skinit", 0x0f, 0x01, 0xde );
}

void fcml_tf_instruction_SLWPCB(void) {

    FCML_I32_D( "slwpcb eax", 0x8F, 0xE9, 0x60, 0x12, 0xC8 );
    FCML_I32( "slwpcb eax", 0x8F, 0xE9, 0x78, 0x12, 0xC8 );

    FCML_I64_D( "slwpcb rax", 0x8F, 0xE9, 0xE0, 0x12, 0xC8 );
    FCML_I64( "slwpcb rax", 0x8F, 0xE9, 0xF8, 0x12, 0xC8 );

    FCML_A32( "slwpcb %eax", 0x8f, 0xe9, 0x78, 0x12, 0xc8 );
    FCML_A64( "slwpcb %rax", 0x8f, 0xe9, 0xf8, 0x12, 0xc8 );
}

void fcml_tf_instruction_SHUFPD(void) {

    FCML_I32( "shufpd xmm2,xmmword ptr [ecx+eax],0ffh", 0x66, 0x0F, 0xC6, 0x14, 0x01, 0xFF );
    FCML_I64( "shufpd xmm2,xmmword ptr [rcx+rax],0ffh", 0x66, 0x0F, 0xC6, 0x14, 0x01, 0xFF );

    FCML_I32_M("vshufpd xmm2,xmm6,xmmword ptr [ecx+eax],20h", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc9, 0xc6, 0x14, 0x01, 0x20));
    FCML_I64_M("vshufpd xmm2,xmm6,xmmword ptr [rcx+rax],20h", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc9, 0xc6, 0x14, 0x01, 0x20));

    FCML_A64( "shufpd $0xff,(%rcx,%rax),%xmm2", 0x66, 0x0f, 0xc6, 0x14, 0x01, 0xff );
    FCML_A64( "shufpd $0xff,(%rcx,%rax),%xmm2", 0x66, 0x0f, 0xc6, 0x14, 0x01, 0xff );
    FCML_A64_M("vshufpd $0x20,(%rcx,%rax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc9, 0xc6, 0x14, 0x01, 0x20));
    FCML_A64_M("vshufpd $0x20,(%rcx,%rax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc9, 0xc6, 0x14, 0x01, 0x20));


    FCML_I64_M("vshufpd xmm15,xmm7,xmmword ptr [rax],14h", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0x41, 0xc6, 0x38, 0x14));
    FCML_I32_M("vshufpd xmm7,xmm6,xmmword ptr [eax],14h", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0xc9, 0xc6, 0x38, 0x14));
    FCML_I64_M("vshufpd ymm15,ymm7,ymmword ptr [rax],14h", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0x45, 0xc6, 0x38, 0x14));
    FCML_I32_M("vshufpd ymm7,ymm5,ymmword ptr [eax],14h", 2, FCML_MI(0x62, 0xf1, 0xd5, 0x28, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0xd5, 0xc6, 0x38, 0x14));
    FCML_I64("vshufpd zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x71, 0xc5, 0x48, 0xc6, 0x38, 0x14);
    FCML_I32("vshufpd zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf1, 0xe5, 0x48, 0xc6, 0x38, 0x14);
    FCML_I64_M("vshufpd xmm15,xmm7,xmm1,14h", 2, FCML_MI(0x62, 0x71, 0xc5, 0x08, 0xc6, 0xf9, 0x14), FCML_MI(0xc5, 0x41, 0xc6, 0xf9, 0x14));
    FCML_I32_M("vshufpd xmm7,xmm2,xmm1,14h", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xc6, 0xf9, 0x14), FCML_MI(0xc5, 0xe9, 0xc6, 0xf9, 0x14));
    FCML_I64_M("vshufpd ymm14,ymm7,ymm6,14h", 2, FCML_MI(0x62, 0x71, 0xc5, 0x28, 0xc6, 0xf6, 0x14), FCML_MI(0xc5, 0x45, 0xc6, 0xf6, 0x14));
    FCML_I32_M("vshufpd ymm6,ymm3,ymm5,14h", 2, FCML_MI(0x62, 0xf1, 0xe5, 0x28, 0xc6, 0xf5, 0x14), FCML_MI(0xc5, 0xe5, 0xc6, 0xf5, 0x14));
    FCML_I64("vshufpd zmm6,zmm15,zmm4,14h", 0x62, 0xf1, 0x85, 0x48, 0xc6, 0xf4, 0x14);
    FCML_I32("vshufpd zmm6,zmm6,zmm4,14h", 0x62, 0xf1, 0xcd, 0x48, 0xc6, 0xf4, 0x14);
    FCML_I32("vshufpd zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf1, 0xed, 0x48, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufpd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf1, 0xed, 0x48, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32_M("vshufpd ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xed, 0xc6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00, 0x14));
    FCML_I64_M("vshufpd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 2, FCML_MI(0x62, 0xf1, 0xed, 0x28, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xed, 0xc6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00, 0x14));
    FCML_I32_M("vshufpd xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xe9, 0xc6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00, 0x14));
    FCML_I64_M("vshufpd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 2, FCML_MI(0x62, 0xf1, 0xed, 0x08, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xe9, 0xc6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00, 0x14));
    FCML_I64("vshufpd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x11, 0x8d, 0x8c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufpd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0xc5, 0x8d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufpd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x11, 0x8d, 0xac, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufpd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf1, 0xc5, 0xad, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufpd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x11, 0x8d, 0xcc, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufpd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0xc5, 0xcd, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufpd xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x11, 0x8d, 0x0c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufpd xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0xc5, 0x0d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufpd ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x11, 0x8d, 0x2c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufpd ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf1, 0xc5, 0x2d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufpd zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x11, 0x8d, 0x4c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufpd zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0xc5, 0x4d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufpd zmm31,zmm21,mmword ptr [rsi]{1to8},14h", 0x62, 0x61, 0xd5, 0x50, 0xc6, 0x3e, 0x14);
    FCML_I64("vshufpd ymm31,ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x61, 0xd5, 0x30, 0xc6, 0x3e, 0x14);
    FCML_I64("vshufpd xmm31,xmm21,mmword ptr [rsi]{1to2},14h", 0x62, 0x61, 0xd5, 0x10, 0xc6, 0x3e, 0x14);
    FCML_I32("vshufpd zmm1,zmm2,mmword ptr [esi]{1to8},14h", 0x62, 0xf1, 0xed, 0x58, 0xc6, 0x0e, 0x14);
    FCML_I64("vshufpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x61, 0xd5, 0xb7, 0xc6, 0x3e, 0x14);
    FCML_I32("vshufpd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf1, 0xed, 0x58, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufpd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf1, 0xed, 0x58, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufpd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf1, 0xed, 0x38, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufpd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf1, 0xed, 0x38, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufpd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2},14h", 0x62, 0xf1, 0xed, 0x18, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufpd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2},14h", 0x62, 0xf1, 0xed, 0x18, 0xc6, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_SHUFPS(void) {

    FCML_I32( "shufps xmm2,xmmword ptr [ecx+eax],0ffh", 0x0F, 0xC6, 0x14, 0x01, 0xFF );
    FCML_I64( "shufps xmm2,xmmword ptr [rcx+rax],0ffh", 0x0F, 0xC6, 0x14, 0x01, 0xFF );

    FCML_I32_M("vshufps xmm2,xmm6,xmmword ptr [ecx+eax],20h", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc8, 0xc6, 0x14, 0x01, 0x20));
    FCML_I64_M("vshufps xmm2,xmm6,xmmword ptr [rcx+rax],20h", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc8, 0xc6, 0x14, 0x01, 0x20));

    FCML_A64( "shufps $0xff,(%rcx,%rax),%xmm2", 0x0f, 0xc6, 0x14, 0x01, 0xff );
    FCML_A64( "shufps $0xff,(%rcx,%rax),%xmm2", 0x0f, 0xc6, 0x14, 0x01, 0xff );
    FCML_A64_M("vshufps $0x20,(%rcx,%rax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc8, 0xc6, 0x14, 0x01, 0x20));
    FCML_A64_M("vshufps $0x20,(%rcx,%rax),%xmm6,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0xc6, 0x14, 0x01, 0x20), FCML_MI(0xc5, 0xc8, 0xc6, 0x14, 0x01, 0x20));

    FCML_A64_M("vshufps $0x14,(%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x44, 0x08, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0x40, 0xc6, 0x38, 0x14));
    FCML_I64_M("vshufps xmm15,xmm7,xmmword ptr [rax],14h", 2, FCML_MI(0x62, 0x71, 0x44, 0x08, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0x40, 0xc6, 0x38, 0x14));
    FCML_A32_M("vshufps $0x14,(%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0xc8, 0xc6, 0x38, 0x14));
    FCML_I32_M("vshufps xmm7,xmm6,xmmword ptr [eax],14h", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0xc8, 0xc6, 0x38, 0x14));
    FCML_A64_M("vshufps $0x14,(%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x71, 0x44, 0x28, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0x44, 0xc6, 0x38, 0x14));
    FCML_I64_M("vshufps ymm15,ymm7,ymmword ptr [rax],14h", 2, FCML_MI(0x62, 0x71, 0x44, 0x28, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0x44, 0xc6, 0x38, 0x14));
    FCML_A32_M("vshufps $0x14,(%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf1, 0x54, 0x28, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0xd4, 0xc6, 0x38, 0x14));
    FCML_I32_M("vshufps ymm7,ymm5,ymmword ptr [eax],14h", 2, FCML_MI(0x62, 0xf1, 0x54, 0x28, 0xc6, 0x38, 0x14), FCML_MI(0xc5, 0xd4, 0xc6, 0x38, 0x14));
    FCML_A64("vshufps $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x71, 0x44, 0x48, 0xc6, 0x38, 0x14);
    FCML_I64("vshufps zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x71, 0x44, 0x48, 0xc6, 0x38, 0x14);
    FCML_A32("vshufps $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf1, 0x64, 0x48, 0xc6, 0x38, 0x14);
    FCML_I32("vshufps zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf1, 0x64, 0x48, 0xc6, 0x38, 0x14);
    FCML_A64_M("vshufps $0x14,%xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x71, 0x44, 0x08, 0xc6, 0xf9, 0x14), FCML_MI(0xc5, 0x40, 0xc6, 0xf9, 0x14));
    FCML_I64_M("vshufps xmm15,xmm7,xmm1,14h", 2, FCML_MI(0x62, 0x71, 0x44, 0x08, 0xc6, 0xf9, 0x14), FCML_MI(0xc5, 0x40, 0xc6, 0xf9, 0x14));
    FCML_A32_M("vshufps $0x14,%xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0xc6, 0xf9, 0x14), FCML_MI(0xc5, 0xe8, 0xc6, 0xf9, 0x14));
    FCML_I32_M("vshufps xmm7,xmm2,xmm1,14h", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0xc6, 0xf9, 0x14), FCML_MI(0xc5, 0xe8, 0xc6, 0xf9, 0x14));
    FCML_A64_M("vshufps $0x14,%ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x71, 0x44, 0x28, 0xc6, 0xf6, 0x14), FCML_MI(0xc5, 0x44, 0xc6, 0xf6, 0x14));
    FCML_I64_M("vshufps ymm14,ymm7,ymm6,14h", 2, FCML_MI(0x62, 0x71, 0x44, 0x28, 0xc6, 0xf6, 0x14), FCML_MI(0xc5, 0x44, 0xc6, 0xf6, 0x14));
    FCML_A32_M("vshufps $0x14,%ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf1, 0x64, 0x28, 0xc6, 0xf5, 0x14), FCML_MI(0xc5, 0xe4, 0xc6, 0xf5, 0x14));
    FCML_I32_M("vshufps ymm6,ymm3,ymm5,14h", 2, FCML_MI(0x62, 0xf1, 0x64, 0x28, 0xc6, 0xf5, 0x14), FCML_MI(0xc5, 0xe4, 0xc6, 0xf5, 0x14));
    FCML_A64("vshufps $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf1, 0x04, 0x48, 0xc6, 0xf4, 0x14);
    FCML_I64("vshufps zmm6,zmm15,zmm4,14h", 0x62, 0xf1, 0x04, 0x48, 0xc6, 0xf4, 0x14);
    FCML_A32("vshufps $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf1, 0x4c, 0x48, 0xc6, 0xf4, 0x14);
    FCML_I32("vshufps zmm6,zmm6,zmm4,14h", 0x62, 0xf1, 0x4c, 0x48, 0xc6, 0xf4, 0x14);
    FCML_I32("vshufps zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf1, 0x6c, 0x48, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vshufps $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf1, 0x6c, 0x48, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf1, 0x6c, 0x48, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vshufps $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf1, 0x6c, 0x48, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32_M("vshufps ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x28, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xec, 0xc6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00, 0x14));
    FCML_A32_M("vshufps $0x14,0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x28, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xec, 0xc6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00, 0x14));
    FCML_I64_M("vshufps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x28, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xec, 0xc6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00, 0x14));
    FCML_A64_M("vshufps $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x28, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xec, 0xc6, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00, 0x14));
    FCML_I32_M("vshufps xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xe8, 0xc6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00, 0x14));
    FCML_A32_M("vshufps $0x14,0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xe8, 0xc6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00, 0x14));
    FCML_I64_M("vshufps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xe8, 0xc6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00, 0x14));
    FCML_A64_M("vshufps $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf1, 0x6c, 0x08, 0xc6, 0x4c, 0x24, 0x08, 0x14), FCML_MI(0xc5, 0xe8, 0xc6, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00, 0x14));
    FCML_A64("vshufps $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x11, 0x0c, 0x8c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x11, 0x0c, 0x8c, 0xc6, 0x14, 0x01, 0x14);
    FCML_A32("vshufps $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf1, 0x44, 0x8d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0x44, 0x8d, 0xc6, 0x14, 0x01, 0x14);
    FCML_A64("vshufps $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x11, 0x0c, 0xac, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x11, 0x0c, 0xac, 0xc6, 0x14, 0x01, 0x14);
    FCML_A32("vshufps $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf1, 0x44, 0xad, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf1, 0x44, 0xad, 0xc6, 0x14, 0x01, 0x14);
    FCML_A64("vshufps $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x11, 0x0c, 0xcc, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x11, 0x0c, 0xcc, 0xc6, 0x14, 0x01, 0x14);
    FCML_A32("vshufps $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf1, 0x44, 0xcd, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0x44, 0xcd, 0xc6, 0x14, 0x01, 0x14);
    FCML_A64("vshufps $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x11, 0x0c, 0x0c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x11, 0x0c, 0x0c, 0xc6, 0x14, 0x01, 0x14);
    FCML_A32("vshufps $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf1, 0x44, 0x0d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufps xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0x44, 0x0d, 0xc6, 0x14, 0x01, 0x14);
    FCML_A64("vshufps $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x11, 0x0c, 0x2c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x11, 0x0c, 0x2c, 0xc6, 0x14, 0x01, 0x14);
    FCML_A32("vshufps $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf1, 0x44, 0x2d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufps ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf1, 0x44, 0x2d, 0xc6, 0x14, 0x01, 0x14);
    FCML_A64("vshufps $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x11, 0x0c, 0x4c, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x11, 0x0c, 0x4c, 0xc6, 0x14, 0x01, 0x14);
    FCML_A32("vshufps $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf1, 0x44, 0x4d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I32("vshufps zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf1, 0x44, 0x4d, 0xc6, 0x14, 0x01, 0x14);
    FCML_I64("vshufps zmm31,zmm21,dword ptr [rsi]{1to16},14h", 0x62, 0x61, 0x54, 0x50, 0xc6, 0x3e, 0x14);
    FCML_A64("vshufps $0x14,(%rsi){1to16},%zmm21,%zmm31", 0x62, 0x61, 0x54, 0x50, 0xc6, 0x3e, 0x14);
    FCML_I64("vshufps ymm31,ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x61, 0x54, 0x30, 0xc6, 0x3e, 0x14);
    FCML_A64("vshufps $0x14,(%rsi){1to8},%ymm21,%ymm31", 0x62, 0x61, 0x54, 0x30, 0xc6, 0x3e, 0x14);
    FCML_I64("vshufps xmm31,xmm21,dword ptr [rsi]{1to4},14h", 0x62, 0x61, 0x54, 0x10, 0xc6, 0x3e, 0x14);
    FCML_A64("vshufps $0x14,(%rsi){1to4},%xmm21,%xmm31", 0x62, 0x61, 0x54, 0x10, 0xc6, 0x3e, 0x14);
    FCML_A32("vshufps $0x14,(%esi){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6c, 0x58, 0xc6, 0x0e, 0x14);
    FCML_I32("vshufps zmm1,zmm2,dword ptr [esi]{1to16},14h", 0x62, 0xf1, 0x6c, 0x58, 0xc6, 0x0e, 0x14);
    FCML_A64("vshufps $0x14,(%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x54, 0xb7, 0xc6, 0x3e, 0x14);
    FCML_I64("vshufps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x61, 0x54, 0xb7, 0xc6, 0x3e, 0x14);
    FCML_I32("vshufps zmm1,zmm2,dword ptr [esp+00000020h]{1to16},14h", 0x62, 0xf1, 0x6c, 0x58, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vshufps $0x14,0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6c, 0x58, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16},14h", 0x62, 0xf1, 0x6c, 0x58, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vshufps $0x14,0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf1, 0x6c, 0x58, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufps ymm1,ymm2,dword ptr [esp+00000020h]{1to8},14h", 0x62, 0xf1, 0x6c, 0x38, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8},14h", 0x62, 0xf1, 0x6c, 0x38, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vshufps $0x14,0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf1, 0x6c, 0x38, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufps xmm1,xmm2,dword ptr [esp+00000020h]{1to4},14h", 0x62, 0xf1, 0x6c, 0x18, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4},14h", 0x62, 0xf1, 0x6c, 0x18, 0xc6, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vshufps $0x14,0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf1, 0x6c, 0x18, 0xc6, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_SIDT(void) {

    FCML_I32( "sidt [eax]", 0x0f, 0x01, 0x08 );
    FCML_I64( "sidt [rax]", 0x0f, 0x01, 0x08 );

    FCML_A32( "sidt (%eax)", 0x0f, 0x01, 0x08 );
    FCML_A64( "sidt (%rax)", 0x0f, 0x01, 0x08 );
}

void fcml_tf_instruction_SLDT(void) {

    FCML_I32( "sldt word ptr [eax]", 0x0f, 0x00, 0x00 );
    FCML_I32_D( "sldt word ptr [eax]", 0x66, 0x0f, 0x00, 0x00 );
    FCML_I64_D( "sldt word ptr [rax]", 0x48, 0x0f, 0x00, 0x00 );
    FCML_I64( "sldt ax", 0x66, 0x0f, 0x00, 0xC0 );
    FCML_I64( "sldt eax", 0x0f, 0x00, 0xC0 );
    FCML_I64( "sldt rax", 0x48, 0x0f, 0x00, 0xC0 );
    FCML_I32( "sldt ax", 0x66, 0x0f, 0x00, 0xC0 );
    FCML_I32( "sldt eax", 0x0f, 0x00, 0xC0 );

    FCML_A64( "sldt %ax", 0x66, 0x0f, 0x00, 0xc0 );
    FCML_A64( "sldt %eax", 0x0f, 0x00, 0xc0 );
    FCML_A64( "sldt %rax", 0x48, 0x0f, 0x00, 0xc0 );
    FCML_A64( "sldt (%rax)", 0x0f, 0x00, 0x00 );
}

void fcml_tf_instruction_SMSW(void) {

    FCML_I32( "smsw word ptr [eax]", 0x0f, 0x01, 0x20 );
    FCML_I32( "smsw eax", 0x0f, 0x01, 0xE0 );
    FCML_I32( "smsw word ptr [eax]", 0x66, 0x0f, 0x01, 0x20 );
    FCML_I32( "smsw ax", 0x66, 0x0f, 0x01, 0xE0 );
    FCML_I64_D( "smsw word ptr [rax]", 0x48, 0x0f, 0x01, 0x20 );
    FCML_I64( "smsw rax", 0x48, 0x0f, 0x01, 0xE0 );

    FCML_A64( "smsw (%rax)", 0x0f, 0x01, 0x20 );
    FCML_A64( "smsw %eax", 0x0f, 0x01, 0xe0 );
    FCML_A64( "smsw %ax", 0x66, 0x0f, 0x01, 0xe0 );
    FCML_A64( "smsw %rax", 0x48, 0x0f, 0x01, 0xe0 );
}

void fcml_tf_instruction_SQRTPD(void) {

    FCML_I64( "sqrtpd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x51, 0x00 );
    FCML_I32( "sqrtpd xmm0,xmm1", 0x66, 0x0F, 0x51, 0xC1 );

    FCML_I64_M("vsqrtpd xmm3,xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf9, 0x51, 0xd8));
    FCML_I32_M("vsqrtpd xmm3,xmm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf9, 0x51, 0xd8));
    FCML_I32_M("vsqrtpd ymm0,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0x51, 0x00), FCML_MI(0xc5, 0xfd, 0x51, 0x00));
    FCML_A64_M("vsqrtpd %xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf9, 0x51, 0xd8));
    FCML_A64_M("vsqrtpd %xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf9, 0x51, 0xd8));
    FCML_A64_M("vsqrtpd (%rax),%ymm0", 2, FCML_MI(0x62, 0xf1, 0xfd, 0x28, 0x51, 0x00), FCML_MI(0xc5, 0xfd, 0x51, 0x00));

    /* AVX-512 */

    /* {k} */
    FCML_I64("vsqrtpd ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x29, 0x51, 0x14, 0x01);
    FCML_A64("vsqrtpd (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfd, 0x29, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtpd xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x09, 0x51, 0x14, 0x01);
    FCML_A64("vsqrtpd (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfd, 0x09, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtpd zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfd, 0x49, 0x51, 0x0c, 0x01);
    FCML_A64("vsqrtpd (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfd, 0x49, 0x51, 0x0c, 0x01);

    /* {k}{z} */
    FCML_I64("vsqrtpd ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0xa9, 0x51, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vsqrtpd zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfd, 0x58, 0x51, 0x3e);

    /* {k}{z}{bcast} */
    FCML_I64("vsqrtpd ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfd, 0xbf, 0x51, 0x3e);
    FCML_A64("vsqrtpd (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x61, 0xfd, 0xbf, 0x51, 0x3e);

    /* {rn} */
    FCML_I64("vsqrtpd zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfd, 0x9f, 0x51, 0xfc);

    /* Compressed disp8 */
    FCML_I64("vsqrtpd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x51, 0x4c, 0x24, 0x04);
    FCML_I64("vsqrtpd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x51, 0x4c, 0x24, 0x3a);
    FCML_I32("vsqrtpd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x51, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_SQRTPS(void) {

    FCML_I64( "sqrtps xmm0,xmmword ptr [rax]", 0x0F, 0x51, 0x00 );
    FCML_I32( "sqrtps xmm0,xmm1", 0x0F, 0x51, 0xC1 );
    FCML_A64( "sqrtps (%rax),%xmm0", 0x0f, 0x51, 0x00 );
    FCML_A64( "sqrtps %xmm1,%xmm0", 0x0f, 0x51, 0xc1 );

    FCML_I64_M("vsqrtps xmm3,xmm0", 2, FCML_MI(0x62, 0xf1, 0x7c, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf8, 0x51, 0xd8));
    FCML_I32_M("vsqrtps xmm3,xmm0", 2, FCML_MI(0x62, 0xf1, 0x7c, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf8, 0x51, 0xd8));
    FCML_I32_M("vsqrtps ymm0,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x7c, 0x28, 0x51, 0x00), FCML_MI(0xc5, 0xfc, 0x51, 0x00));
    FCML_A64_M("vsqrtps %xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x7c, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf8, 0x51, 0xd8));
    FCML_A64_M("vsqrtps %xmm0,%xmm3", 2, FCML_MI(0x62, 0xf1, 0x7c, 0x08, 0x51, 0xd8), FCML_MI(0xc5, 0xf8, 0x51, 0xd8));
    FCML_A64_M("vsqrtps (%rax),%ymm0", 2, FCML_MI(0x62, 0xf1, 0x7c, 0x28, 0x51, 0x00), FCML_MI(0xc5, 0xfc, 0x51, 0x00));

    /* AVX-512 */

    /* {k} */
    FCML_I64("vsqrtps ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0x29, 0x51, 0x14, 0x01);
    FCML_A64("vsqrtps (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7c, 0x29, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0x09, 0x51, 0x14, 0x01);
    FCML_A64("vsqrtps (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7c, 0x09, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtps zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0x7c, 0x49, 0x51, 0x0c, 0x01);
    FCML_A64("vsqrtps (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7c, 0x49, 0x51, 0x0c, 0x01);

    /* {k}{z} */
    FCML_I64("vsqrtps ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0xa9, 0x51, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vsqrtps zmm31,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x7c, 0x58, 0x51, 0x3e);

    /* {k}{z}{bcast} */
    FCML_I64("vsqrtps ymm31{k7}{z},dword ptr [rsi]{1to8}", 0x62, 0x61, 0x7c, 0xbf, 0x51, 0x3e);
    FCML_A64("vsqrtps (%rsi){1to8},%ymm31{%k7}{z}", 0x62, 0x61, 0x7c, 0xbf, 0x51, 0x3e);

    /* {rn} */
    FCML_I64("vsqrtps zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0x7c, 0x9f, 0x51, 0xfc);

    /* Compressed disp8 */
    FCML_I64("vsqrtps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x51, 0x4c, 0x24, 0x08);
    FCML_I64("vsqrtps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x51, 0x4c, 0x24, 0x74);
    FCML_I32("vsqrtps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x51, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_SQRTSD(void) {

    FCML_I32( "sqrtsd xmm2,mmword ptr [ecx+eax]", 0xF2, 0x0F, 0x51, 0x14, 0x01 );
    FCML_I64( "sqrtsd xmm2,mmword ptr [rcx+rax]", 0xF2, 0x0F, 0x51, 0x14, 0x01 );
    FCML_A64( "sqrtsd (%rcx,%rax),%xmm2", 0xf2, 0x0f, 0x51, 0x14, 0x01 );
    FCML_A64( "sqrtsd (%rcx,%rax),%xmm2", 0xf2, 0x0f, 0x51, 0x14, 0x01 );

    FCML_I32_M("vsqrtsd xmm2,xmm5,mmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xd7, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xd3, 0x51, 0x14, 0x01));
    FCML_I32_M("vsqrtsd xmm2,xmm4,mmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x51, 0x14, 0x01));
    FCML_A64_M("vsqrtsd (%rcx,%rax),%xmm5,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xd7, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xd3, 0x51, 0x14, 0x01));
    FCML_A64_M("vsqrtsd (%rcx,%rax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x51, 0x14, 0x01));

    /* {k1}{z} */
    FCML_I64("vsqrtsd xmm2{k1},xmm4,mmword ptr [rcx+rax]", 0x62, 0xf1, 0xdf, 0x09, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtsd xmm2{k1}{z},xmm4,mmword ptr [rcx+rax]", 0x62, 0xf1, 0xdf, 0x89, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtsd xmm31{k7}{z},xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0xd7, 0x97, 0x51, 0xfc);
    FCML_I64("vsqrtsd xmm31,xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0xd7, 0x10, 0x51, 0xfc);
    FCML_I64("vsqrtsd xmm31,xmm31,xmm31,{rn-sae}", 0x62, 0x01, 0x87, 0x10, 0x51, 0xff);
    FCML_I32("vsqrtsd xmm1,xmm6,xmm4,{rn-sae}", 0x62, 0xf1, 0xcf, 0x18, 0x51, 0xcc);
    FCML_I32_A_FAILED("vsqrtsd ymm1,ymm6,ymm4,{rn-sae}", 0x62, 0xf1, 0xcf, 0x38, 0x51, 0xcc);
    FCML_I32_A_FAILED("vsqrtsd zmm1,zmm6,zmm4,{rn-sae}", 0x62, 0xf1, 0xcf, 0x58, 0x51, 0xcc);

    FCML_I64_M("vsqrtsd xmm1,xmm6,mmword ptr [rsp+0000000000000040h]", 2, FCML_MI(0x62, 0xf1, 0xcf, 0x08, 0x51, 0x4c, 0x24, 0x08), FCML_MI(0xc5, 0xcb, 0x51, 0x4c, 0x24, 0x40));
}

void fcml_tf_instruction_SQRTSS(void) {

    FCML_I32( "sqrtss xmm2,dword ptr [ecx+eax]", 0xF3, 0x0F, 0x51, 0x14, 0x01 );
    FCML_I64( "sqrtss xmm2,dword ptr [rcx+rax]", 0xF3, 0x0F, 0x51, 0x14, 0x01 );
    FCML_I64( "sqrtss xmm0,xmm0", 0xF3, 0x0F, 0x51, 0xC0 );
    FCML_A64( "sqrtss (%rcx,%rax),%xmm2", 0xf3, 0x0f, 0x51, 0x14, 0x01 );
    FCML_A64( "sqrtss (%rcx,%rax),%xmm2", 0xf3, 0x0f, 0x51, 0x14, 0x01 );
    FCML_A64( "sqrtss %xmm0,%xmm0", 0xf3, 0x0f, 0x51, 0xc0 );

    FCML_I32_M("vsqrtss xmm2,xmm5,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x56, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xd2, 0x51, 0x14, 0x01));
    FCML_I32_M("vsqrtss xmm2,xmm4,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x51, 0x14, 0x01));
    FCML_A64_M("vsqrtss (%rcx,%rax),%xmm5,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x56, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xd2, 0x51, 0x14, 0x01));
    FCML_A64_M("vsqrtss (%rcx,%rax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x51, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x51, 0x14, 0x01));

    /* {k1}{z} */
    FCML_I64("vsqrtss xmm2{k1},xmm4,dword ptr [rcx+rax]", 0x62, 0xf1, 0x5e, 0x09, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtss xmm2{k1}{z},xmm4,dword ptr [rcx+rax]", 0x62, 0xf1, 0x5e, 0x89, 0x51, 0x14, 0x01);
    FCML_I64("vsqrtss xmm31{k7}{z},xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0x56, 0x97, 0x51, 0xfc);
    FCML_I64("vsqrtss xmm31,xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0x56, 0x10, 0x51, 0xfc);
    FCML_I64("vsqrtss xmm31,xmm31,xmm31,{rn-sae}", 0x62, 0x01, 0x06, 0x10, 0x51, 0xff);
    FCML_I32("vsqrtss xmm1,xmm6,xmm4,{rn-sae}", 0x62, 0xf1, 0x4e, 0x18, 0x51, 0xcc);
    FCML_I32_A_FAILED("vsqrtss ymm1,ymm6,ymm4,{rn-sae}", 0x62, 0xf1, 0x4e, 0x38, 0x51, 0xcc);
    FCML_I32_A_FAILED("vsqrtss zmm1,zmm6,zmm4,{rn-sae}", 0x62, 0xf1, 0x4e, 0x58, 0x51, 0xcc);

    FCML_I64_M("vsqrtss xmm1,xmm6,dword ptr [rsp+0000000000000040h]", 2, FCML_MI(0x62, 0xf1, 0x4e, 0x08, 0x51, 0x4c, 0x24, 0x10), FCML_MI(0xc5, 0xca, 0x51, 0x4c, 0x24, 0x40));
}

void fcml_tf_instruction_STC(void) {

    FCML_I3264( "stc", 0xF9 );
    FCML_A64( "stc", 0xf9 );
}

void fcml_tf_instruction_STD(void) {

    FCML_I3264( "std", 0xFD );
    FCML_A64( "std", 0xfd );
}

void fcml_tf_instruction_STGI(void) {

    FCML_I3264( "stgi", 0x0F, 0x01, 0xDC );
    FCML_A64( "stgi", 0x0f, 0x01, 0xdc );
}

void fcml_tf_instruction_STI(void) {

    FCML_I3264( "sti", 0xFB );
    FCML_A64( "sti", 0xfb );
}

void fcml_tf_instruction_STMXCSR(void) {

    FCML_I32( "stmxcsr dword ptr [eax+00000020h]", 0x0F, 0xAE, 0x58, 0x20 );
    FCML_I64( "stmxcsr dword ptr [rax+0000000000000020h]", 0x0F, 0xAE, 0x58, 0x20 );

    FCML_I64( "vstmxcsr dword ptr [r8]", 0xC4, 0xC1, 0x78, 0xAE, 0x18 );
    FCML_I32( "vstmxcsr dword ptr [eax]", 0xc5, 0xf8, 0xae, 0x18 );
    FCML_I32( "vstmxcsr dword ptr [eax]", 0xC5, 0xF8, 0xAE, 0x18 );

    FCML_A64( "stmxcsr 0x0000000000000020(%rax)", 0x0f, 0xae, 0x58, 0x20 );
    FCML_A64( "stmxcsr 0x0000000000000020(%rax)", 0x0f, 0xae, 0x58, 0x20 );
    FCML_A64( "vstmxcsr (%r8)", 0xc4, 0xc1, 0x78, 0xae, 0x18 );
    FCML_A64( "vstmxcsr (%rax)", 0xc5, 0xf8, 0xae, 0x18 );
    FCML_A64( "vstmxcsr (%rax)", 0xc5, 0xf8, 0xae, 0x18 );
}

void fcml_tf_instruction_STOS(void) {

    FCML_I32( "stos byte ptr [di]", 0x67, 0xAA );
    FCML_I32( "rep stos byte ptr [di]", 0xF3, 0x67, 0xAA );
    FCML_I32_D( "stos byte ptr [di]", 0x66, 0x67, 0xAA );
    FCML_I32( "stos byte ptr [edi]", 0xAA );
    FCML_I64_D( "stos byte ptr [rdi]", 0x48, 0xAA );
    FCML_I64_D( "stos byte ptr [rdi]", 0x40, 0xAA );
    FCML_I64_D( "stos byte ptr [edi]", 0x67, 0x40, 0xAA );
    FCML_I64_D( "stos byte ptr [edi]", 0x66, 0x67, 0x40, 0xAA );

    FCML_I32( "rep stos dword ptr [di]", 0xF3, 0x67, 0xAB );
    FCML_I32( "stos word ptr [di]", 0x66, 0x67, 0xAB );
    FCML_I32( "stos dword ptr [edi]", 0xAB );
    FCML_I64( "stos qword ptr [rdi]", 0x48, 0xAB );
    FCML_I64_D( "stos dword ptr [rdi]", 0x40, 0xAB );
    FCML_I64_D( "stos dword ptr [edi]", 0x67, 0x40, 0xAB );
    FCML_I64_D( "stos word ptr [edi]", 0x66, 0x67, 0x40, 0xAB );

    FCML_I32_A( "stosb", 0xAA );
    FCML_I32_A( "stosw", 0x66, 0xAB );
    FCML_I32_A( "stosd", 0xAB );
    FCML_I64_A( "stosq", 0x48, 0xAB );

    FCML_A64( "stosb (%rdi)", 0xaa );
    FCML_A64( "stosw (%rdi)", 0x66, 0xab );
    FCML_A64( "stosl (%rdi)", 0xab );
    FCML_A64( "stosq (%rdi)", 0x48, 0xab );
    FCML_A64_A( "stosb", 0xaa );
    FCML_A64_A( "stosw", 0x66, 0xab );
    FCML_A64_A( "stosl", 0xab );
    FCML_A64_A( "stosq", 0x48, 0xab );
}

void fcml_tf_instruction_STR(void) {

    FCML_I32( "str word ptr [eax]",  0x0F, 0x00, 0x08 );
    FCML_I64( "str word ptr [rax]", 0x0F, 0x00, 0x08 );

    FCML_A32( "str (%eax)", 0x0f, 0x00, 0x08 );
    FCML_A64( "str (%rax)", 0x0f, 0x00, 0x08 );
}

void fcml_tf_instruction_SUB(void) {

    FCML_I32_M( "sub al,42h", 2, FCML_MI( 0x80, 0xe8, 0x42 ), FCML_MI( 0x2c, 0x42 ) );
    FCML_I32_A_FAILED( "lock sub al,42h", 0xF0, 0x80, 0xe8, 0x42 );

    FCML_I32_M( "sub ax,8042h", 2, FCML_MI( 0x66, 0x81, 0xe8, 0x42, 0x80 ), FCML_MI( 0x66, 0x2d, 0x42, 0x80 ) );
    FCML_I32_M( "sub eax,42806521h", 2, FCML_MI( 0x81, 0xe8, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x2d, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_M( "sub eax,42806521h", 2, FCML_MI( 0x81, 0xe8, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x2d, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_M( "sub ax,6521h", 2, FCML_MI( 0x66, 0x81, 0xe8, 0x21, 0x65 ), FCML_MI( 0x66, 0x2d, 0x21, 0x65 ) );

    FCML_I64_M( "sub rax,0000000042806521h", 2, FCML_MI( 0x48, 0x81, 0xe8, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x48, 0x2d, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_I64_M( "sub rax,0ffffffffffffffffh", 3, FCML_MI( 0x48, 0x83, 0xe8, 0xff ), FCML_MI( 0x48, 0x81, 0xe8, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x48, 0x2d, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32( "lock sub byte ptr [04030201h],0ffh", 0xF0, 0x80, 0x2D, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "xacquire lock sub byte ptr [04030201h],0ffh", 0xF2, 0xF0, 0x80, 0x2D, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "xrelease lock sub byte ptr [04030201h],0ffh", 0xF3, 0xF0, 0x80, 0x2D, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "sub byte ptr [esi+04030201h],0ffh", 0x80, 0xae, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_I32( "sub byte ptr [ecx+eax+00000002h],03h", 0x80, 0x6C, 0x01, 0x02, 0x03 );

    FCML_I32( "sub ebp,04030201h", 0x81, 0xED, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "sub bp,0201h", 0x66, 0x81, 0xED, 0x01, 0x02 );
    FCML_I64_D( "sub bp,0201h", 0x67, 0x66, 0x40, 0x81, 0xED, 0x01, 0x02 ); /* 32 bit mode doesn't not allow REX.*/

    FCML_I64( "sub rbp,0000000004030201h", 0x48, 0x81, 0xed, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64_M( "sub rbp,0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x83, 0xed, 0xff ), FCML_MI( 0x48, 0x81, 0xed, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32_M( "lock sub dword ptr [esi],00000001h", 2, FCML_MI( 0xF0, 0x83, 0x2e, 0x01 ), FCML_MI( 0xF0, 0x81, 0x2e, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xacquire lock sub dword ptr [esi],00000001h", 2, FCML_MI( 0xF2, 0xF0, 0x83, 0x2e, 0x01 ), FCML_MI( 0xF2, 0xF0, 0x81, 0x2e, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "xrelease lock sub dword ptr [esi],00000001h", 2, FCML_MI( 0xF3, 0xF0, 0x83, 0x2e, 0x01 ), FCML_MI( 0xF3, 0xF0, 0x81, 0x2e, 0x01, 0x00, 0x00, 0x00 ) );
    FCML_I32_M( "sub word ptr [esi],0001h", 2, FCML_MI( 0x66, 0x83, 0x2e, 0x01 ), FCML_MI( 0x66, 0x81, 0x2e, 0x01, 0x00 ) );
    FCML_I32_M( "sub dword ptr [0201h],00000003h", 2, FCML_MI( 0x67, 0x83, 0x2e, 0x01, 0x02, 0x03 ), FCML_MI( 0x67, 0x81, 0x2e, 0x01, 0x02, 0x03, 0x00, 0x00, 0x00 ) );

    FCML_I64_M( "lock sub qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF0, 0x48, 0x83, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xF0, 0x48, 0x81, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "xacquire lock sub qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF2, 0xF0, 0x48, 0x83, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xF2, 0xF0, 0x48, 0x81, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "xrelease lock sub qword ptr [rdi+0000000004030201h],0000000000000005h", 2, FCML_MI( 0xF3, 0xF0, 0x48, 0x83, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xF3, 0xF0, 0x48, 0x81, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_I64_M( "sub qword ptr [rdi+0000000004030201h],0ffffffffffffffffh", 2, FCML_MI( 0x48, 0x83, 0xaf, 0x01, 0x02, 0x03, 0x04, 0xff ), FCML_MI( 0x48, 0x81, 0xaf, 0x01, 0x02, 0x03, 0x04, 0xff, 0xff, 0xff, 0xff ) );

    FCML_I32( "lock sub byte ptr [ebp+04030201h],ah", 0xF0, 0x28, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xacquire lock sub byte ptr [ebp+04030201h],ah", 0xF2, 0xF0, 0x28, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xrelease lock sub byte ptr [ebp+04030201h],ah", 0xF3, 0xF0, 0x28, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "sub byte ptr [rbp+0000000004030201h],spl", 0x40, 0x28, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "sub byte ptr [rbp+0000000000000001h],spl", 0x40, 0x28, 0x65, 0x01 );

    FCML_I32( "lock sub dword ptr [ebp+04030201h],esp", 0xF0, 0x29, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xacquire lock sub dword ptr [ebp+04030201h],esp", 0xF2, 0xF0, 0x29, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "xrelease lock sub dword ptr [ebp+04030201h],esp", 0xF3, 0xF0, 0x29, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "sub word ptr [di+0201h],sp", 0x66, 0x67, 0x29, 0xa5, 0x01, 0x02 );
    FCML_I32( "sub dword ptr [di+0201h],esp", 0x67, 0x29, 0xa5, 0x01, 0x02 );
    FCML_I64( "sub qword ptr [r9+rcx*4+0000000000000001h],r12", 0x4D, 0x29, 0x64, 0x89, 0x01 );
    FCML_I64( "sub dword ptr [rcx+rax*4+0000000000000001h],esp", 0x29, 0x64, 0x81, 0x01 );

    FCML_I32_A_FAILED( "lock sub ah,byte ptr [ebp+04030201h]", 0xF0, 0x2A, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "sub ah,byte ptr [ebp+04030201h]", 0x2A, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I64( "sub spl,byte ptr [rbp+0000000004030201h]", 0x40, 0x2a, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "sub spl,byte ptr [rbp+0000000000000001h]", 0x40, 0x2a, 0x65, 0x01 );

    FCML_I32_A_FAILED( "lock sub esp,dword ptr [ebp+04030201h]", 0xF0, 0x2b, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "sub esp,dword ptr [ebp+04030201h]", 0x2b, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_I32( "sub sp,word ptr [di+0201h]", 0x66, 0x67, 0x2b, 0xa5, 0x01, 0x02 );
    FCML_I32( "sub esp,dword ptr [di+0201h]", 0x67, 0x2b, 0xa5, 0x01, 0x02 );
    FCML_I64( "sub r12,qword ptr [r9+rcx*4+0000000000000001h]", 0x4D, 0x2b, 0x64, 0x89, 0x01 );

    FCML_A32( "sub 0x0201(%di),%sp", 0x66, 0x67, 0x2b, 0xa5, 0x01, 0x02 );
    FCML_A32( "sub 0x04030201(%ebp),%esp", 0x2b, 0xa5, 0x01, 0x02, 0x03, 04 );
    FCML_A64_M( "sub $0x42806521,%eax", 2, FCML_MI( 0x81, 0xe8, 0x21, 0x65, 0x80, 0x42 ), FCML_MI( 0x2d, 0x21, 0x65, 0x80, 0x42 ) );
    FCML_A64( "lock subb $0xff,0x04030201(%rip)", 0xf0, 0x80, 0x2d, 0x01, 0x02, 0x03, 0x04, 0xff );
    FCML_A64( "sub $0x04030201,%ebp", 0x81, 0xed, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64_M( "lock subq $0x0000000000000005,0x0000000004030201(%rdi)", 2, FCML_MI( 0xf0, 0x48, 0x83, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05 ), FCML_MI( 0xf0, 0x48, 0x81, 0xaf, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00 ) );
    FCML_A64( "xrelease lock sub %ah,0x0000000004030201(%rbp)", 0xf3, 0xf0, 0x28, 0xa5, 0x01, 0x02, 0x03, 0x04 );
}

void fcml_tf_instruction_SUBPD(void) {

    FCML_I32( "subpd xmm0,xmmword ptr [eax]", 0x66, 0x0F, 0x5C, 0x00 );
    FCML_I32( "subpd xmm0,xmm0", 0x66, 0x0F, 0x5C, 0xC0 );
    FCML_I64( "subpd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x5C, 0x00 );

    FCML_A64( "subpd (%rax),%xmm0", 0x66, 0x0f, 0x5c, 0x00 );
    FCML_A64( "subpd %xmm0,%xmm0", 0x66, 0x0f, 0x5c, 0xc0 );
    FCML_A64( "subpd (%rax),%xmm0", 0x66, 0x0f, 0x5c, 0x00 );

    FCML_I32_M("vsubpd xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc9, 0x5c, 0x00));
    FCML_I32_M("vsubpd xmm0,xmm6,xmm0", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x5c, 0xc0), FCML_MI(0xc5, 0xc9, 0x5c, 0xc0));
    FCML_I64_M("vsubpd xmm0,xmm6,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc9, 0x5c, 0x00));
    FCML_A64_M("vsubpd (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc9, 0x5c, 0x00));
    FCML_A64_M("vsubpd %xmm0,%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x5c, 0xc0), FCML_MI(0xc5, 0xc9, 0x5c, 0xc0));
    FCML_A64_M("vsubpd (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf1, 0xcd, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc9, 0x5c, 0x00));

    /* AVX-512 */
    FCML_I64("vsubpd ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x29, 0x5c, 0x14, 0x01);
    FCML_A64("vsubpd (%r9,%r8),%ymm14,%ymm10{%k1}", 0x62, 0x11, 0x8d, 0x29, 0x5c, 0x14, 0x01);
    FCML_I64("vsubpd xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x09, 0x5c, 0x14, 0x01);
    FCML_A64("vsubpd (%r9,%r8),%xmm14,%xmm10{%k1}", 0x62, 0x11, 0x8d, 0x09, 0x5c, 0x14, 0x01);
    FCML_I64("vsubpd zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0xed, 0x49, 0x5c, 0x0c, 0x01);
    FCML_A64("vsubpd (%r9,%r8),%zmm2,%zmm1{%k1}", 0x62, 0x91, 0xed, 0x49, 0x5c, 0x0c, 0x01);
    FCML_I32("vsubpd xmm1{k1},xmm1,xmmword ptr [ebp]", 0x62, 0xf1, 0xf5, 0x09, 0x5c, 0x4d, 0x00);
    FCML_I64("vsubpd ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0xa9, 0x5c, 0x14, 0x01);
    FCML_A64("vsubpd (%r9,%r8),%ymm14,%ymm10{%k1}{z}", 0x62, 0x11, 0x8d, 0xa9, 0x5c, 0x14, 0x01);
    FCML_I64("vsubpd xmm10{k1}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x8d, 0x89, 0x5c, 0x14, 0x01);
    FCML_A64("vsubpd (%r9,%r8),%xmm14,%xmm10{%k1}{z}", 0x62, 0x11, 0x8d, 0x89, 0x5c, 0x14, 0x01);
    FCML_I64("vsubpd zmm1{k1}{z},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0xed, 0xc9, 0x5c, 0x0c, 0x01);
    FCML_A64("vsubpd (%r9,%r8),%zmm2,%zmm1{%k1}{z}", 0x62, 0x91, 0xed, 0xc9, 0x5c, 0x0c, 0x01);
    FCML_I32("vsubpd xmm1{k1}{z},xmm1,xmmword ptr [ebp]", 0x62, 0xf1, 0xf5, 0x89, 0x5c, 0x4d, 0x00);
    FCML_I64("vsubpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xd5, 0x50, 0x5c, 0x3e);
    FCML_A64("vsubpd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x61, 0xd5, 0x50, 0x5c, 0x3e);
    FCML_I64("vsubpd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0x30, 0x5c, 0x3e);
    FCML_A64("vsubpd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x61, 0xd5, 0x30, 0x5c, 0x3e);
    FCML_I64("vsubpd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x61, 0xd5, 0x10, 0x5c, 0x3e);
    FCML_A64("vsubpd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x61, 0xd5, 0x10, 0x5c, 0x3e);
    FCML_I32("vsubpd xmm1,xmm1,mmword ptr [esi]{1to2}", 0x62, 0xf1, 0xf5, 0x18, 0x5c, 0x0e);
    FCML_I64("vsubpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xd5, 0xb7, 0x5c, 0x3e);
    FCML_A64("vsubpd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0xd5, 0xb7, 0x5c, 0x3e);
    FCML_I64("vsubpd zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0xd5, 0x97, 0x5c, 0xfc);
    FCML_A64("vsubpd {rn-sae},%zmm4,%zmm21,%zmm31{%k7}{z}", 0x62, 0x61, 0xd5, 0x97, 0x5c, 0xfc);
}

void fcml_tf_instruction_SUBPS(void) {

    FCML_I32( "subps xmm0,xmmword ptr [eax]", 0x0F, 0x5C, 0x00 );
    FCML_I32( "subps xmm0,xmm0", 0x0F, 0x5C, 0xC0 );
    FCML_I64( "subps xmm0,xmmword ptr [rax]", 0x0F, 0x5C, 0x00 );
    FCML_A64( "subps (%rax),%xmm0", 0x0f, 0x5c, 0x00 );
    FCML_A64( "subps %xmm0,%xmm0", 0x0f, 0x5c, 0xc0 );
    FCML_A64( "subps (%rax),%xmm0", 0x0f, 0x5c, 0x00 );

    FCML_I32_M("vsubps xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc8, 0x5c, 0x00));
    FCML_I32_M("vsubps xmm0,xmm6,xmm0", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x5c, 0xc0), FCML_MI(0xc5, 0xc8, 0x5c, 0xc0));
    FCML_I64_M("vsubps xmm0,xmm6,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc8, 0x5c, 0x00));
    FCML_A64_M("vsubps (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc8, 0x5c, 0x00));
    FCML_A64_M("vsubps %xmm0,%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x5c, 0xc0), FCML_MI(0xc5, 0xc8, 0x5c, 0xc0));
    FCML_A64_M("vsubps (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf1, 0x4c, 0x08, 0x5c, 0x00), FCML_MI(0xc5, 0xc8, 0x5c, 0x00));

    /* AVX-512 */

    /* {k} */
    FCML_I64("vsubps ymm10{k1},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x29, 0x5c, 0x14, 0x01);
    FCML_A64("vsubps (%r9,%r8),%ymm14,%ymm10{%k1}", 0x62, 0x11, 0x0C, 0x29, 0x5c, 0x14, 0x01);
    FCML_I64("vsubps xmm10{k1},xmm14,xmmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0x09, 0x5c, 0x14, 0x01);
    FCML_A64("vsubps (%r9,%r8),%xmm14,%xmm10{%k1}", 0x62, 0x11, 0x0C, 0x09, 0x5c, 0x14, 0x01);
    FCML_I64("vsubps zmm1{k1},zmm2,zmmword ptr [r9+r8]", 0x62, 0x91, 0x6C, 0x49, 0x5c, 0x0C, 0x01);
    FCML_A64("vsubps (%r9,%r8),%zmm2,%zmm1{%k1}", 0x62, 0x91, 0x6C, 0x49, 0x5c, 0x0C, 0x01);

    /* {k}{z} */
    FCML_I64("vsubps ymm10{k1}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x11, 0x0C, 0xA9, 0x5c, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vsubps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x54, 0x50, 0x5c, 0x3E);

    /* {k}{z}{bcast} */
    FCML_I64("vsubps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x61, 0x54, 0xB7, 0x5c, 0x3E);
    FCML_A64("vsubps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x61, 0x54, 0xB7, 0x5c, 0x3E);

    /* {rn} */
    FCML_I64("vsubps zmm31{k7}{z},zmm21,zmm4,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x5c, 0xFC);
    FCML_I32_FAILED("vsubps xmm1{k7}{z},xmm1,xmm1,{rn-sae}", 0x62, 0x61, 0x54, 0x97, 0x5c, 0xFC);

    /* Compressed disp8 */
    FCML_I64("vsubps xmm1{k4}{z},xmm0,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x5c, 0x4C, 0x24, 0x08);
    FCML_I64("vsubps xmm1{k4}{z},xmm0,dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x5c, 0x4C, 0x24, 0x74);
    FCML_I32("vsubps xmm1{k4}{z},xmm0,dword ptr [esp+00000020h]{1to4}", 0x62, 0xF1, 0x7C, 0x9C, 0x5c, 0x4C, 0x24, 0x08);
}

void fcml_tf_instruction_SUBSD(void) {

    FCML_I32( "subsd xmm2,mmword ptr [ecx+eax]", 0xF2, 0x0F, 0x5C, 0x14, 0x01 );
    FCML_I64( "subsd xmm2,mmword ptr [rcx+rax]", 0xF2, 0x0F, 0x5C, 0x14, 0x01 );
    FCML_A64( "subsd (%rcx,%rax),%xmm2", 0xf2, 0x0f, 0x5c, 0x14, 0x01 );
    FCML_A64( "subsd (%rcx,%rax),%xmm2", 0xf2, 0x0f, 0x5c, 0x14, 0x01 );

    FCML_I32_M("vsubsd xmm2,xmm5,mmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xd7, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xd3, 0x5c, 0x14, 0x01));
    FCML_I32_M("vsubsd xmm2,xmm4,mmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x5c, 0x14, 0x01));
    FCML_A64_M("vsubsd (%rcx,%rax),%xmm5,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xd7, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xd3, 0x5c, 0x14, 0x01));
    FCML_A64_M("vsubsd (%rcx,%rax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0xdf, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xdb, 0x5c, 0x14, 0x01));

    /* {k1}{z} */
    FCML_I64("vsubsd xmm2{k1},xmm4,mmword ptr [rcx+rax]", 0x62, 0xf1, 0xdf, 0x09, 0x5c, 0x14, 0x01);
    FCML_I64("vsubsd xmm2{k1}{z},xmm4,mmword ptr [rcx+rax]", 0x62, 0xf1, 0xdf, 0x89, 0x5c, 0x14, 0x01);
    FCML_I64("vsubsd xmm31{k7}{z},xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0xD7, 0x97, 0x5c, 0xFC);
    FCML_I64("vsubsd xmm31,xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0xD7, 0x10, 0x5c, 0xFC);
    FCML_I64("vsubsd xmm31,xmm31,xmm31,{rn-sae}", 0x62, 0x01, 0x87, 0x10, 0x5c, 0xFF);
    FCML_I32("vsubsd xmm1,xmm6,xmm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x18, 0x5c, 0xCC);
    FCML_I32_A_FAILED("vsubsd ymm1,ymm6,ymm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x38, 0x5c, 0xCC);
    FCML_I32_A_FAILED("vsubsd zmm1,zmm6,zmm4,{rn-sae}", 0x62, 0xF1, 0xCF, 0x58, 0x5c, 0xCC);
}

void fcml_tf_instruction_SUBSS(void) {

    FCML_I32( "subss xmm2,dword ptr [ecx+eax]", 0xF3, 0x0F, 0x5C, 0x14, 0x01 );
    FCML_I64( "subss xmm2,dword ptr [rcx+rax]", 0xF3, 0x0F, 0x5C, 0x14, 0x01 );

    FCML_A64( "subss (%rcx,%rax),%xmm2", 0xf3, 0x0f, 0x5c, 0x14, 0x01 );
    FCML_A64( "subss (%rcx,%rax),%xmm2", 0xf3, 0x0f, 0x5c, 0x14, 0x01 );

    FCML_I32_M("vsubss xmm2,xmm5,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x56, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xd2, 0x5c, 0x14, 0x01));
    FCML_I32_M("vsubss xmm2,xmm4,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x5c, 0x14, 0x01));
    FCML_A64_M("vsubss (%rcx,%rax),%xmm5,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x56, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xd2, 0x5c, 0x14, 0x01));
    FCML_A64_M("vsubss (%rcx,%rax),%xmm4,%xmm2", 2, FCML_MI(0x62, 0xf1, 0x5e, 0x08, 0x5c, 0x14, 0x01), FCML_MI(0xc5, 0xda, 0x5c, 0x14, 0x01));

    /* {k1}{z} */
    FCML_I64("vsubss xmm2{k1},xmm4,dword ptr [rcx+rax]", 0x62, 0xf1, 0x5E, 0x09, 0x5c, 0x14, 0x01);
    FCML_I64("vsubss xmm2{k1}{z},xmm4,dword ptr [rcx+rax]", 0x62, 0xf1, 0x5E, 0x89, 0x5c, 0x14, 0x01);
    FCML_I64("vsubss xmm31{k7}{z},xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0x56, 0x97, 0x5c, 0xFC);
    FCML_I64("vsubss xmm31,xmm21,xmm4,{rn-sae}", 0x62, 0x61, 0x56, 0x10, 0x5c, 0xFC);
    FCML_I64("vsubss xmm31,xmm31,xmm31,{rn-sae}", 0x62, 0x01, 0x06, 0x10, 0x5c, 0xFF);
    FCML_I32("vsubss xmm1,xmm6,xmm4,{rn-sae}", 0x62, 0xF1, 0x4E, 0x18, 0x5c, 0xCC);
    FCML_I32_A_FAILED("vsubss ymm1,ymm6,ymm4,{rn-sae}", 0x62, 0xF1, 0x4E, 0x38, 0x5c, 0xCC);
    FCML_I32_A_FAILED("vsubss zmm1,zmm6,zmm4,{rn-sae}", 0x62, 0xF1, 0x4E, 0x58, 0x5c, 0xCC);
}

void fcml_tf_instruction_SWAPGS(void) {

    FCML_I64( "swapgs", 0x0F, 0x01, 0xF8 );
    FCML_I32_FAILED( "swapgs", 0x0F, 0x01, 0xF8 );

    FCML_A64( "swapgs", 0x0f, 0x01, 0xf8 );
}

void fcml_tf_instruction_SYSCALL(void) {

    FCML_I64( "syscall", 0x0F, 0x05 );
    FCML_I32_FAILED( "syscall", 0x0F, 0x05 );

    FCML_A64( "syscall", 0x0f, 0x05 );
}

void fcml_tf_instruction_SYSENTER(void) {

    FCML_I3264( "sysenter", 0x0F, 0x34 );
    FCML_A64( "sysenter", 0x0f, 0x34 );
}

void fcml_tf_instruction_SYSEXIT(void) {

    FCML_I32( "sysexit", 0x0F, 0x35 );
    FCML_I64( "sysexit", 0x0F, 0x35 );
    FCML_I64_D( "sysexit", 0x48, 0x0F, 0x35 );

    FCML_A32( "sysexit", 0x0f, 0x35 );
    FCML_A64( "sysexit", 0x0f, 0x35 );
}

void fcml_tf_instruction_SYSRET(void) {

    FCML_I32_FAILED( "sysret", 0x0F, 0x07 );
    FCML_I64( "sysret", 0x0F, 0x07 );
    FCML_I64_D( "sysret", 0x48, 0x0F, 0x07 );

    FCML_A64( "sysret", 0x0f, 0x07 );
}

void fcml_tf_instruction_SHLX_SHRX_SARX(void) {

    FCML_I32( "shlx eax,dword ptr [eax],edi", 0xC4, 0xE2, 0x41, 0xF7, 0x00 );
    FCML_I32( "shlx eax,eax,edi", 0xC4, 0xE2, 0x41, 0xF7, 0xC0 );
    FCML_I64( "shlx rax,qword ptr [rax],rdi", 0xC4, 0xE2, 0xC1, 0xF7, 0x00 );
    FCML_I64( "shlx rax,rax,rdi", 0xC4, 0xE2, 0xC1, 0xF7, 0xC0 );

    FCML_I32( "shrx eax,dword ptr [eax],edi", 0xC4, 0xE2, 0x43, 0xF7, 0x00 );
    FCML_I32( "shrx eax,eax,edi", 0xC4, 0xE2, 0x43, 0xF7, 0xC0 );
    FCML_I64( "shrx rax,qword ptr [rax],rdi", 0xC4, 0xE2, 0xC3, 0xF7, 0x00 );
    FCML_I64( "shrx rax,rax,rdi", 0xC4, 0xE2, 0xC3, 0xF7, 0xC0 );

    FCML_I32( "sarx eax,dword ptr [eax],edi", 0xC4, 0xE2, 0x42, 0xF7, 0x00 );
    FCML_I32( "sarx eax,eax,edi", 0xC4, 0xE2, 0x42, 0xF7, 0xC0 );
    FCML_I64( "sarx rax,qword ptr [rax],rdi", 0xC4, 0xE2, 0xC2, 0xF7, 0x00 );
    FCML_I64( "sarx rax,rax,rdi", 0xC4, 0xE2, 0xC2, 0xF7, 0xC0 );

    FCML_A64( "shlx %edi,(%rax),%eax", 0xc4, 0xe2, 0x41, 0xf7, 0x00 );
    FCML_A64( "shlx %edi,%eax,%eax", 0xc4, 0xe2, 0x41, 0xf7, 0xc0 );
    FCML_A64( "shlx %rdi,(%rax),%rax", 0xc4, 0xe2, 0xc1, 0xf7, 0x00 );
    FCML_A64( "shlx %rdi,%rax,%rax", 0xc4, 0xe2, 0xc1, 0xf7, 0xc0 );
    FCML_A64( "shrx %edi,(%rax),%eax", 0xc4, 0xe2, 0x43, 0xf7, 0x00 );
    FCML_A64( "shrx %edi,%eax,%eax", 0xc4, 0xe2, 0x43, 0xf7, 0xc0 );
    FCML_A64( "shrx %rdi,(%rax),%rax", 0xc4, 0xe2, 0xc3, 0xf7, 0x00 );
    FCML_A64( "shrx %rdi,%rax,%rax", 0xc4, 0xe2, 0xc3, 0xf7, 0xc0 );
    FCML_A64( "sarx %edi,(%rax),%eax", 0xc4, 0xe2, 0x42, 0xf7, 0x00 );
    FCML_A64( "sarx %edi,%eax,%eax", 0xc4, 0xe2, 0x42, 0xf7, 0xc0 );
    FCML_A64( "sarx %rdi,(%rax),%rax", 0xc4, 0xe2, 0xc2, 0xf7, 0x00 );
    FCML_A64( "sarx %rdi,%rax,%rax", 0xc4, 0xe2, 0xc2, 0xf7, 0xc0 );
}

void fcml_tf_instruction_STAC(void) {

    FCML_I3264( "stac", 0x0F, 0x01, 0xCB );
    FCML_A3264( "stac", 0x0F, 0x01, 0xCB );
}

fcml_stf_test_case fctl_ti_instructions_s[] = {
    { "fcml_tf_instruction_SAHF", fcml_tf_instruction_SAHF },
    { "fcml_tf_instruction_SHL", fcml_tf_instruction_SHL },
    { "fcml_tf_instruction_SAL", fcml_tf_instruction_SAL },
    { "fcml_tf_instruction_SAR", fcml_tf_instruction_SAR },
    { "fcml_tf_instruction_SHR", fcml_tf_instruction_SHR },
    { "fcml_tf_instruction_SBB", fcml_tf_instruction_SBB },
    { "fcml_tf_instruction_SCAS", fcml_tf_instruction_SCAS },
    { "fcml_tf_instruction_SETcc", fcml_tf_instruction_SETcc },
    { "fcml_tf_instruction_SFENCE", fcml_tf_instruction_SFENCE },
    { "fcml_tf_instruction_SGDT", fcml_tf_instruction_SGDT },
    { "fcml_tf_instruction_SHLD", fcml_tf_instruction_SHLD },
    { "fcml_tf_instruction_SHRD", fcml_tf_instruction_SHRD },
    { "fcml_tf_instruction_SKINIT", fcml_tf_instruction_SKINIT },
    { "fcml_tf_instruction_SLWPCB", fcml_tf_instruction_SLWPCB },
    { "fcml_tf_instruction_SHUFPD", fcml_tf_instruction_SHUFPD },
    { "fcml_tf_instruction_SHUFPS", fcml_tf_instruction_SHUFPS },
    { "fcml_tf_instruction_SIDT", fcml_tf_instruction_SIDT },
    { "fcml_tf_instruction_SLDT", fcml_tf_instruction_SLDT },
    { "fcml_tf_instruction_SMSW", fcml_tf_instruction_SMSW },
    { "fcml_tf_instruction_SQRTPD", fcml_tf_instruction_SQRTPD },
    { "fcml_tf_instruction_SQRTPS", fcml_tf_instruction_SQRTPS },
    { "fcml_tf_instruction_SQRTSD", fcml_tf_instruction_SQRTSD },
    { "fcml_tf_instruction_SQRTSS", fcml_tf_instruction_SQRTSS },
    { "fcml_tf_instruction_STC", fcml_tf_instruction_STC },
    { "fcml_tf_instruction_STD", fcml_tf_instruction_STD },
    { "fcml_tf_instruction_STGI", fcml_tf_instruction_STGI },
    { "fcml_tf_instruction_STI", fcml_tf_instruction_STI },
    { "fcml_tf_instruction_STMXCSR", fcml_tf_instruction_STMXCSR },
    { "fcml_tf_instruction_STOS", fcml_tf_instruction_STOS },
    { "fcml_tf_instruction_STR", fcml_tf_instruction_STR },
    { "fcml_tf_instruction_SUB", fcml_tf_instruction_SUB },
    { "fcml_tf_instruction_SUBPD", fcml_tf_instruction_SUBPD },
    { "fcml_tf_instruction_SUBPS", fcml_tf_instruction_SUBPS },
    { "fcml_tf_instruction_SUBSD", fcml_tf_instruction_SUBSD },
    { "fcml_tf_instruction_SUBSS", fcml_tf_instruction_SUBSS },
    { "fcml_tf_instruction_SWAPGS", fcml_tf_instruction_SWAPGS },
    { "fcml_tf_instruction_SYSCALL", fcml_tf_instruction_SYSCALL },
    { "fcml_tf_instruction_SYSENTER", fcml_tf_instruction_SYSENTER },
    { "fcml_tf_instruction_SYSEXIT", fcml_tf_instruction_SYSEXIT },
    { "fcml_tf_instruction_SYSRET", fcml_tf_instruction_SYSRET },
    { "fcml_tf_instruction_SHLX_SHRX_SARX", fcml_tf_instruction_SHLX_SHRX_SARX },
    { "fcml_tf_instruction_STAC", fcml_tf_instruction_STAC },
    FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_s = {
    "suite-fctl_ti_instructions_s", fcml_tf_instructions_s_suite_init, fcml_tf_instructions_s_suite_cleanup, fctl_ti_instructions_s
};

