---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, tables des matières
---

# Comment afficher uniquement une table des matières d'un document ?

Une table de matière ne se génère qu'en présence des sections, chapitres 
et autres niveaux de sectionnement d'un document. Si vous souhaitez donc
obtenir un document qui ne contient que la table des matières d'un document
(par exemple pour une vérification de la bonne structuration de votre projet
de document), vous allez devoir ruser.

Lors d'une compilation, les données servant à alimenter la table des matières
sont stockées dans un fichier TOC portant le même nom que votre document 
TEX. C'est ce fichier TOC qui va vous servir à obtenir votre table
des matières isolée.

Supposons que votre document complet `monprojet.tex` soit le suivant :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\section{La matière}
\section{Les tables}
\subsection{La matière des tables}
\newpage
\section{La matière passe à table}
\tableofcontents
\end{document}
```

Vous le compilez alors pour obtenir votre document avec sa table des matières
(autant de fois que nécessaire). Vous constituez ensuite votre fichier (de
préférence dans le même dossier de travail que votre fichier `monprojet.tex`)
qui va appeler le fichier `monprojet.toc` pour en afficher le contenu. 
À l'endroit où vous voulez faire apparaître cette table des matières 
dans votre nouveau document, vous devrez indiquer :

```{noedit}
\makeatletter
\input{monprojet.toc}
\makeatother
```

La présence des commandes `\makeatletter` et `\makeatother` tient au fait 
que le fichier TOC contient des caractères `@`. 

Pour les besoins de notre FAQ pour cet exemple, nous recréons le contenu 
du fichier `monprojet.toc`. Vous n'aurez pas besoin des lignes 
de reconstitution pour votre nouveau fichier.

```
% Reconstitution du fichier TOC avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{monprojet.toc}
\babel@toc {french}{}\relax 
\contentsline {section}{\numberline {1}La matière}{1}{}%
\contentsline {section}{\numberline {2}Les tables}{1}{}%
\contentsline {subsection}{\numberline {2.1}La matière des tables}{1}{}%
\contentsline {section}{\numberline {3}La matière passe à table}{2}{}%
\end{filecontents}
% Fin de la reconstitution du fichier

\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\makeatletter
\input{monprojet.toc}
\makeatother
\end{document}
```


:::{sources}
- [Copier la table des matières uniquement](https://texnique.fr/osqa/questions/2057/copier-la-table-des-matieres-uniquement) 
  sur [TeXnique.fr](https://texnique.fr/).
:::