/* $Id: tstDisasmArmv8-1-asm-rcpc.S $ */
/** @file
 * VBox disassembler - Tables for ARMv8 A64 - RCPC.
 */

/*
 * Copyright (C) 2024-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include <iprt/asmdefs-arm.h>

BEGINPROC_HIDDEN TestProcA64Rcpc

        .cpu generic+rcpc

        ldaprb w0, [x1]
        ldaprb wzr, [sp]

        ldaprh w0, [x1]
        ldaprh wzr, [sp]

        ldapr w0, [x1]
        ldapr wzr, [sp]
        ldapr x0, [x1]
        ldapr xzr, [sp]

        /*
         * Keep last so the testcase can catch errors in
         * the disassembly of the last instruction.
         */
        nop

BEGINPROC_HIDDEN TestProcA64Rcpc_EndProc
