/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.event.BroadcastDispatch;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class ListenerBroadcast<T>
implements Dispatch<MethodInvocation> {
    private final Class<T> type;
    private @Nullable ProxyDispatchAdapter<T> source;
    private volatile BroadcastDispatch<T> broadcast;

    public ListenerBroadcast(Class<T> type) {
        this.type = type;
        this.broadcast = BroadcastDispatch.empty(type);
    }

    public synchronized T getSource() {
        if (this.source == null) {
            this.source = new ProxyDispatchAdapter<T>(this, this.type);
        }
        return this.source.getSource();
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.broadcast.isEmpty();
    }

    public int size() {
        return this.broadcast.size();
    }

    public synchronized void add(T listener) {
        this.broadcast = this.broadcast.add(listener);
    }

    public synchronized void addAll(Collection<? extends T> listeners) {
        this.broadcast = this.broadcast.addAll(listeners);
    }

    public synchronized void add(Dispatch<MethodInvocation> dispatch) {
        this.broadcast = this.broadcast.add(dispatch);
    }

    public synchronized void add(String methodName, Action<?> action) {
        this.broadcast = this.broadcast.add(methodName, action);
    }

    public synchronized void remove(Object listener) {
        this.broadcast = this.broadcast.remove(listener);
    }

    public synchronized void removeAll(Collection<?> listeners) {
        this.broadcast = this.broadcast.removeAll(listeners);
    }

    public synchronized void removeAll() {
        this.broadcast = BroadcastDispatch.empty(this.type);
    }

    synchronized void replaceWith(Dispatch<MethodInvocation> dispatch) {
        this.broadcast = BroadcastDispatch.empty(this.type).add(dispatch);
    }

    @Override
    public void dispatch(MethodInvocation event) {
        this.broadcast.dispatch(event);
    }

    public void visitListeners(Action<T> visitor) {
        this.broadcast.visitListeners(visitor);
    }

    public void visitListenersUntyped(Action<Object> visitor) {
        this.broadcast.visitListenersUntyped(visitor);
    }

    public ListenerBroadcast<T> copy() {
        ListenerBroadcast<T> result = new ListenerBroadcast<T>(this.type);
        result.broadcast = this.broadcast;
        return result;
    }
}

