/*
 * Decompiled with CFR 0.152.
 */
package utilities.util;

import generic.jar.ResourceFile;

public class FileResolutionResult {
    private static FileResolutionResult OK_RESULT = new FileResolutionResult(FileResolutionStatus.OK, "");
    private final FileResolutionStatus status;
    private final String message;

    public static FileResolutionResult doesNotExist(ResourceFile file) {
        String message = "File does not exist: " + String.valueOf(file);
        return new FileResolutionResult(FileResolutionStatus.FileDoesNotExist, message);
    }

    public static FileResolutionResult notCaseDependent(String canonicalPath, String userPath) {
        String message = "Case difference found:\n\tCanonical path: " + canonicalPath + "\n\tUser path: " + userPath;
        return new FileResolutionResult(FileResolutionStatus.NotProperlyCaseDependent, message);
    }

    public static FileResolutionResult ok() {
        return OK_RESULT;
    }

    public static FileResolutionResult createDoesNotExistResult() {
        return null;
    }

    private FileResolutionResult(FileResolutionStatus status, String message) {
        this.status = status;
        this.message = message;
    }

    public FileResolutionStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isOk() {
        return this.status == FileResolutionStatus.OK;
    }

    public static enum FileResolutionStatus {
        OK,
        FileDoesNotExist,
        NotProperlyCaseDependent;

    }
}

