/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import java.util.Arrays;

public class IntelHexRecord {
    public static final int MAX_RECORD_LENGTH = 255;
    public static final int DATA_RECORD_TYPE = 0;
    public static final int END_OF_FILE_RECORD_TYPE = 1;
    public static final int EXTENDED_SEGMENT_ADDRESS_RECORD_TYPE = 2;
    public static final int START_SEGMENT_ADDRESS_RECORD = 3;
    public static final int EXTENDED_LINEAR_ADDRESS_RECORD_TYPE = 4;
    public static final int START_LINEAR_ADDRESS_RECORD_TYPE = 5;
    private final int recordLength;
    private final int loadOffset;
    private final int recordType;
    private final byte[] data;
    private final int checksum;
    private final int actualChecksum;

    public IntelHexRecord(int recordLength, int loadOffset, int recordType, byte[] data, int checksum) {
        this.recordLength = recordLength;
        this.loadOffset = loadOffset;
        this.recordType = recordType;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
        this.checksum = checksum;
        this.actualChecksum = IntelHexRecord.checksum(recordLength, loadOffset, recordType, data);
        this.checkValidity();
    }

    public IntelHexRecord(int recordLength, int loadOffset, int recordType, byte[] data) {
        this(recordLength, loadOffset, recordType, data, IntelHexRecord.checksum(recordLength, loadOffset, recordType, data));
    }

    private void checkValidity() {
        this.checkRecordLength();
        this.checkLoadOffset();
        this.checkRecordType();
    }

    private void checkLoadOffset() {
        if (this.getLoadOffset() < 0) {
            throw new IllegalArgumentException("loadOffset < 0");
        }
        if (this.getLoadOffset() > 65535) {
            throw new IllegalArgumentException("loadOffset > 0xffff");
        }
    }

    private void checkRecordType() {
        switch (this.getRecordType()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getRecordLength() != 0) {
                    throw new IllegalArgumentException("bad length (" + this.getRecordLength() + ") for End Of File Record");
                }
                if (this.getLoadOffset() == 0) break;
                throw new IllegalArgumentException("bad load offset (" + this.getLoadOffset() + ") for End Of File Record");
            }
            case 2: {
                if (this.getRecordLength() != 2) {
                    throw new IllegalArgumentException("bad length (" + this.getRecordLength() + ") for Extended Segment Address Record");
                }
                if (this.getLoadOffset() == 0) break;
                throw new IllegalArgumentException("bad load offset (" + this.getLoadOffset() + ") for Extended Segment Address Record");
            }
            case 3: {
                if (this.getRecordLength() != 4) {
                    throw new IllegalArgumentException("bad length (" + this.getRecordLength() + ") for Start Segment Address Record");
                }
                if (this.getLoadOffset() == 0) break;
                throw new IllegalArgumentException("bad load offset (" + this.getLoadOffset() + ") for Start Segment Address Record");
            }
            case 4: {
                if (this.getRecordLength() != 2) {
                    throw new IllegalArgumentException("bad length (" + this.getRecordLength() + ") for Extended Linear Address Record");
                }
                if (this.getLoadOffset() == 0) break;
                throw new IllegalArgumentException("bad load offset (" + this.getLoadOffset() + ") for Extended Linear Address Record");
            }
            case 5: {
                if (this.getRecordLength() != 4) {
                    throw new IllegalArgumentException("bad length (" + this.getRecordLength() + ") for Start Linear Address Record");
                }
                if (this.getLoadOffset() == 0) break;
                throw new IllegalArgumentException("bad load offset (" + this.getLoadOffset() + ") for Start Linear Address Record");
            }
            default: {
                throw new IllegalArgumentException("illegal record type - " + this.getRecordType());
            }
        }
    }

    private void checkRecordLength() {
        if (this.getRecordLength() != this.data.length) {
            throw new IllegalArgumentException("recordLength != data.length");
        }
        if (this.getRecordLength() > 255) {
            throw new IllegalArgumentException("recordLength > 255");
        }
    }

    private static int checksum(int recordLength, int loadOffset, int recordType, byte[] data) {
        int accum = 0;
        accum += recordLength & 0xFF;
        accum += loadOffset & 0xFF;
        accum += loadOffset >> 8 & 0xFF;
        accum += recordType & 0xFF;
        for (int ii = 0; ii < data.length; ++ii) {
            int t = data[ii] & 0xFF;
            accum += t;
        }
        int lowest = accum & 0xFF;
        int chk = 256 - lowest & 0xFF;
        return chk;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getLoadOffset() {
        return this.loadOffset;
    }

    public int getRecordType() {
        return this.recordType;
    }

    public byte[] getData() {
        byte[] result = new byte[this.data.length];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        return result;
    }

    public String getDataString() {
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            buffy.append(String.format("%02X", this.data[i]));
        }
        return buffy.toString();
    }

    public int getReportedChecksum() {
        return this.checksum;
    }

    public int getActualChecksum() {
        return this.actualChecksum;
    }

    public boolean isReportedChecksumCorrect() {
        return this.checksum == this.actualChecksum;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(":%02X%04X%02X", this.getRecordLength(), this.getLoadOffset(), this.getRecordType()));
        for (int ii = 0; ii < this.data.length; ++ii) {
            sb.append(String.format("%02X", this.data[ii]));
        }
        sb.append(String.format("%02X", this.getActualChecksum()));
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.actualChecksum;
        result = 31 * result + this.checksum;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.loadOffset;
        result = 31 * result + this.recordLength;
        result = 31 * result + this.recordType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntelHexRecord other = (IntelHexRecord)obj;
        if (this.actualChecksum != other.actualChecksum) {
            return false;
        }
        if (this.checksum != other.checksum) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.loadOffset != other.loadOffset) {
            return false;
        }
        if (this.recordLength != other.recordLength) {
            return false;
        }
        return this.recordType == other.recordType;
    }
}

