/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.SectionAttributes;
import ghidra.app.util.bin.format.macho.SectionTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Section
implements StructConverter {
    private String sectname;
    private String segname;
    private long addr;
    private long size;
    private int offset;
    private int align;
    private int reloff;
    private int nrelocs;
    private int flags;
    private int reserved1;
    private int reserved2;
    private int reserved3;
    private BinaryReader reader;
    private boolean is32bit;
    private List<RelocationInfo> relocations = new ArrayList<RelocationInfo>();

    public Section(BinaryReader reader, boolean is32bit) throws IOException {
        this.reader = reader;
        this.is32bit = is32bit;
        this.sectname = reader.readNextAsciiString(16);
        this.segname = reader.readNextAsciiString(16);
        if (is32bit) {
            this.addr = reader.readNextUnsignedInt();
            this.size = reader.readNextUnsignedInt();
        } else {
            this.addr = reader.readNextLong();
            this.size = reader.readNextLong();
        }
        this.offset = reader.readNextInt();
        this.align = reader.readNextInt();
        this.reloff = reader.readNextInt();
        this.nrelocs = reader.readNextInt();
        this.flags = reader.readNextInt();
        this.reserved1 = reader.readNextInt();
        this.reserved2 = reader.readNextInt();
        if (!is32bit) {
            this.reserved3 = reader.readNextInt();
        }
        long index = reader.getPointerIndex();
        reader.setPointerIndex(this.reloff);
        for (int i = 0; i < this.nrelocs; ++i) {
            this.relocations.add(new RelocationInfo(reader));
        }
        reader.setPointerIndex(index);
    }

    public List<RelocationInfo> getRelocations() {
        return this.relocations;
    }

    public boolean isRead() {
        return true;
    }

    public boolean isWrite() {
        if (this.sectname.startsWith("__got")) {
            return true;
        }
        return !"__TEXT".equals(this.segname) && !"__TEXT_EXEC".equals(this.segname) && !"__PRELINK_TEXT".equals(this.segname) && !"__const".equals(this.sectname);
    }

    public boolean isExecute() {
        if ("__text".equals(this.sectname) || "__TEXT_EXEC".equals(this.segname)) {
            return true;
        }
        boolean pureInstr = (this.getAttributes() & Integer.MIN_VALUE) != 0;
        boolean someInstr = (this.getAttributes() & 0x400) != 0;
        return pureInstr || someInstr;
    }

    public InputStream getDataStream(MachHeader header) throws IOException {
        if (this.getType() == 1) {
            return new SectionInputStream(this, this.getSize(), 0);
        }
        if (this.getSectionName().equals("__jump_table") && header.getFileType() == 2) {
            return new SectionInputStream(this, this.getSize(), -12);
        }
        return this.reader.getByteProvider().getInputStream(header.getStartIndex() + (long)this.offset);
    }

    public String getSectionName() {
        return this.sectname;
    }

    public void setSectionName(String name) {
        this.sectname = name;
    }

    public String getSegmentName() {
        return this.segname;
    }

    public void setSegmentName(String name) {
        this.segname = name;
    }

    public long getAddress() {
        if ((this.addr & 0xFFF000000000L) == 0xFFF000000000L) {
            return this.addr | 0xFFFF000000000000L;
        }
        return this.addr;
    }

    public long getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getAlign() {
        return this.align;
    }

    public int getRelocationOffset() {
        return this.reloff;
    }

    public int getNumberOfRelocations() {
        return this.nrelocs;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getType() {
        return this.flags & 0xFF;
    }

    public int getAttributes() {
        return this.flags & 0xFFFFFF00;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getReserved3() {
        return this.reserved3;
    }

    public boolean contains(long address) {
        return Long.compareUnsigned(address, this.addr) >= 0 && Long.compareUnsigned(address, this.addr + this.size) < 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("section", 0);
        struct.add((DataType)new StringDataType(), 16, "sectname", null);
        struct.add((DataType)new StringDataType(), 16, "segname", null);
        if (this.is32bit) {
            struct.add(DWORD, "addr", null);
            struct.add(DWORD, "size", null);
        } else {
            struct.add(QWORD, "addr", null);
            struct.add(QWORD, "size", null);
        }
        struct.add(DWORD, "offset", null);
        struct.add(DWORD, "align", null);
        struct.add(DWORD, "reloff", null);
        struct.add(DWORD, "nrelocs", null);
        struct.add(DWORD, "flags", null);
        struct.add(DWORD, "reserved1", null);
        struct.add(DWORD, "reserved2", null);
        if (!this.is32bit) {
            struct.add(DWORD, "reserved3", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("      Name: " + this.sectname + "\n");
        buffer.append("   Address: 0x" + Long.toHexString(this.addr) + "\n");
        buffer.append("    Length: 0x" + Long.toHexString(this.size) + "\n");
        buffer.append("      Type: 0x" + Integer.toHexString(this.getType()) + " (" + SectionTypes.getTypeName(this.getType()) + ")\n");
        buffer.append("    Offset: 0x" + Long.toHexString(this.offset) + "\n");
        List<String> attrs = SectionAttributes.getAttributeNames(this.getAttributes());
        buffer.append("Attributes: " + Integer.toHexString(this.getAttributes()) + "\n");
        for (String attr : attrs) {
            buffer.append("            " + attr + "\n");
        }
        return buffer.toString();
    }

    private class SectionInputStream
    extends InputStream {
        long streamSize;
        byte value;
        long nRead;

        SectionInputStream(Section section, long streamSize, byte value) {
            this.streamSize = streamSize;
            this.value = value;
        }

        @Override
        public int read() throws IOException {
            if (++this.nRead > this.streamSize) {
                return -1;
            }
            return this.value & 0xFF;
        }
    }
}

