/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.flowarrow;

import docking.widgets.fieldpanel.FieldPanel;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.flowarrow.ConditionalFlowArrow;
import ghidra.app.plugin.core.flowarrow.DefaultFlowArrow;
import ghidra.app.plugin.core.flowarrow.FallthroughFlowArrow;
import ghidra.app.plugin.core.flowarrow.FlowArrow;
import ghidra.app.plugin.core.flowarrow.FlowArrowPanel;
import ghidra.app.services.CodeViewerService;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Show arrows for execution flow", description="This plugin shows arrows to graphically illustrate the flow of execution within a function. The arrows indicate source and destination for jumps; solid lines indicate unconditional jumps; dashed lines indicate conditional jumps.", servicesRequired={CodeViewerService.class}, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramLocationPluginEvent.class})
public class FlowArrowPlugin
extends Plugin
implements MarginProvider,
OptionsChangeListener {
    static final int LEFT_OFFSET = 3;
    static final int MAX_DEPTH = 16;
    private static final int MAX_REFSTO_SHOW = 10;
    private FlowArrowPanel flowArrowPanel;
    private boolean enabled = true;
    private boolean validState = false;
    private Address currentAddr;
    private Map<Address, Integer> startAddressToPixel = new HashMap<Address, Integer>();
    private Map<Address, Integer> endAddressToPixel = new HashMap<Address, Integer>();
    private VerticalPixelAddressMap layoutToPixel;
    private Address screenTop;
    private Address screenBottom;
    private int maxDepth;
    private Program program;
    private CodeViewerService codeViewerService;
    private List<FlowArrow> flowArrows = new ArrayList<FlowArrow>();
    private Set<FlowArrow> selectedArrows = new HashSet<FlowArrow>();
    private Set<FlowArrow> activeArrows = new HashSet<FlowArrow>();

    public FlowArrowPlugin(PluginTool tool) {
        super(tool);
        this.flowArrowPanel = new FlowArrowPanel(this);
        this.flowArrowPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean previousState = FlowArrowPlugin.this.enabled;
                boolean bl = FlowArrowPlugin.this.enabled = FlowArrowPlugin.this.flowArrowPanel.getWidth() > 3;
                if (FlowArrowPlugin.this.enabled && !previousState) {
                    FlowArrowPlugin.this.updateAndRepaint();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                boolean previousState = FlowArrowPlugin.this.enabled;
                boolean bl = FlowArrowPlugin.this.enabled = FlowArrowPlugin.this.flowArrowPanel.getWidth() > 3;
                if (FlowArrowPlugin.this.enabled && !previousState) {
                    FlowArrowPlugin.this.updateAndRepaint();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                FlowArrowPlugin.this.enabled = false;
            }
        });
        this.getOptions();
    }

    @Override
    public JComponent getComponent() {
        return this.flowArrowPanel;
    }

    @Override
    public MarkerLocation getMarkerLocation(int x, int y) {
        return null;
    }

    @Override
    public boolean isResizeable() {
        return true;
    }

    @Override
    public void setProgram(Program program, AddressIndexMap addrMap, VerticalPixelAddressMap pixmap) {
        this.layoutToPixel = pixmap;
        this.validateState();
        this.updateFlowArrows();
    }

    public void processEvent(PluginEvent event) {
        ProgramClosedPluginEvent programClosedPluginEvent;
        Program closedProgram;
        boolean repaintReqd = false;
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent evt = (ProgramActivatedPluginEvent)event;
            this.program = evt.getActiveProgram();
            this.flowArrows.clear();
            this.validateState();
            repaintReqd = true;
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent evt = (ProgramLocationPluginEvent)event;
            ProgramLocation location = evt.getLocation();
            this.currentAddr = location.getAddress();
            this.activeArrows.clear();
            repaintReqd = true;
        } else if (event instanceof ProgramClosedPluginEvent && (this.program == (closedProgram = (programClosedPluginEvent = (ProgramClosedPluginEvent)event).getProgram()) || this.program == null)) {
            this.program = null;
            this.currentAddr = null;
            this.activeArrows.clear();
            this.flowArrows.clear();
            this.validateState();
            repaintReqd = true;
        }
        if (repaintReqd) {
            this.updateAndRepaint();
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(OptionsGui.BACKGROUND.getColorOptionName())) {
            Color c = (Color)newValue;
            this.flowArrowPanel.setBackground(c);
        } else if (optionName.equals(OptionsGui.FLOW_ARROW_NON_ACTIVE.getColorOptionName())) {
            Color c = (Color)newValue;
            this.flowArrowPanel.setForeground(c);
        } else if (optionName.equals(OptionsGui.FLOW_ARROW_ACTIVE.getColorOptionName())) {
            Color c = (Color)newValue;
            this.flowArrowPanel.setHighlightColor(c);
        }
    }

    protected void dispose() {
        this.startAddressToPixel.clear();
        this.endAddressToPixel.clear();
        this.layoutToPixel = null;
        this.flowArrows.clear();
        this.flowArrowPanel.dispose();
        this.codeViewerService.removeMarginProvider(this);
    }

    protected void init() {
        this.codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        this.codeViewerService.addMarginProvider(this);
    }

    Address getCurrentAddress() {
        return this.currentAddr;
    }

    Address getScreenBottomAddr() {
        return this.screenBottom;
    }

    int getMaxDepth() {
        return this.maxDepth;
    }

    boolean isOnScreen(Address address) {
        if (this.screenBottom == null || this.screenTop == null) {
            return true;
        }
        if (address.compareTo((Object)this.screenTop) < 0) {
            return false;
        }
        return address.compareTo((Object)this.screenBottom) <= 0;
    }

    boolean isOffscreen(FlowArrow arrow) {
        if (this.screenBottom == null || this.screenTop == null) {
            return true;
        }
        if (arrow.start.compareTo((Object)this.screenTop) < 0 && arrow.end.compareTo((Object)this.screenTop) < 0) {
            return true;
        }
        return arrow.start.compareTo((Object)this.screenBottom) > 0 && arrow.end.compareTo((Object)this.screenBottom) > 0;
    }

    boolean isBelowScreen(Address address) {
        if (this.screenBottom == null || this.screenTop == null) {
            return true;
        }
        return address.compareTo((Object)this.screenBottom) > 0;
    }

    Integer getStartPos(Address addr) {
        return this.startAddressToPixel.get(addr);
    }

    Integer getEndPos(Address addr) {
        return this.endAddressToPixel.get(addr);
    }

    void setArrowSelected(FlowArrow arrow, boolean selected) {
        if (selected) {
            this.selectedArrows.add(arrow);
        } else {
            this.selectedArrows.remove(arrow);
        }
    }

    Iterator<FlowArrow> getSelectedFlowArrows() {
        return this.selectedArrows.iterator();
    }

    Iterator<FlowArrow> getFlowArrowIterator() {
        return this.flowArrows.iterator();
    }

    Iterator<FlowArrow> getActiveArrows() {
        return this.activeArrows.iterator();
    }

    private void resetSelectedArrows() {
        for (FlowArrow arrow : this.selectedArrows) {
            arrow.resetShape();
        }
    }

    private void resetActiveArrows() {
        for (FlowArrow arrow : this.activeArrows) {
            arrow.resetShape();
        }
    }

    private void saveActiveArrows() {
        if (!this.activeArrows.isEmpty()) {
            this.resetActiveArrows();
            return;
        }
        if (this.currentAddr == null) {
            return;
        }
        for (FlowArrow arrow : this.flowArrows) {
            if (!this.currentAddr.equals((Object)arrow.start)) continue;
            arrow.active = true;
            this.activeArrows.add(arrow);
        }
        if (this.activeArrows.isEmpty()) {
            return;
        }
    }

    private List<FlowArrow> getArrowsAtSameDepth(FlowArrow jump, List<FlowArrow> allArrows) {
        ArrayList<FlowArrow> results = new ArrayList<FlowArrow>();
        for (FlowArrow otherArrows : allArrows) {
            if (jump == otherArrows || !this.sharesEndpoint(jump, otherArrows)) continue;
            results.add(otherArrows);
        }
        return results;
    }

    private boolean sharesEndpoint(FlowArrow a1, FlowArrow a2) {
        return a1.start.equals((Object)a2.start) || a1.end.equals((Object)a2.end);
    }

    private void computeAllArrowsDepth() {
        for (FlowArrow arrow : this.flowArrows) {
            List<Object> sameDepth = null;
            if (arrow.depth == -1) {
                sameDepth = this.getArrowsAtSameDepth(arrow, this.flowArrows);
                AddressSet sameDepthAddrs = new AddressSet((AddressSetView)arrow.addressSet);
                for (FlowArrow flowArrow : sameDepth) {
                    sameDepthAddrs.add((AddressSetView)flowArrow.addressSet);
                }
                ArrayList<FlowArrow> arrayList = new ArrayList<FlowArrow>(this.flowArrows);
                arrayList.removeAll(sameDepth);
                arrayList.remove(arrow);
                this.assignArrowDepth(arrow, sameDepthAddrs, arrayList);
            } else {
                sameDepth = Collections.emptyList();
            }
            if (arrow.depth > this.maxDepth) {
                this.maxDepth = arrow.depth;
            }
            for (FlowArrow flowArrow : sameDepth) {
                flowArrow.depth = arrow.depth;
            }
        }
    }

    private void assignArrowDepth(FlowArrow arrow, AddressSet overlappingAddresses, List<FlowArrow> allArrows) {
        boolean[] usedDepths = new boolean[16];
        for (FlowArrow otherArrow : allArrows) {
            if (otherArrow.depth == -1 || otherArrow.depth >= 16 || this.sharesEndpoint(arrow, otherArrow) || !overlappingAddresses.intersects((AddressSetView)otherArrow.addressSet)) continue;
            usedDepths[otherArrow.depth] = true;
        }
        arrow.depth = 0;
        while (arrow.depth < usedDepths.length && usedDepths[arrow.depth]) {
            ++arrow.depth;
        }
    }

    private List<FlowArrow> getFlowArrowsForScreenInstructions(AddressSetView screenAddresses) {
        ArrayList<FlowArrow> results = new ArrayList<FlowArrow>();
        ArrowCache arrowCache = new ArrowCache();
        CodeUnitIterator it = this.program.getListing().getCodeUnitIterator("INSTRUCTION__GHIDRA_", screenAddresses, true);
        while (it.hasNext()) {
            Reference[] refs;
            CodeUnit cu = it.next();
            Instruction instruction = (Instruction)cu;
            int refCount = this.program.getReferenceManager().getReferenceCountTo(cu.getMinAddress());
            if (refCount < 10) {
                ReferenceIterator instructionIt = instruction.getReferenceIteratorTo();
                while (instructionIt.hasNext()) {
                    Reference ref = instructionIt.next();
                    this.createFlowArrow(results, arrowCache, ref);
                }
            }
            arrowCache.clear();
            for (Reference ref : refs = instruction.getReferencesFrom()) {
                this.createFlowArrow(results, arrowCache, ref);
            }
        }
        return results;
    }

    private void createFlowArrow(List<FlowArrow> results, ArrowCache arrowCache, Reference ref) {
        RefType type = ref.getReferenceType();
        if (!type.isJump() && !type.isFallthrough()) {
            return;
        }
        FlowArrow arrow = this.getFlowArrow(ref);
        if (arrow == null) {
            return;
        }
        if (!arrowCache.isDuplicateOffscreen(arrow.start, arrow.end, type)) {
            results.add(arrow);
            this.updateArrowSets(arrow);
        }
    }

    private void updateArrowSets(FlowArrow arrow) {
        if (this.selectedArrows.remove(arrow)) {
            arrow.selected = true;
            this.selectedArrows.add(arrow);
        }
        if (this.activeArrows.remove(arrow)) {
            arrow.active = true;
            this.activeArrows.add(arrow);
        }
    }

    private FlowArrow getFlowArrow(Reference ref) {
        Address start = this.toLayoutAddress(ref.getFromAddress());
        Address end = this.toLayoutAddress(ref.getToAddress());
        if (start == null || end == null) {
            return null;
        }
        if (!start.hasSameAddressSpace(end)) {
            return null;
        }
        Memory memory = this.program.getMemory();
        if (!memory.contains(end)) {
            return null;
        }
        RefType refType = ref.getReferenceType();
        if (refType.isFallthrough()) {
            return new FallthroughFlowArrow(this, this.flowArrowPanel, start, end, refType);
        }
        if (refType.isConditional()) {
            return new ConditionalFlowArrow(this, this.flowArrowPanel, start, end, refType);
        }
        return new DefaultFlowArrow(this, this.flowArrowPanel, start, end, refType);
    }

    private void validateState() {
        this.validState = false;
        if (this.program == null || this.layoutToPixel == null) {
            return;
        }
        int n = this.layoutToPixel.getNumLayouts();
        if (n == 0) {
            return;
        }
        Address bottomAddr = this.layoutToPixel.getLayoutAddress(n - 1);
        if (bottomAddr != null) {
            AddressSpace testSpace = bottomAddr.getAddressSpace();
            this.validState = this.program.getAddressFactory().getAddressSpace(testSpace.getSpaceID()) == testSpace;
        }
    }

    void updateAndRepaint() {
        this.update();
        this.flowArrowPanel.repaint();
    }

    private void update() {
        if (!this.enabled || !this.validState) {
            return;
        }
        int n = this.layoutToPixel.getNumLayouts();
        if (n == 0) {
            return;
        }
        Address startAddress = this.layoutToPixel.getLayoutAddress(0);
        Address endAddress = this.layoutToPixel.getLayoutAddress(n - 1);
        this.screenTop = startAddress;
        this.screenBottom = endAddress;
        this.flowArrows.clear();
        this.startAddressToPixel.clear();
        this.endAddressToPixel.clear();
        this.maxDepth = 0;
        this.resetSelectedArrows();
        if (this.screenTop == null || this.screenBottom == null || n > 500) {
            return;
        }
        for (int layout = 0; layout < n; ++layout) {
            Address addr = this.layoutToPixel.getLayoutAddress(layout);
            if (addr == null) continue;
            this.startAddressToPixel.put(addr, this.layoutToPixel.getBeginPosition(layout));
            this.endAddressToPixel.put(addr, this.layoutToPixel.getEndPosition(layout));
        }
        AddressSetView flowSet = this.layoutToPixel.getAddressSet();
        this.flowArrows = this.getFlowArrowsForScreenInstructions(flowSet);
        Collections.sort(this.flowArrows, (a1, a2) -> a1.end.compareTo((Object)a2.end));
        this.computeAllArrowsDepth();
        this.saveActiveArrows();
    }

    private Address toLayoutAddress(Address addr) {
        Integer pixel = this.startAddressToPixel.get(addr);
        if (pixel != null || addr.compareTo((Object)this.screenTop) < 0 || addr.compareTo((Object)this.screenBottom) > 0) {
            return addr;
        }
        int n = this.layoutToPixel.getNumLayouts();
        for (int i = 0; i < n; ++i) {
            Address layoutAddr = this.layoutToPixel.getLayoutAddress(i);
            Address endLayoutAddr = this.layoutToPixel.getLayoutEndAddress(i);
            if (layoutAddr == null || endLayoutAddr == null) continue;
            if (layoutAddr.compareTo((Object)addr) >= 0) {
                return null;
            }
            if (addr.compareTo((Object)endLayoutAddr) > 0) continue;
            return layoutAddr;
        }
        return addr;
    }

    private void updateFlowArrows() {
        if (this.enabled) {
            this.updateAndRepaint();
        }
    }

    private void getOptions() {
        ToolOptions opt = this.tool.getOptions("Listing Display");
        opt.registerThemeColorBinding(OptionsGui.FLOW_ARROW_NON_ACTIVE.getColorOptionName(), OptionsGui.FLOW_ARROW_NON_ACTIVE.getThemeColorId(), null, "The color for an arrow with no endpoint at the current address");
        opt.registerThemeColorBinding(OptionsGui.FLOW_ARROW_ACTIVE.getColorOptionName(), OptionsGui.FLOW_ARROW_ACTIVE.getThemeColorId(), null, "The color for an arrow with an endpoint at the current address");
        opt.registerThemeColorBinding(OptionsGui.FLOW_ARROW_SELECTED.getColorOptionName(), OptionsGui.FLOW_ARROW_SELECTED.getThemeColorId(), null, "The color for an arrow that has been selected by the user");
        this.flowArrowPanel.setBackground((Color)ListingColors.BACKGROUND);
        this.flowArrowPanel.setForeground((Color)ListingColors.FlowArrowColors.INACTIVE);
        this.flowArrowPanel.setHighlightColor((Color)ListingColors.FlowArrowColors.ACTIVE);
        this.flowArrowPanel.setSelectedColor((Color)ListingColors.FlowArrowColors.SELECTED);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    void goTo(Address address) {
        CodeViewerService codeViewer = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        ListingPanel listingPanel = codeViewer.getListingPanel();
        ProgramLocation location = new ProgramLocation(this.program, address);
        listingPanel.goTo(location, false);
    }

    void scrollTo(Address address) {
        CodeViewerService codeViewer = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        ListingPanel listingPanel = codeViewer.getListingPanel();
        ProgramLocation location = new ProgramLocation(this.program, address);
        listingPanel.scrollTo(location);
    }

    void scrollToCenter(Address address) {
        CodeViewerService codeViewer = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        ListingPanel listingPanel = codeViewer.getListingPanel();
        ProgramLocation location = new ProgramLocation(this.program, address);
        listingPanel.center(location);
    }

    Address getAddressAtPoint(Point p) {
        CodeViewerService codeViewer = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        ListingPanel listingPanel = codeViewer.getListingPanel();
        ProgramLocation location = listingPanel.getProgramLocation(p);
        if (location == null) {
            return null;
        }
        return location.getAddress();
    }

    Address getLastAddressOnScreen(Address end, boolean up) {
        if (up) {
            return this.screenTop;
        }
        return this.screenBottom;
    }

    public void forwardMouseEventToListing(MouseWheelEvent e) {
        CodeViewerService codeViewer = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        ListingPanel listingPanel = codeViewer.getListingPanel();
        FieldPanel fieldPanel = listingPanel.getFieldPanel();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent((Component)fieldPanel, e);
    }

    private class ArrowCache {
        Address address;
        boolean conditionalOffTop;
        boolean conditionalOffBottom;
        boolean fallthroughOffTop;
        boolean fallthroughOffBottom;
        boolean otherOffTop;
        boolean otherOffBottom;

        private ArrowCache() {
        }

        void clear() {
            this.address = null;
            this.conditionalOffTop = false;
            this.conditionalOffBottom = false;
            this.fallthroughOffTop = false;
            this.fallthroughOffBottom = false;
            this.otherOffTop = false;
            this.otherOffBottom = false;
        }

        boolean isDuplicateOffscreen(Address pointOfInterest, Address otherEnd, RefType refType) {
            if (!pointOfInterest.equals((Object)this.address)) {
                this.clear();
                this.address = pointOfInterest;
            }
            if (otherEnd.compareTo((Object)FlowArrowPlugin.this.screenTop) < 0) {
                if (refType.isConditional()) {
                    if (this.conditionalOffTop) {
                        return true;
                    }
                    this.conditionalOffTop = true;
                } else if (refType.isFallthrough()) {
                    if (this.fallthroughOffTop) {
                        return true;
                    }
                    this.fallthroughOffTop = true;
                } else {
                    if (this.otherOffTop) {
                        return true;
                    }
                    this.otherOffTop = true;
                }
            } else if (otherEnd.compareTo((Object)FlowArrowPlugin.this.screenBottom) > 0) {
                if (refType.isConditional()) {
                    if (this.conditionalOffBottom) {
                        return true;
                    }
                    this.conditionalOffBottom = true;
                } else if (refType.isFallthrough()) {
                    if (this.fallthroughOffBottom) {
                        return true;
                    }
                    this.fallthroughOffBottom = true;
                } else {
                    if (this.otherOffBottom) {
                        return true;
                    }
                    this.otherOffBottom = true;
                }
            }
            return false;
        }
    }
}

