/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public class LabelMsType
extends AbstractMsType {
    public static final int PDB_ID = 14;
    private static final int ADDRESS_MODE_NEAR = 0;
    private static final int ADDRESS_MODE_FAR = 4;
    private int mode;

    public LabelMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.mode = reader.parseUnsignedShortVal();
    }

    @Override
    public int getPdbId() {
        return 14;
    }

    public boolean isNear() {
        return this.mode == 0;
    }

    public boolean isFar() {
        return this.mode == 4;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("<<" + this.getClass().getSimpleName() + (this.isNear() ? " near" : "") + (this.isFar() ? " far" : "") + ">>");
    }
}

