/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractRegisterMsSymbol;

public class Register16MsSymbol
extends AbstractRegisterMsSymbol {
    public static final int PDB_ID = 2;
    private RegisterName register2;

    public Register16MsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader, 16, StringParseType.StringUtf8St);
    }

    @Override
    public int getPdbId() {
        return 2;
    }

    @Override
    protected RegisterName parseRegister(PdbByteReader reader) throws PdbException {
        int registerVal = reader.parseUnsignedShortVal();
        RegisterName reg = new RegisterName(this.pdb, registerVal >> 8);
        this.register2 = new RegisterName(this.pdb, registerVal & 0xFF);
        return reg;
    }

    @Override
    protected void emitRegisterInformation(StringBuilder builder) {
        if (!this.register.isRegNone()) {
            this.register.emit(builder);
            builder.append(":");
        }
        this.register2.emit(builder);
    }

    @Override
    protected String getSymbolTypeName() {
        return "REGISTER_16";
    }
}

