/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;

public class FunctionReturnTypeFieldLocation
extends FunctionSignatureFieldLocation {
    private String returnTypeStr;

    public FunctionReturnTypeFieldLocation(Program program, Address locationAddr, Address functionAddr, int charOffset, String signature, String returnType) {
        super(program, locationAddr, functionAddr, charOffset, signature);
        this.returnTypeStr = returnType;
    }

    public FunctionReturnTypeFieldLocation(Program program, Address functionAddr, int col, String signature, String returnType) {
        this(program, functionAddr, functionAddr, col, signature, returnType);
    }

    public FunctionReturnTypeFieldLocation(Program program, Address functionAddr, String returnType) {
        super(program, functionAddr);
        this.returnTypeStr = returnType;
    }

    public FunctionReturnTypeFieldLocation() {
    }

    public String getReturnType() {
        return this.returnTypeStr;
    }

    @Override
    public String toString() {
        return super.toString() + ", Function Return Type: " + this.returnTypeStr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.returnTypeStr == null ? 0 : this.returnTypeStr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionReturnTypeFieldLocation other = (FunctionReturnTypeFieldLocation)obj;
        return !(this.returnTypeStr == null ? other.returnTypeStr != null : !this.returnTypeStr.equals(other.returnTypeStr));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_RETURN_TYPE", this.returnTypeStr);
    }

    @Override
    public void restoreState(Program restoreProgram, SaveState obj) {
        super.restoreState(restoreProgram, obj);
        this.returnTypeStr = obj.getString("_RETURN_TYPE", null);
    }
}

