/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.PatchPackedEncode;
import java.io.IOException;

public class PackedEncodeOverlay
extends PatchPackedEncode {
    private OverlayAddressSpace overlay = null;
    private int overlayId;
    private int underlyingId;

    public PackedEncodeOverlay(OverlayAddressSpace spc) throws AddressFormatException {
        this.setOverlay(spc);
    }

    public void setOverlay(OverlayAddressSpace spc) throws AddressFormatException {
        this.overlayId = spc.getUnique();
        AddressSpace underlie = spc.getOverlayedSpace();
        this.underlyingId = underlie.getUnique();
        if (this.underlyingId == 0) {
            throw new AddressFormatException("Cannot set overlay over " + underlie.getName());
        }
        this.overlay = spc;
    }

    @Override
    public void writeSpace(AttributeId attribId, AddressSpace spc) throws IOException {
        if (spc == this.overlay) {
            spc = this.overlay.getOverlayedSpace();
        }
        super.writeSpace(attribId, spc);
    }

    @Override
    public void writeSpaceId(AttributeId attribId, long spaceId) throws IOException {
        if (spaceId == (long)this.overlayId) {
            spaceId = this.underlyingId;
        }
        super.writeSpaceId(attribId, spaceId);
    }
}

