/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.EncodedAnnotation;
import ghidra.file.formats.android.dex.format.EncodedArray;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedValue
implements StructConverter {
    private byte value;
    private byte valueType;
    private byte valueArgs;
    private byte[] valueBytes;
    private EncodedArray array;
    private EncodedAnnotation annotation;

    public EncodedValue(BinaryReader reader) throws IOException {
        this.value = reader.readNextByte();
        this.valueType = (byte)(this.value & 0x1F);
        this.valueArgs = (byte)((this.value & 0xE0) >> 5);
        switch (this.valueType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                this.valueBytes = reader.readNextByteArray(this.valueArgs + 1);
                break;
            }
            case 28: {
                this.array = new EncodedArray(reader);
                break;
            }
            case 29: {
                this.annotation = new EncodedAnnotation(reader);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
        }
    }

    public byte getValueArgs() {
        return this.valueArgs;
    }

    public byte getValueType() {
        return this.valueType;
    }

    public byte[] getValueBytes() {
        return this.valueBytes;
    }

    public byte getValueByte() {
        return this.valueBytes[0];
    }

    public EncodedArray getArray() {
        return this.array;
    }

    public EncodedAnnotation getAnnotation() {
        return this.annotation;
    }

    public boolean isValueBoolean() {
        return this.valueArgs == 1;
    }

    byte getValue() {
        return this.value;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuilder builder = new StringBuilder("encoded_value_0x" + Integer.toHexString(this.value & 0xFF));
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add(BYTE, "valueType", null);
        switch (this.valueType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                int length = (this.valueArgs & 0xFF) + 1;
                structure.add((DataType)new ArrayDataType(BYTE, length, BYTE.getLength()), "value", null);
                builder.append("_" + length);
                break;
            }
            case 28: {
                builder.append("_" + this.array.getValues().length);
                structure.add(this.array.toDataType(), "value", null);
                break;
            }
            case 29: {
                DataType dataType = this.annotation.toDataType();
                structure.add(dataType, "value", null);
                builder.append("_" + dataType.getName());
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
        }
        try {
            structure.setName(builder.toString());
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.setCategoryPath(new CategoryPath("/dex/encoded_value"));
        return structure;
    }
}

