/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.remote;

import ghidra.util.Msg;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetNameLookup {
    private static final long MAX_TIME_MS = 10000L;
    private static volatile boolean lookupEnabled = true;
    private static volatile boolean disableOnFailure = false;

    private InetNameLookup() {
    }

    public static void setDisableOnFailure(boolean state) {
        disableOnFailure = state;
    }

    public static void setLookupEnabled(boolean enable) {
        lookupEnabled = enable;
    }

    public static boolean isEnabled() {
        return lookupEnabled;
    }

    public static String getCanonicalHostName(String host) throws UnknownHostException {
        String bestGuess = host;
        if (lookupEnabled) {
            boolean found = false;
            long fastest = Long.MAX_VALUE;
            for (InetAddress addr : InetAddress.getAllByName(host)) {
                long startTime = System.currentTimeMillis();
                String name = addr.getCanonicalHostName();
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (!name.equals(addr.getHostAddress())) {
                    if (host.equalsIgnoreCase(name)) {
                        return name;
                    }
                    bestGuess = name;
                    found = true;
                    continue;
                }
                fastest = Math.min(fastest, elapsedTime);
            }
            if (!found) {
                Msg.warn(InetNameLookup.class, (Object)("Failed to resolve IP Address: " + host + " (Reverse DNS may not be properly configured or you may have a network problem)"));
                if (disableOnFailure && fastest > 10000L) {
                    Msg.warn(InetNameLookup.class, (Object)"Reverse network name lookup has been disabled automatically due to lookup failure.");
                    lookupEnabled = false;
                }
            }
        }
        return bestGuess;
    }
}

