/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.ComponentConstraints;
import com.jeta.forms.gui.form.GridCellEvent;
import com.jeta.forms.gui.form.GridCellListener;
import com.jeta.forms.gui.form.GridComponentConstraints;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.handler.CellKeyboardHandler;
import com.jeta.forms.gui.handler.CellMouseHandler;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.StateRequest;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;

public abstract class GridComponent
extends JPanel {
    private JETABean m_jetabean;
    private boolean m_selected;
    private CellMouseHandler m_mousehandler;
    private CellKeyboardHandler m_keyboardhandler;
    private GridView m_gridview;
    private ComponentConstraints m_cc;
    private LinkedList m_listeners = new LinkedList();
    private boolean m_design_mode;
    private static final int MIN_WIDTH = 16;
    private static final int MIN_HEIGHT = 16;
    private Dimension m_min_size = new Dimension(16, 16);
    static final int EMPTY_CELL_WIDTH = 10;
    static final int EMPTY_CELL_HEIGHT = 10;

    public GridComponent() {
        this.m_design_mode = FormUtils.isDesignMode();
        this.setOpaque(false);
    }

    public GridComponent(GridView gridView) {
        this.m_design_mode = FormUtils.isDesignMode();
        this.setOpaque(false);
    }

    public GridComponent(JETABean jETABean, GridView gridView) {
        this.m_jetabean = jETABean;
        this.m_gridview = gridView;
        this.m_design_mode = FormUtils.isDesignMode();
        this.setOpaque(false);
    }

    public void addListener(GridCellListener gridCellListener) {
        if (!this.m_listeners.contains(gridCellListener)) {
            this.m_listeners.add(gridCellListener);
        }
    }

    public void fireGridCellEvent(GridCellEvent gridCellEvent) {
        Iterator iterator = this.m_listeners.iterator();
        while (iterator.hasNext()) {
            GridCellListener gridCellListener = (GridCellListener)iterator.next();
            gridCellListener.cellChanged(gridCellEvent);
        }
    }

    public JETABean getBean() {
        return this.m_jetabean;
    }

    Component getBeanChildComponent() {
        if (this.m_jetabean != null) {
            return this.m_jetabean.getBeanChildComponent();
        }
        return null;
    }

    public Component getBeanDelegate() {
        if (this.m_jetabean != null) {
            return this.m_jetabean.getDelegate();
        }
        return null;
    }

    public ComponentConstraints getConstraints() {
        if (this.m_cc == null) {
            this.m_cc = new GridComponentConstraints(this);
        }
        return this.m_cc;
    }

    public Dimension getMinimumSize() {
        if (this.m_design_mode) {
            return this.m_min_size;
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.m_design_mode) {
            Dimension dimension = super.getPreferredSize();
            if (dimension == null || dimension.width < 16 || dimension.height < 16) {
                if (dimension == null) {
                    dimension = this.m_min_size;
                }
                this.m_min_size.width = Math.max(dimension.width, 16);
                this.m_min_size.height = Math.max(dimension.height, 16);
                return this.m_min_size;
            }
            return dimension;
        }
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    public String getBeanName() {
        if (this.m_jetabean == null) {
            return null;
        }
        return this.m_jetabean.getName();
    }

    public GridView getParentView() {
        Container container = this.getParent();
        if (container instanceof GridView) {
            return (GridView)container;
        }
        if (container != null) {
            if ((container = container.getParent()) instanceof GridView) {
                return (GridView)container;
            }
            if (container != null && (container = container.getParent()) instanceof GridView) {
                return (GridView)container;
            }
        }
        return null;
    }

    public int getRow() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getRow();
    }

    public int getRowSpan() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getRowSpan();
    }

    public int getColumnSpan() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getColumnSpan();
    }

    public int getColumn() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getColumn();
    }

    public CellMouseHandler getMouseHandler() {
        return this.m_mousehandler;
    }

    public int getCellWidth() {
        int n = this.getColumnSpan();
        int n2 = this.getColumn();
        int n3 = this.getParentView().getColumnWidth(n2);
        for (int i = 1; i < n; ++i) {
            n3 += this.getParentView().getColumnWidth(n2 + i);
        }
        return n3;
    }

    public int getCellHeight() {
        int n = this.getRowSpan();
        int n2 = this.getRow();
        int n3 = this.getParentView().getRowHeight(n2);
        for (int i = 1; i < n; ++i) {
            n3 += this.getParentView().getRowHeight(n2 + i);
        }
        return n3;
    }

    public int getCellX() {
        return this.getParentView().getColumnOrgX(this.getColumn());
    }

    public int getCellY() {
        return this.getParentView().getRowOrgY(this.getRow());
    }

    public String getId() {
        return this.getBeanName();
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void removeListener(GridCellListener gridCellListener) {
        this.m_listeners.remove(gridCellListener);
    }

    public void setMouseHandler(CellMouseHandler cellMouseHandler) {
        this.m_mousehandler = cellMouseHandler;
    }

    public void setName(String string) {
        FormUtils.safeAssert(false);
    }

    protected void setBean(JETABean jETABean) {
        this.m_jetabean = jETABean;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.m_selected;
        this.m_selected = bl;
        if (bl != bl2 && this.getParentView() != null) {
            this.getParentView().getOverlay().repaint(this);
        }
        if (bl) {
            this.fireGridCellEvent(new GridCellEvent(3, this));
        }
    }

    public CellKeyboardHandler getKeyboardHandler() {
        return this.m_keyboardhandler;
    }

    public void setKeyboardHandler(CellKeyboardHandler cellKeyboardHandler) {
        this.m_keyboardhandler = cellKeyboardHandler;
    }

    public void setParentView(GridView gridView) {
        FormUtils.safeAssert(this.getParentView() == null);
        this.m_gridview = gridView;
    }

    public void postInitialize(FormPanel formPanel) {
    }

    public abstract ComponentMemento getState(StateRequest var1) throws FormException;

    public abstract void setState(ComponentMemento var1) throws FormException;

    public boolean hasBean() {
        if (this.m_jetabean != null) {
            return this.m_jetabean.getDelegate() != null;
        }
        return false;
    }

    public boolean isShowing() {
        if (this.m_jetabean == null) {
            return true;
        }
        Component component = this.m_jetabean.getDelegate();
        if (component == null) {
            return true;
        }
        Dimension dimension = component.getSize();
        return dimension != null && dimension.width != 0 && dimension.height != 0;
    }

    public abstract void print();
}

