/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.BytesIOBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BytesIOBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.BytesIOBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.io.PBytesIO;
import com.oracle.graal.python.builtins.modules.io.PBytesIOBuffer;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBytesIO})
public final class BytesIOBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BytesIOBuiltinsSlotsGen.SLOTS;
    protected static final byte[] EMPTY_BYTE_ARRAY = PythonUtils.EMPTY_BYTE_ARRAY;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BytesIOBuiltinsFactory.getFactories();
    }

    static PBytes readBytes(PBytesIO self, int size, PythonBufferAccessLibrary bufferLib, PythonLanguage language) {
        if (size == 0) {
            return PFactory.createEmptyBytes(language);
        }
        assert (size <= self.getStringSize());
        PByteArray buffer = self.getBuf();
        if (self.getPos() == 0 && bufferLib.hasInternalByteArray(buffer) && self.getExports() == 0 && size > bufferLib.getBufferLength(buffer) / 2) {
            self.incPos(size);
            self.markEscaped();
            return PFactory.createBytes(language, bufferLib.getInternalByteArray(buffer), size);
        }
        PBytes output = PFactory.createBytes(language, bufferLib.getCopyOfRange(buffer, self.getPos(), self.getPos() + size));
        self.incPos(size);
        return output;
    }

    static int scanEOL(PBytesIO self, int l, PythonBufferAccessLibrary bufferLib) {
        PByteArray buffer = self.getBuf();
        byte[] buf = bufferLib.getInternalOrCopiedByteArray(buffer);
        return BytesIOBuiltins.scanEOL(self, l, buf);
    }

    private static int scanEOL(PBytesIO self, int l, byte[] buf) {
        assert (self.getPos() >= 0);
        if (self.getPos() >= self.getStringSize()) {
            return 0;
        }
        int maxlen = self.getStringSize() - self.getPos();
        int len = l;
        if (len < 0 || len > maxlen) {
            len = maxlen;
        }
        if (len > 0) {
            int n = -1;
            for (int i = self.getPos(); i < self.getPos() + len; ++i) {
                if (buf[i] != 10) continue;
                n = i;
                break;
            }
            if (n != -1) {
                len = n - self.getPos() + 1;
            }
        }
        assert (len >= 0);
        assert (self.getPos() < Integer.MAX_VALUE - len);
        return len;
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class IternextNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        IternextNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object doit(PBytesIO self, @Bind PythonLanguage language, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int n = BytesIOBuiltins.scanEOL(self, -1, bufferLib);
            if (n == 0) {
                throw TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
            }
            return BytesIOBuiltins.readBytes(self, n, bufferLib, language);
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        static Object close(PBytesIO self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            self.checkExports(inliningTarget, raiseNode);
            self.setBuf(null);
            return PNone.NONE;
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization
        static boolean closed(PBytesIO self) {
            return !self.hasBuf();
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        WritableNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean writable(PBytesIO self) {
            return true;
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean readable(PBytesIO self) {
            return true;
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        SeekableNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean seekable(PBytesIO self) {
            return true;
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object doit(PBytesIO self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization
        static Object doit(VirtualFrame frame, PBytesIO self, PTuple state, @Bind Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached WriteNode writeNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached GetOrCreateDictNode getDict, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached PRaiseNode raiseNode) {
            self.checkExports(inliningTarget, raiseNode);
            SequenceStorage storage = state.getSequenceStorage();
            Object[] array = getArray.execute(inliningTarget, storage);
            if (storage.length() < 3) {
                return SetStateNode.notTuple(self, state, raiseNode);
            }
            self.setStringSize(0);
            self.setPos(0);
            writeNode.execute(frame, self, array[0]);
            if (!indexCheckNode.execute(inliningTarget, array[1])) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SECOND_ITEM_OF_STATE_MUST_BE_AN_INTEGER_NOT_P, array[1]);
            }
            int pos = asSizeNode.executeExact((Frame)frame, inliningTarget, array[1]);
            if (pos < 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.POSITION_VALUE_CANNOT_BE_NEGATIVE);
            }
            self.setPos(pos);
            if (!PGuards.isNone(array[2])) {
                if (!PGuards.isDict(array[2])) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THIRD_ITEM_OF_STATE_SHOULD_BE_A_DICT_GOT_A_P, array[2]);
                }
                PDict dict = getDict.execute(inliningTarget, self);
                addAllToOtherNode.execute((Frame)frame, inliningTarget, ((PDict)array[2]).getDictStorage(), dict);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isPTuple(state)"})
        static Object notTuple(PBytesIO self, Object state, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.P_SETSTATE_ARGUMENT_SHOULD_BE_D_TUPLE_GOT_P, self, 3, state);
        }
    }

    @Builtin(name="__getstate__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetStateNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetStateNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object doit(VirtualFrame frame, PBytesIO self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached GetValueNode getValueNode, @Cached GetOrCreateDictNode getDict) {
            Object initValue = getValueNode.execute(frame, self);
            Object[] state = new Object[]{initValue, self.getPos(), getDict.execute(inliningTarget, self)};
            return PFactory.createTuple(language, state);
        }
    }

    @Builtin(name="getvalue", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetValueNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetValueNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object doCopy(PBytesIO self, @Bind PythonLanguage language, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            if (bufferLib.hasInternalByteArray(self.getBuf()) && self.getExports() == 0) {
                self.markEscaped();
            }
            return PFactory.createBytes(language, bufferLib.getInternalOrCopiedByteArray(self.getBuf()), self.getStringSize());
        }
    }

    @Builtin(name="getbuffer", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetBufferNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetBufferNode() {
        }

        @Specialization
        static Object doit(VirtualFrame frame, PBytesIO self, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyMemoryViewFromObject memoryViewNode, @Cached SequenceStorageNodes.SetLenNode setLenNode) {
            self.unshareIfNecessary(bufferLib, language);
            setLenNode.execute(inliningTarget, self.getBuf().getSequenceStorage(), self.getStringSize());
            PBytesIOBuffer buf = PFactory.createBytesIOBuf(language, self);
            return memoryViewNode.execute(frame, buf);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, parameterNames={"$self", "pos", "whence"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pos", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedIOUtil.SEEK_SET", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isSupportedWhence(int whence) {
            return whence == 0 || whence == 1 || whence == 2;
        }

        protected static boolean isLargePos(int pos, int to) {
            return pos > Integer.MAX_VALUE - to;
        }

        protected static boolean validPos(PBytesIO self, int pos, int whence) {
            return !(pos < 0 && whence == 0 || SeekNode.isLargePos(pos, self.getStringSize()) && whence == 2 || SeekNode.isLargePos(pos, self.getPos()) && whence == 1);
        }

        @Specialization(guards={"self.hasBuf()", "isSupportedWhence(whence)", "validPos(self, pos, whence)"})
        static Object seek(PBytesIO self, int pos, int whence) {
            int p = pos;
            if (whence == 1) {
                p += self.getPos();
            } else if (whence == 2) {
                p += self.getStringSize();
            }
            if (p < 0) {
                p = 0;
            }
            self.setPos(p);
            return p;
        }

        @Specialization(guards={"self.hasBuf()", "!isSupportedWhence(whence)"})
        static Object whenceError(PBytesIO self, int pos, int whence, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INVALID_WHENCE_D_SHOULD_BE_0_1_OR_2, whence);
        }

        @Specialization(guards={"self.hasBuf()", "isLargePos(pos, self.getPos())", "whence == 1"})
        static Object largePos1(PBytesIO self, int pos, int whence, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.NEW_POSITION_TOO_LARGE);
        }

        @Specialization(guards={"self.hasBuf()", "isLargePos(pos, self.getStringSize())", "whence == 2"})
        static Object largePos2(PBytesIO self, int pos, int whence, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.NEW_POSITION_TOO_LARGE);
        }

        @Specialization(guards={"self.hasBuf()", "pos < 0", "whence == 0"})
        static Object negPos(PBytesIO self, int pos, int whence, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SEEK_VALUE_D, pos);
        }

        @Specialization(guards={"!self.hasBuf()"})
        static Object closedError(PBytesIO self, int pos, int whence, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        TellNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object tell(PBytesIO self) {
            return self.getPos();
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAttyNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        IsAttyNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static boolean atty(PBytesIO self) {
            return false;
        }
    }

    @Builtin(name="writelines", minNumOfPositionalArgs=2, parameterNames={"$self", "lines"})
    @GenerateNodeFactory
    static abstract class WriteLinesNode
    extends ClosedCheckPythonBinaryBuiltinNode {
        WriteLinesNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object writeLines(VirtualFrame frame, PBytesIO self, Object lines, @Bind Node inliningTarget, @Cached WriteNode writeNode, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached PRaiseNode raiseNode) {
            self.checkExports(inliningTarget, raiseNode);
            Object iter = getIter.execute((Frame)frame, inliningTarget, lines);
            while (true) {
                Object line;
                try {
                    line = nextNode.execute((Frame)frame, inliningTarget, iter);
                }
                catch (IteratorExhausted e) {
                    break;
                }
                writeNode.execute(frame, self, line);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends ClosedCheckPythonBinaryBuiltinNode {
        WriteNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.hasBuf()"}, limit="3")
        static Object doWrite(VirtualFrame frame, PBytesIO self, Object b, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="b") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode) {
            self.checkExports(inliningTarget, raiseNode);
            Object buffer = acquireLib.acquireReadonly(b, frame, indirectCallData);
            try {
                int len = bufferLib.getBufferLength(buffer);
                if (len == 0) {
                    Integer n = 0;
                    return n;
                }
                int pos = self.getPos();
                int endpos = pos + len;
                self.unshareAndResize(bufferLib, language, endpos, false);
                bufferLib.readIntoBuffer(buffer, 0, self.getBuf(), pos, len, bufferLib);
                self.setPos(endpos);
                if (endpos > self.getStringSize()) {
                    self.setStringSize(endpos);
                }
                Integer n = len;
                return n;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends ClosedCheckPythonBinaryBuiltinNode {
        TruncateNode() {
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object truncate(PBytesIO self, int size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared(value="lib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            self.checkExports(inliningTarget, raiseNode);
            if (size < 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SIZE_VALUE_D, size);
            }
            if (size < self.getStringSize()) {
                self.unshareAndResize(bufferLib, language, size, true);
                self.setStringSize(size);
            }
            return size;
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object truncate(PBytesIO self, PNone size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared(value="lib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return TruncateNode.truncate(self, self.getPos(), inliningTarget, language, bufferLib, raiseNode);
        }

        @Specialization(guards={"self.hasBuf()", "!isPNone(size)"})
        static Object truncate(VirtualFrame frame, PBytesIO self, Object size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="lib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return TruncateNode.truncate(self, asSizeNode.executeExact((Frame)frame, inliningTarget, size), inliningTarget, language, bufferLib, raiseNode);
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadIntoNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadIntoNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.hasBuf()"})
        static Object readinto(VirtualFrame frame, PBytesIO self, Object buffer, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                int n = self.getStringSize() - self.getPos();
                if (len > n && (len = n) < 0) {
                    Integer n2 = 0;
                    return n2;
                }
                bufferLib.readIntoBuffer(self.getBuf(), self.getPos(), buffer, 0, len, bufferLib);
                assert (self.getPos() + len < Integer.MAX_VALUE);
                assert (len >= 0);
                self.incPos(len);
                Integer n3 = len;
                return n3;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadIntoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="readlines", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlinesNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadlinesNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadlinesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object readlines(PBytesIO self, int maxsize, @Bind PythonLanguage language, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int n;
            ArrayBuilder<Object> result = new ArrayBuilder<Object>();
            PByteArray buffer = self.getBuf();
            byte[] buf = bufferLib.getInternalOrCopiedByteArray(buffer);
            int cur = self.getPos();
            int size = 0;
            while ((n = BytesIOBuiltins.scanEOL(self, -1, buf)) != 0) {
                self.incPos(n);
                PBytes line = PFactory.createBytes(language, PythonUtils.arrayCopyOfRange(buf, cur, cur + n));
                result.add(line);
                if (maxsize > 0 && (size += n) >= maxsize) break;
                cur += n;
            }
            return PFactory.createList(language, result.toArray(new Object[0]));
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.hasBuf()"})
        Object readline(PBytesIO self, int size, @Bind PythonLanguage language, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int n = BytesIOBuiltins.scanEOL(self, size, bufferLib);
            return BytesIOBuiltins.readBytes(self, n, bufferLib, language);
        }
    }

    @Builtin(name="read1", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class Read1Node
    extends ReadNode {
        Read1Node() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.Read1NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesIOBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.hasBuf()"})
        static Object read(PBytesIO self, int len, @Bind PythonLanguage language, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
            int size = len;
            int n = self.getStringSize() - self.getPos();
            if ((size < 0 || size > n) && (size = n) < 0) {
                size = 0;
            }
            return BytesIOBuiltins.readBytes(self, size, bufferLib, language);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="BytesIO", minNumOfPositionalArgs=1, parameterNames={"$self", "initial_bytes"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone init(PBytesIO self, PNone initvalue, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            self.checkExports(inliningTarget, raiseNode);
            self.setPos(0);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(initvalue)"})
        static PNone init(VirtualFrame frame, PBytesIO self, Object initvalue, @Bind Node inliningTarget, @Cached WriteNode writeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            self.setStringSize(0);
            self.setPos(0);
            self.checkExports(inliningTarget, raiseNode);
            writeNode.execute(frame, self, initvalue);
            self.setPos(0);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="BytesIO", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BytesIONode
    extends PythonBuiltinNode {
        @Specialization
        static PBytesIO doNew(Object cls, Object arg, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PBytesIO bytesIO = PFactory.createBytesIO(language, cls, getInstanceShape.execute(cls));
            bytesIO.setBuf(PFactory.createByteArray(language, PythonUtils.EMPTY_BYTE_ARRAY));
            return bytesIO;
        }
    }

    static abstract class ClosedCheckPythonBinaryClinicBuiltinNode
    extends PythonBinaryClinicBuiltinNode {
        ClosedCheckPythonBinaryClinicBuiltinNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"!self.hasBuf()"})
        static Object closedError(PBytesIO self, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    static abstract class ClosedCheckPythonBinaryBuiltinNode
    extends PythonBinaryBuiltinNode {
        ClosedCheckPythonBinaryBuiltinNode() {
        }

        @Specialization(guards={"!self.hasBuf()"})
        static Object closedError(PBytesIO self, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    static abstract class ClosedCheckPythonUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        ClosedCheckPythonUnaryBuiltinNode() {
        }

        @Specialization(guards={"!self.hasBuf()"})
        static Object closedError(PBytesIO self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }
}

