/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.console.PyConsoleEnterHandler;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandlerKt;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0018H\u0016J\b\u0010)\u001a\u00020\u0018H\u0002J\b\u0010*\u001a\u00020\u0018H\u0002J\b\u0010-\u001a\u00020\u0018H\u0014J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020!H\u0004J\b\u0010/\u001a\u00020\u0018H\u0002J\b\u00100\u001a\u00020\u0018H\u0002J\b\u00101\u001a\u00020\u0018H\u0002J\u0010\u00102\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001aH\u0016J\b\u00103\u001a\u00020\u0018H\u0016J\u0010\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0004H\u0016J\u0010\u00109\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0004H\u0002J\u0010\u0010:\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0004H\u0002J\b\u0010;\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010+\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001cR\u0014\u00104\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u0010<\u001a\u00020!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u00106\u00a8\u0006?"}, d2={"Lcom/jetbrains/python/console/PydevConsoleExecuteActionHandler;", "Lcom/jetbrains/python/console/PythonConsoleExecuteActionHandler;", "Lcom/jetbrains/python/console/pydev/ConsoleCommunicationListener;", "myConsoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "consoleCommunication", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "<init>", "(Lcom/intellij/execution/console/LanguageConsoleView;Lcom/intellij/execution/process/ProcessHandler;Lcom/jetbrains/python/console/pydev/ConsoleCommunication;)V", "getConsoleCommunication", "()Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "project", "Lcom/intellij/openapi/project/Project;", "myEnterHandler", "Lcom/jetbrains/python/console/PyConsoleEnterHandler;", "ipythonInputPromptCount", "", "getIpythonInputPromptCount", "()I", "setIpythonInputPromptCount", "(I)V", "decreaseInputPromptCount", "", "value", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "processLine", "line", "", "executeMultiLine", "text", "checkSingleLine", "sendLineToConsole", "code", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication$ConsoleCodeFragment;", "updateConsoleState", "inPrompt", "ordinaryPrompt", "ipythonEnabled", "getIpythonEnabled", "ipythonInPrompt", "prompt", "executingPrompt", "waitingForInputPrompt", "more", "commandExecuted", "inputRequested", "cantExecuteMessage", "getCantExecuteMessage", "()Ljava/lang/String;", "runExecuteAction", "console", "doRunExecuteAction", "copyToHistoryAndExecute", "canExecuteNow", "consoleIsNotEnabledMessage", "getConsoleIsNotEnabledMessage", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPydevConsoleExecuteActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PydevConsoleExecuteActionHandler.kt\ncom/jetbrains/python/console/PydevConsoleExecuteActionHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,275:1\n40#2,3:276\n*S KotlinDebug\n*F\n+ 1 PydevConsoleExecuteActionHandler.kt\ncom/jetbrains/python/console/PydevConsoleExecuteActionHandler\n*L\n80#1:276,3\n*E\n"})
public class PydevConsoleExecuteActionHandler
extends PythonConsoleExecuteActionHandler
implements ConsoleCommunicationListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageConsoleView myConsoleView;
    @NotNull
    private final ConsoleCommunication consoleCommunication;
    @NotNull
    private final Project project;
    @NotNull
    private final PyConsoleEnterHandler myEnterHandler;
    private int ipythonInputPromptCount;
    private boolean isEnabled;

    public PydevConsoleExecuteActionHandler(@NotNull LanguageConsoleView myConsoleView, @NotNull ProcessHandler processHandler, @NotNull ConsoleCommunication consoleCommunication) {
        Intrinsics.checkNotNullParameter((Object)myConsoleView, (String)"myConsoleView");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)consoleCommunication, (String)"consoleCommunication");
        super(processHandler, false);
        this.myConsoleView = myConsoleView;
        this.consoleCommunication = consoleCommunication;
        this.project = this.myConsoleView.getProject();
        this.myEnterHandler = new PyConsoleEnterHandler();
        this.ipythonInputPromptCount = 2;
        this.consoleCommunication.addCommunicationListener(this);
    }

    @Override
    @NotNull
    public final ConsoleCommunication getConsoleCommunication() {
        return this.consoleCommunication;
    }

    protected int getIpythonInputPromptCount() {
        return this.ipythonInputPromptCount;
    }

    protected void setIpythonInputPromptCount(int n) {
        this.ipythonInputPromptCount = n;
    }

    public final void decreaseInputPromptCount(int value) {
        this.setIpythonInputPromptCount(this.getIpythonInputPromptCount() - value);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.isEnabled = value;
        this.updateConsoleState();
    }

    @Override
    public void processLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.executeMultiLine(line);
    }

    private final void executeMultiLine(String text) {
        Object commandText = !StringsKt.endsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null) ? text + "\n" : text;
        this.sendLineToConsole(new ConsoleCommunication.ConsoleCodeFragment((String)commandText, this.checkSingleLine(text)));
    }

    @Override
    public boolean checkSingleLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LanguageLevel languageLevel = PythonLanguageLevelPusher.getLanguageLevelForVirtualFile(this.project, this.myConsoleView.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"getLanguageLevelForVirtualFile(...)");
        LanguageLevel languageLevel2 = languageLevel;
        PsiFile psiFile = PyElementGenerator.getInstance(this.project).createDummyFile(languageLevel2, text);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyFile");
        PyFile pyFile = (PyFile)psiFile;
        Class[] classArray = new Class[]{PyStatementList.class};
        return PsiTreeUtil.findChildOfAnyType((PsiElement)((PsiElement)pyFile), (Class[])classArray) == null && pyFile.getStatements().size() < 2;
    }

    private final void sendLineToConsole(ConsoleCommunication.ConsoleCodeFragment code) {
        ConsoleCommunication consoleComm = this.consoleCommunication;
        if (!consoleComm.isWaitingForInput()) {
            this.executingPrompt();
        }
        if (this.getIpythonEnabled() && !consoleComm.isWaitingForInput()) {
            String string = code.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!StringsKt.isBlank((CharSequence)string)) {
                this.setIpythonInputPromptCount(this.getIpythonInputPromptCount() + 1);
                this.getIpythonInputPromptCount();
            }
        }
        if (PyConsoleUtil.isCommandQueueEnabled(this.project)) {
            boolean $i$f$service = false;
            Class<CommandQueueForPythonConsoleService> serviceClass$iv = CommandQueueForPythonConsoleService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((CommandQueueForPythonConsoleService)object).addNewCommand(this, code);
        } else {
            consoleComm.execInterpreter(code, (Function<InterpreterResponse, Object>)((Function)PydevConsoleExecuteActionHandler::sendLineToConsole$lambda$0));
        }
    }

    @Override
    public void updateConsoleState() {
        if (!this.isEnabled()) {
            this.executingPrompt();
        } else if (this.consoleCommunication.isWaitingForInput()) {
            this.waitingForInputPrompt();
        } else if (this.canExecuteNow()) {
            if (this.consoleCommunication.needsMore()) {
                this.more();
            } else {
                this.inPrompt();
            }
        } else if (PyConsoleUtil.isCommandQueueEnabled(this.project)) {
            this.inPrompt();
        } else {
            this.executingPrompt();
        }
    }

    private final void inPrompt() {
        if (this.getIpythonEnabled()) {
            this.ipythonInPrompt();
        } else {
            this.ordinaryPrompt();
        }
    }

    private final void ordinaryPrompt() {
        if (!Intrinsics.areEqual((Object)">>>", (Object)this.myConsoleView.getPrompt())) {
            this.myConsoleView.setPrompt(">>>");
            PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt(this.myConsoleView, "...");
            PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
        }
    }

    private final boolean getIpythonEnabled() {
        return PyConsoleUtil.getOrCreateIPythonData(this.myConsoleView.getVirtualFile()).isIPythonEnabled();
    }

    protected void ipythonInPrompt() {
        this.ipythonInPrompt("In [" + this.getIpythonInputPromptCount() + "]:");
    }

    protected final void ipythonInPrompt(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        TextAttributes textAttributes = new TextAttributes();
        this.myConsoleView.setPromptAttributes(new ConsoleViewContentType(textAttributes){

            public TextAttributes getAttributes() {
                TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(ConsoleViewContentType.USER_INPUT_KEY);
                attrs.setFontType(0);
                Intrinsics.checkNotNull((Object)attrs);
                return attrs;
            }
        });
        String indentPrompt = StringsKt.padStart$default((String)"...:", (int)prompt.length(), (char)'\u0000', (int)2, null);
        this.myConsoleView.setPrompt(prompt);
        PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt(this.myConsoleView, indentPrompt);
        PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
    }

    private final void executingPrompt() {
        this.myConsoleView.setPrompt("");
        PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt(this.myConsoleView, "");
    }

    private final void waitingForInputPrompt() {
        if (!Intrinsics.areEqual((Object)">?", (Object)this.myConsoleView.getPrompt()) && !Intrinsics.areEqual((Object)"help>", (Object)this.myConsoleView.getPrompt())) {
            this.myConsoleView.setPrompt(">?");
            PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt(this.myConsoleView, ">?");
            PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
        }
    }

    private final void more() {
        String prompt;
        String string = prompt = this.getIpythonEnabled() ? "...:" : "...";
        if (!Intrinsics.areEqual((Object)prompt, (Object)this.myConsoleView.getPrompt())) {
            this.myConsoleView.setPrompt(prompt);
            PydevConsoleExecuteActionHandlerKt.access$setIndentPrompt(this.myConsoleView, prompt);
            PyConsoleUtil.scrollDown((Editor)this.myConsoleView.getCurrentEditor());
        }
    }

    @Override
    public void commandExecuted(boolean more) {
        this.updateConsoleState();
    }

    @Override
    public void inputRequested() {
        this.setEnabled(true);
    }

    @Override
    @NotNull
    public String getCantExecuteMessage() {
        if (!this.isEnabled()) {
            return this.getConsoleIsNotEnabledMessage();
        }
        if (!this.canExecuteNow()) {
            return Companion.getPrevCommandRunningMessage();
        }
        return "Can't execute the command";
    }

    public void runExecuteAction(@NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        if (this.isEnabled()) {
            if (PyConsoleUtil.isCommandQueueEnabled(this.project)) {
                this.doRunExecuteAction(console);
            } else if (!this.canExecuteNow()) {
                HintManager.getInstance().showErrorHint((Editor)console.getConsoleEditor(), Companion.getPrevCommandRunningMessage());
            } else {
                this.doRunExecuteAction(console);
            }
        } else {
            HintManager.getInstance().showErrorHint((Editor)console.getConsoleEditor(), this.getConsoleIsNotEnabledMessage());
        }
    }

    private final void doRunExecuteAction(LanguageConsoleView console) {
        Document doc = this.myConsoleView.getEditorDocument();
        RangeMarker rangeMarker = doc.createRangeMarker(doc.getTextLength(), doc.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker endMarker = rangeMarker;
        endMarker.setGreedyToLeft(false);
        endMarker.setGreedyToRight(true);
        boolean isComplete = this.myEnterHandler.handleEnterPressed(console.getConsoleEditor());
        if (isComplete || this.consoleCommunication.isWaitingForInput()) {
            Companion.deleteString(doc, endMarker);
            if (PydevConsoleExecuteActionHandler.Companion.shouldCopyToHistory(console)) {
                PythonConsoleView pythonConsoleView = console instanceof PythonConsoleView ? (PythonConsoleView)console : null;
                if (pythonConsoleView != null) {
                    PythonConsoleView pythonConsole = pythonConsoleView;
                    boolean bl = false;
                    pythonConsole.flushDeferredText();
                    pythonConsole.storeExecutionCounterLineNumber(this.getIpythonInputPromptCount(), pythonConsole.getHistoryViewer().getDocument().getLineCount() + ((PythonConsoleView)console).getConsoleEditor().getDocument().getLineCount());
                }
                this.copyToHistoryAndExecute(console);
            } else {
                String string = this.myConsoleView.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.processLine(string);
            }
        }
    }

    private final void copyToHistoryAndExecute(LanguageConsoleView console) {
        super.runExecuteAction(console);
    }

    @Override
    public boolean canExecuteNow() {
        return !this.consoleCommunication.isExecuting() || this.consoleCommunication.isWaitingForInput();
    }

    @NotNull
    protected String getConsoleIsNotEnabledMessage() {
        return Companion.getNotEnabledMessage();
    }

    private static final Unit sendLineToConsole$lambda$0(InterpreterResponse it) {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/console/PydevConsoleExecuteActionHandler$Companion;", "", "<init>", "()V", "prevCommandRunningMessage", "", "getPrevCommandRunningMessage", "()Ljava/lang/String;", "notEnabledMessage", "getNotEnabledMessage", "shouldCopyToHistory", "", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "deleteString", "", "document", "Lcom/intellij/openapi/editor/Document;", "endMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPrevCommandRunningMessage() {
            return "Previous command is still running. Please wait or press Ctrl+C in console to interrupt.";
        }

        @NotNull
        public final String getNotEnabledMessage() {
            return "Console is not enabled.";
        }

        private final boolean shouldCopyToHistory(LanguageConsoleView console) {
            return !PyConsoleUtil.isPagingPrompt(console.getPrompt());
        }

        public final void deleteString(@NotNull Document document, @NotNull RangeMarker endMarker) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)endMarker, (String)"endMarker");
            if (endMarker.getEndOffset() - endMarker.getStartOffset() > 0) {
                ApplicationManager.getApplication().runWriteAction(() -> Companion.deleteString$lambda$1(document, endMarker));
            }
        }

        private static final void deleteString$lambda$1$lambda$0(Document $document, RangeMarker $endMarker) {
            $document.deleteString($endMarker.getStartOffset(), $endMarker.getEndOffset());
        }

        private static final void deleteString$lambda$1(Document $document, RangeMarker $endMarker) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> Companion.deleteString$lambda$1$lambda$0($document, $endMarker));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

