/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javajs.util.BS;

public class CDXMLParser {
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float minZ = Float.MAX_VALUE;
    private float maxZ = -3.4028235E38f;
    private float maxY = -3.4028235E38f;
    private float maxX = -3.4028235E38f;
    private int idnext = 100000;
    protected BS bsAtoms = new BS();
    protected BS bsBonds = new BS();
    List<CDNode> atoms = new ArrayList<CDNode>();
    List<CDBond> bonds = new ArrayList<CDBond>();
    Map<String, CDBond> bondIDMap = new HashMap<String, CDBond>();
    private Stack<BracketedGroup> bracketedGroups;
    protected CDXReaderI rdr;
    public Map<String, CDNode> mapCloned;
    private Stack<String> fragments = new Stack();
    private String thisFragmentID;
    private CDNode thisNode;
    private CDNode thisAtom;
    private boolean ignoreText;
    private Stack<CDNode> nodes = new Stack();
    private List<CDNode> nostereo = new ArrayList<CDNode>();
    Map<String, Object> objectsByID = new HashMap<String, Object>();
    private String textBuffer;

    public CDXMLParser(CDXReaderI reader) {
        this.rdr = reader;
    }

    public void processStartElement(String localName, Map<String, String> atts) {
        String id = atts.get("id");
        switch (localName) {
            case "n": {
                this.objectsByID.put(id, this.setNode(id, atts));
                break;
            }
            case "b": {
                this.objectsByID.put(id, this.setBond(id, atts));
                break;
            }
            case "t": {
                this.textBuffer = "";
                break;
            }
            case "s": {
                this.rdr.setKeepChars(true);
                break;
            }
            case "fragment": {
                this.objectsByID.put(id, this.setFragment(id, atts));
                break;
            }
            case "objecttag": {
                switch (atts.get("name")) {
                    case "parameterizedBracketLabel": 
                    case "bracketusage": {
                        this.ignoreText = true;
                    }
                }
                break;
            }
            case "bracketedgroup": {
                this.setBracketedGroup(id, atts);
                break;
            }
            case "crossingbond": {
                BracketedGroup bg;
                BracketedGroup bracketedGroup = bg = this.bracketedGroups == null || this.bracketedGroups.isEmpty() ? null : (BracketedGroup)this.bracketedGroups.get(this.bracketedGroups.size() - 1);
                if (bg == null || bg.repeatCount <= 0) break;
                bg.addCrossing(atts.get("inneratomid"), atts.get("bondid"));
            }
        }
    }

    public String nextID() {
        return "" + this.idnext++;
    }

    public static String getBondKey(int atomIndex1, int atomIndex2) {
        return Math.min(atomIndex1, atomIndex2) + "_" + Math.max(atomIndex1, atomIndex2);
    }

    public CDBond getBond(CDNode a, CDNode b) {
        return this.bondIDMap.get(CDXMLParser.getBondKey(a.index, b.index));
    }

    void processEndElement(String localName, String chars) {
        switch (localName) {
            case "fragment": {
                this.thisFragmentID = this.fragments.pop();
                return;
            }
            case "objecttag": {
                this.ignoreText = false;
                return;
            }
            case "n": {
                this.thisNode = this.nodes.size() == 0 ? null : this.nodes.pop();
                return;
            }
            case "bracketedgroup": {
                break;
            }
            case "s": {
                this.textBuffer = this.textBuffer + chars.toString();
                break;
            }
            case "t": {
                if (!this.ignoreText) {
                    if (this.thisNode == null) {
                        System.out.println("CDXReader unassigned text: " + this.textBuffer);
                    } else {
                        this.thisNode.text = this.textBuffer;
                        if (this.thisAtom.elementNumber == 0) {
                            System.err.println("XmlChemDrawReader: Problem with \"" + this.textBuffer + "\"");
                        }
                        if (this.thisNode.warning != null) {
                            this.rdr.warn("Warning: " + this.textBuffer + " " + this.thisNode.warning);
                        }
                    }
                }
                this.textBuffer = "";
            }
        }
        this.rdr.setKeepChars(false);
    }

    private String[] getTokens(String s) {
        return s.split("\\s");
    }

    private String[] split(String s, String p) {
        return s.split(p);
    }

    int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return Integer.MIN_VALUE;
        }
    }

    private float parseFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    private CDNode setNode(String id, Map<String, String> atts) {
        String nodeType = atts.get("nodetype");
        if (this.thisNode != null) {
            this.nodes.push(this.thisNode);
        }
        if ("_".equals(nodeType)) {
            this.thisNode = null;
            this.thisAtom = null;
            return null;
        }
        this.thisAtom = this.thisNode = new CDNode(this.atoms.size(), id, nodeType, this.thisFragmentID, this.thisNode);
        this.addAtom(this.thisNode);
        String w = atts.get("warning");
        if (w != null) {
            this.thisNode.warning = w.replace("&apos;", "'");
            this.thisNode.isValid = w.indexOf("ChemDraw can't interpret") < 0;
        }
        String element = atts.get("element");
        String s = atts.get("genericnickname");
        if (s != null) {
            element = s;
        }
        this.thisAtom.element = element;
        this.thisAtom.elementNumber = (short)Math.max(0, !this.checkWarningOK(w) ? 0 : (element == null ? 6 : this.parseInt(element)));
        this.thisAtom.isotope = atts.get("isotope");
        s = atts.get("charge");
        if (s != null) {
            this.thisAtom.formalCharge = this.parseInt(s);
        }
        this.rdr.handleCoordinates(atts);
        s = atts.get("attachments");
        if (s != null) {
            this.thisNode.setMultipleAttachments(this.split(s.trim(), " "));
        }
        if ((s = atts.get("bondordering")) != null) {
            this.thisNode.setBondOrdering(this.split(s.trim(), " "));
        }
        return this.thisNode;
    }

    private boolean checkWarningOK(String warning) {
        return warning == null || warning.indexOf("valence") >= 0 || warning.indexOf("very close") >= 0 || warning.indexOf("two identical colinear bonds") >= 0;
    }

    private CDNode setFragment(String id, Map<String, String> atts) {
        String s;
        CDNode fragmentNode;
        this.thisFragmentID = id;
        this.fragments.push(this.thisFragmentID);
        CDNode cDNode = fragmentNode = this.thisNode == null || !this.thisNode.isFragment ? null : this.thisNode;
        if (fragmentNode != null) {
            fragmentNode.setInnerFragmentID(id);
        }
        if ((s = atts.get("connectionorder")) != null) {
            this.thisNode.setConnectionOrder(s.trim().split(" "));
        }
        return fragmentNode;
    }

    private CDBond setBond(String id, Map<String, String> atts) {
        String atom1 = atts.get("b");
        String atom2 = atts.get("e");
        String a = atts.get("beginattach");
        int beginAttach = a == null ? 0 : this.parseInt(a);
        a = atts.get("endattach");
        int endAttach = a == null ? 0 : this.parseInt(a);
        String s = atts.get("order");
        String disp = atts.get("display");
        String disp2 = atts.get("display2");
        int order = this.rdr.getBondOrder("null");
        boolean invertEnds = false;
        if (disp == null) {
            if (s == null) {
                order = 1;
            } else if (s.equals("1.5")) {
                order = this.rdr.getBondOrder("delocalized");
            } else {
                if (s.indexOf(".") > 0 && !"Dash".equals(disp2)) {
                    s = s.substring(0, s.indexOf("."));
                }
                order = this.rdr.getBondOrder(s);
            }
        } else if (disp.equals("WedgeBegin")) {
            order = this.rdr.getBondOrder("up");
        } else if (disp.equals("Hash") || disp.equals("WedgedHashBegin")) {
            order = this.rdr.getBondOrder("down");
        } else if (disp.equals("WedgeEnd")) {
            invertEnds = true;
            order = this.rdr.getBondOrder("up");
        } else if (disp.equals("WedgedHashEnd")) {
            invertEnds = true;
            order = this.rdr.getBondOrder("down");
        } else if (disp.equals("Bold")) {
            order = this.rdr.getBondOrder("single");
        } else if (disp.equals("Wavy")) {
            order = this.rdr.getBondOrder("either");
        }
        if (order == this.rdr.getBondOrder("null")) {
            System.err.println("XmlChemDrawReader ignoring bond type " + s);
            return null;
        }
        CDBond b = invertEnds ? new CDBond(id, atom2, atom1, order) : new CDBond(id, atom1, atom2, order);
        CDNode node1 = this.getAtom(b.atomIndex1);
        CDNode node2 = this.getAtom(b.atomIndex2);
        if (order == this.rdr.getBondOrder("either")) {
            if (!this.nostereo.contains(node1)) {
                this.nostereo.add(node1);
            }
            if (!this.nostereo.contains(node2)) {
                this.nostereo.add(node2);
            }
        }
        if (node1.hasMultipleAttachments) {
            node1.attachedAtom = node2;
            return b;
        }
        if (node2.hasMultipleAttachments) {
            node2.attachedAtom = node1;
            return b;
        }
        if (node1.isFragment && beginAttach == 0) {
            beginAttach = 1;
        }
        if (node2.isFragment && endAttach == 0) {
            endAttach = 1;
        }
        if (beginAttach > 0) {
            (invertEnds ? node2 : node1).addAttachedAtom(b, beginAttach);
        }
        if (endAttach > 0) {
            (invertEnds ? node1 : node2).addAttachedAtom(b, endAttach);
        }
        if (node1.isExternalPt) {
            node1.setInternalAtom(node2);
        }
        if (node2.isExternalPt) {
            node2.setInternalAtom(node1);
        }
        this.addBond(b);
        return b;
    }

    private void setBracketedGroup(String id, Map<String, String> atts) {
        String usage = atts.get("bracketusage");
        if (this.bracketedGroups == null) {
            this.bracketedGroups = new Stack();
        }
        if ("MultipleGroup".equals(usage)) {
            String[] ids = this.getTokens(atts.get("bracketedobjectids"));
            int repeatCount = this.parseInt(atts.get("repeatcount"));
            this.bracketedGroups.add(new BracketedGroup(id, ids, repeatCount));
        }
    }

    public void setAtom(String key, Map<String, String> atts) {
        float z;
        String xyz = atts.get(key);
        String[] tokens = this.getTokens(xyz);
        float x = this.parseFloat(tokens[0]);
        float y = -this.parseFloat(tokens[1]);
        float f = z = key == "xyz" ? this.parseFloat(tokens[2]) : 0.0f;
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        this.thisAtom.set(x, y, z);
    }

    private void fixInvalidAtoms() {
        int i = this.getAtomCount();
        while (--i >= 0) {
            CDNode a = this.getAtom(i);
            a.intID = Integer.MIN_VALUE;
            if (!a.isFragment && !a.isExternalPt && (a.isConnected || a.isValid && a.elementNumber >= 10)) continue;
            this.bsAtoms.clear(a.index);
        }
        this.reserializeAtoms();
        this.bsBonds.clearAll();
        i = this.getBondCount();
        while (--i >= 0) {
            CDBond b = this.getBond(i);
            if (!b.isValid()) continue;
            this.bsBonds.set(i);
        }
    }

    private void reserializeAtoms() {
        int p = 0;
        int i = this.bsAtoms.nextSetBit(0);
        while (i >= 0) {
            this.getAtom((int)i).intID = ++p;
            i = this.bsAtoms.nextSetBit(i + 1);
        }
    }

    private void reindexAtomsAndBonds() {
        this.reserializeAtoms();
        int p = 0;
        int i = this.bsAtoms.nextSetBit(0);
        while (i >= 0) {
            this.getAtom((int)i).index = p++;
            i = this.bsAtoms.nextSetBit(i + 1);
        }
        int i2 = this.bsBonds.nextSetBit(0);
        while (i2 >= 0) {
            CDBond b = this.getBond(i2);
            b.atomIndex1 = b.atom1.index;
            b.atomIndex2 = b.atom2.index;
            i2 = this.bsBonds.nextSetBit(i2 + 1);
        }
    }

    private void fixConnections() {
        int i = this.getAtomCount();
        while (--i >= 0) {
            CDNode a = this.getAtom(i);
            if (!a.isFragment && !a.hasMultipleAttachments) continue;
            a.fixAttachments();
        }
        int n = this.getBondCount();
        for (i = 0; i < n; ++i) {
            CDBond b = this.getBond(i);
            if (b == null) continue;
            CDNode a1 = b.atom1;
            CDNode a2 = b.atom2;
            a1.isConnected = true;
            a2.isConnected = true;
            if (this.nostereo.contains(a1) == this.nostereo.contains(a2)) continue;
            b.order = 1;
        }
    }

    private void fixBracketedGroups() {
        if (this.bracketedGroups == null) {
            return;
        }
        int i = this.bracketedGroups.size();
        while (--i >= 0) {
            ((BracketedGroup)this.bracketedGroups.remove(i)).process();
        }
    }

    void dumpGraph() {
        int i;
        int n = this.getAtomCount();
        for (i = 0; i < n; ++i) {
            CDNode a = this.getAtom(i);
            System.out.println("CDXMLP " + i + " id=" + a.id + a.bsConnections + " cid=" + a.clonedIndex + " fa=" + a.bsFragmentAtoms + " xp=" + a.isExternalPt + " ifd=" + a.innerFragmentID + " ofd= " + a.outerFragmentID);
        }
        n = this.getBondCount();
        for (i = 0; i < n; ++i) {
            CDBond b = this.getBond(i);
            System.out.println("CDXMLP bond " + i + " " + b.atomIndex1 + " " + b.atomIndex2 + b);
        }
        System.out.println(this.bondIDMap);
    }

    private void centerAndScale() {
        float f;
        if (this.minX > this.maxX) {
            return;
        }
        float sum = 0.0f;
        int n = 0;
        float lenH = 1.0f;
        int i = this.getBondCount();
        while (--i >= 0) {
            CDBond b = this.getBond(i);
            CDNode a1 = b.atom1;
            CDNode a2 = b.atom2;
            float d = a1.distance(a2);
            if (a1.elementNumber > 1 && a2.elementNumber > 1) {
                sum += d;
                ++n;
                continue;
            }
            lenH = d;
        }
        float f2 = sum > 0.0f ? 1.45f * (float)n / sum : (f = lenH > 0.0f ? 1.0f / lenH : 1.0f);
        if ((double)f > 0.5) {
            f = 1.0f;
        }
        float cx = (this.maxX + this.minX) / 2.0f;
        float cy = (this.maxY + this.minY) / 2.0f;
        float cz = (this.maxZ + this.minZ) / 2.0f;
        int i2 = this.getAtomCount();
        while (--i2 >= 0) {
            CDNode a = this.getAtom(i2);
            a.x = (a.x - cx) * f;
            a.y = (a.y - cy) * f;
            a.z = (a.z - cz) * f;
        }
    }

    CDNode getAtom(int i) {
        return this.atoms.get(i);
    }

    CDNode addAtom(CDNode atom) {
        this.atoms.add(atom);
        this.bsAtoms.set(atom.index);
        return atom;
    }

    int getAtomCount() {
        return this.atoms.size();
    }

    CDBond addBond(CDBond b) {
        b.index = this.getBondCount();
        this.bsBonds.set(b.index);
        this.bonds.add(b);
        return b;
    }

    CDBond getBond(int i) {
        return this.bonds.get(i);
    }

    int getBondCount() {
        return this.bonds.size();
    }

    public void finalizeParsing() {
        this.fixConnections();
        this.fixInvalidAtoms();
        this.fixBracketedGroups();
        this.centerAndScale();
        this.reindexAtomsAndBonds();
    }

    class BracketedGroup {
        String id;
        String[] ids;
        String[] bondIDs = new String[2];
        String[] innerAtomIDs = new String[2];
        int repeatCount;
        int pt;

        BracketedGroup(String id, String[] ids, int repeatCount) {
            this.id = id;
            this.ids = ids;
            this.repeatCount = repeatCount;
        }

        public void addCrossing(String innerAtomID, String bondID) {
            if (this.pt == 2) {
                System.err.println("BracketedGroup has more than two crossings");
                return;
            }
            this.bondIDs[this.pt] = bondID;
            this.innerAtomIDs[this.pt] = innerAtomID;
            ++this.pt;
        }

        public void process() {
            if (this.pt != 2 || this.repeatCount < 2) {
                return;
            }
            CDBond b1 = (CDBond)CDXMLParser.this.objectsByID.get(this.bondIDs[1]);
            CDNode a1i = (CDNode)CDXMLParser.this.objectsByID.get(this.innerAtomIDs[1]);
            CDNode a2i = (CDNode)CDXMLParser.this.objectsByID.get(this.innerAtomIDs[0]);
            CDBond b2 = (CDBond)CDXMLParser.this.objectsByID.get(this.bondIDs[0]);
            CDNode a2o = b2.getOtherNode(a2i);
            BS bsTrailingAtoms = new BS();
            this.buildBranch(a2i, a2o, null, null, bsTrailingAtoms, null, null);
            float[] offset = new float[]{a2o.x - a1i.x, a2o.y - a1i.y, a2o.z - a1i.z};
            BS bsBracketed = new BS();
            int i = this.ids.length;
            while (--i >= 0) {
                CDNode node = (CDNode)CDXMLParser.this.objectsByID.get(this.ids[i]);
                node.addBracketedAtoms(bsBracketed);
            }
            CDNode a1 = a1i;
            CDNode a2iLast = a2i;
            for (int i2 = 1; i2 < this.repeatCount; ++i2) {
                int nAtoms = CDXMLParser.this.getAtomCount();
                CDNode[] newNodes = this.duplicateBracketAtoms(a1i, a2i, bsBracketed);
                a1 = newNodes[0];
                this.patch(a2iLast, b1, a1);
                a2iLast = newNodes[1];
                this.shiftAtoms(nAtoms, offset, i2, null);
            }
            this.patch(a2iLast, b2, a2o);
            this.shiftAtoms(0, offset, this.repeatCount - 1, bsTrailingAtoms);
            b2.invalidate();
        }

        private void shiftAtoms(int firstAtom, float[] d, int multiplier, BS bs) {
            if (bs == null) {
                int i = CDXMLParser.this.getAtomCount();
                while (--i >= firstAtom) {
                    CDNode a = CDXMLParser.this.getAtom(i);
                    a.x += d[0] * (float)multiplier;
                    a.y += d[1] * (float)multiplier;
                    a.z += d[2] * (float)multiplier;
                }
            } else {
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    CDNode a = CDXMLParser.this.getAtom(i);
                    a.x += d[0] * (float)multiplier;
                    a.y += d[1] * (float)multiplier;
                    a.z += d[2] * (float)multiplier;
                    i = bs.nextSetBit(i + 1);
                }
            }
        }

        private CDNode[] duplicateBracketAtoms(CDNode a1i, CDNode a2i, BS bsBracketed) {
            CDXMLParser.this.mapCloned = new HashMap<String, CDNode>();
            CDNode aNew = a1i.clone();
            CDNode[] a12i = new CDNode[]{aNew, a1i == a2i ? aNew : null};
            BS bsDone = new BS();
            this.buildBranch(null, a1i, a2i, aNew, bsDone, bsBracketed, a12i);
            return a12i;
        }

        private void buildBranch(CDNode prev, CDNode aRoot, CDNode aEnd, CDNode a, BS bsDone, BS bsBracketed, CDNode[] a12i) {
            bsDone.set(aRoot.index);
            CDNode aNext = null;
            int i = aRoot.bsConnections.nextSetBit(0);
            while (i >= 0) {
                block6: {
                    boolean isNew;
                    CDNode aBranch;
                    block7: {
                        aBranch = CDXMLParser.this.getAtom(i);
                        if (aBranch == prev) break block6;
                        boolean bl = isNew = !bsDone.get(i);
                        if (bsBracketed == null) break block7;
                        if (!bsBracketed.get(i) || aBranch.isExternalPt) break block6;
                        CDBond bBranch = CDXMLParser.this.getBond(aRoot, aBranch);
                        CDNode cDNode = aNext = isNew ? aBranch.clone() : CDXMLParser.this.mapCloned.get(aBranch.id);
                        if (aBranch == aEnd && a12i[1] == null) {
                            a12i[1] = aNext;
                        }
                        CDBond b = bBranch.atom1 == aBranch ? new CDBond(null, aNext.id, a.id, bBranch.order) : new CDBond(null, a.id, aNext.id, bBranch.order);
                        CDXMLParser.this.addBond(b);
                    }
                    if (isNew) {
                        this.buildBranch(aRoot, aBranch, aEnd, aNext, bsDone, bsBracketed, a12i);
                    }
                }
                i = aRoot.bsConnections.nextSetBit(i + 1);
            }
        }

        private void patch(CDNode a1, CDBond b, CDNode a2) {
            CDBond b1 = CDXMLParser.this.addBond(new CDBond(null, a1.id, a2.id, b.order));
            b1.disconnect();
            b1.connect(a1, a2);
        }
    }

    class CDBond
    implements Cloneable {
        public int atomIndex1;
        public int atomIndex2;
        public int order;
        String id;
        String id1;
        String id2;
        CDNode atom1;
        CDNode atom2;
        int index;
        boolean invalidated;

        CDBond(String id, String id1, String id2, int order) {
            if (id1 == null) {
                return;
            }
            this.id = id == null ? CDXMLParser.this.nextID() : id;
            this.id1 = id1;
            this.id2 = id2;
            this.order = order;
            this.atom1 = (CDNode)CDXMLParser.this.objectsByID.get(id1);
            this.atom2 = (CDNode)CDXMLParser.this.objectsByID.get(id2);
            this.atomIndex1 = this.atom1.index;
            this.atomIndex2 = this.atom2.index;
            this.atom1.bsConnections.set(this.atomIndex2);
            this.atom2.bsConnections.set(this.atomIndex1);
            CDXMLParser.this.bondIDMap.put(CDXMLParser.getBondKey(this.atomIndex1, this.atomIndex2), this);
        }

        public void connect(CDNode atomA, CDNode atomB) {
            this.atom1 = atomA;
            this.atomIndex1 = atomA.index;
            this.atom2 = atomB;
            this.atomIndex2 = atomB.index;
            atomA.bsConnections.set(atomB.index);
            atomB.bsConnections.set(atomA.index);
            CDXMLParser.this.bondIDMap.put(CDXMLParser.getBondKey(this.atomIndex1, this.atomIndex2), this);
        }

        public void disconnect() {
            this.atom1.bsConnections.clear(this.atomIndex2);
            this.atom2.bsConnections.clear(this.atomIndex1);
            CDXMLParser.this.bondIDMap.remove(CDXMLParser.getBondKey(this.atomIndex1, this.atomIndex2));
        }

        CDNode getOtherNode(CDNode a) {
            return CDXMLParser.this.getAtom(this.atomIndex1 == a.index ? this.atomIndex2 : this.atomIndex1);
        }

        public void invalidate() {
            this.invalidated = true;
            CDXMLParser.this.bsBonds.clear(this.index);
            this.atomIndex2 = -1;
            this.atomIndex1 = -1;
        }

        public boolean isValid() {
            return !this.invalidated && this.atom1.intID >= 0 && this.atom2.intID >= 0;
        }

        public String toString() {
            return "[CDBond index " + this.index + " id " + this.id + " v=" + this.isValid() + " id1=" + this.id1 + "/" + this.atom1.index + "/" + this.atom1.clonedIndex + " id2=" + this.id2 + "/" + this.atom2.index + "/" + this.atom2.clonedIndex + "]";
        }
    }

    class CDNode
    implements Cloneable {
        public int index;
        public String id;
        public int intID;
        public String isotope;
        public String element;
        public int elementNumber;
        public float x;
        public float y;
        public float z;
        public int formalCharge;
        String nodeType;
        String warning;
        boolean isValid = true;
        boolean isConnected;
        boolean isExternalPt;
        boolean isFragment;
        String outerFragmentID;
        String innerFragmentID;
        public String text;
        CDNode parentNode;
        List<Object[]> orderedConnectionBonds;
        CDNode internalAtom;
        List<CDNode> orderedExternalPoints;
        private String[] attachments;
        private String[] bondOrdering;
        private String[] connectionOrder;
        public boolean hasMultipleAttachments;
        CDNode attachedAtom;
        public BS bsConnections;
        BS bsFragmentAtoms;
        int clonedIndex = -1;

        CDNode(int index, String id, String nodeType, String fragmentID, CDNode parent) {
            if (id == null) {
                return;
            }
            this.id = id;
            this.index = index;
            this.outerFragmentID = fragmentID;
            this.intID = Integer.parseInt(id);
            this.nodeType = nodeType;
            this.parentNode = parent;
            this.bsConnections = new BS();
            this.isFragment = "Fragment".equals(nodeType) || "Nickname".equals(nodeType);
            this.isExternalPt = "ExternalConnectionPoint".equals(nodeType);
            if (this.isFragment) {
                this.bsFragmentAtoms = new BS();
            } else if (parent != null && !this.isExternalPt) {
                if (parent.bsFragmentAtoms == null) {
                    parent.isFragment = true;
                    parent.bsFragmentAtoms = new BS();
                }
                parent.bsFragmentAtoms.set(index);
            }
        }

        public void set(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void setInnerFragmentID(String id) {
            this.innerFragmentID = id;
        }

        void setBondOrdering(String[] bondOrdering) {
            this.bondOrdering = bondOrdering;
        }

        void setConnectionOrder(String[] connectionOrder) {
            this.connectionOrder = connectionOrder;
        }

        void setMultipleAttachments(String[] attachments) {
            this.attachments = attachments;
            this.hasMultipleAttachments = true;
        }

        void addExternalPoint(CDNode externalPoint) {
            if (this.orderedExternalPoints == null) {
                this.orderedExternalPoints = new ArrayList<CDNode>();
            }
            int i = this.orderedExternalPoints.size();
            while (--i >= 0 && this.orderedExternalPoints.get((int)i).intID >= externalPoint.internalAtom.intID) {
            }
            this.orderedExternalPoints.add(++i, externalPoint);
        }

        public void setInternalAtom(CDNode a) {
            this.internalAtom = a;
            if (this.parentNode != null) {
                this.parentNode.addExternalPoint(this);
            }
        }

        void addAttachedAtom(CDBond bond, int pt) {
            if (this.orderedConnectionBonds == null) {
                this.orderedConnectionBonds = new ArrayList<Object[]>();
            }
            int i = this.orderedConnectionBonds.size();
            while (--i >= 0 && (Integer)this.orderedConnectionBonds.get(i)[0] > pt) {
            }
            this.orderedConnectionBonds.add(++i, new Object[]{pt, bond});
        }

        void fixAttachments() {
            CDNode a;
            if (this.hasMultipleAttachments && this.attachedAtom != null) {
                int order = CDXMLParser.this.rdr.getBondOrder("partial");
                CDNode a1 = this.attachedAtom;
                int i = this.attachments.length;
                while (--i >= 0) {
                    a = (CDNode)CDXMLParser.this.objectsByID.get(this.attachments[i]);
                    if (a == null) continue;
                    CDXMLParser.this.addBond(new CDBond(null, a1.id, a.id, order));
                }
            }
            if (this.orderedExternalPoints == null || this.text == null) {
                return;
            }
            int n = this.orderedExternalPoints.size();
            if (n != this.orderedConnectionBonds.size()) {
                System.err.println("XmlCdxReader cannot fix attachments for fragment " + this.text);
                return;
            }
            if (this.bondOrdering == null) {
                this.bondOrdering = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.bondOrdering[i] = ((CDBond)this.orderedConnectionBonds.get((int)i)[1]).id;
                }
            }
            if (this.connectionOrder == null) {
                this.connectionOrder = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.connectionOrder[i] = this.orderedExternalPoints.get((int)i).id;
                }
            }
            for (int i = 0; i < n; ++i) {
                CDBond b = (CDBond)CDXMLParser.this.objectsByID.get(this.bondOrdering[i]);
                a = ((CDNode)CDXMLParser.this.objectsByID.get((Object)this.connectionOrder[i])).internalAtom;
                this.updateExternalBond(b, a);
            }
        }

        private void updateExternalBond(CDBond bond2f, CDNode intAtom) {
            CDXMLParser.this.bsBonds.set(bond2f.index);
            bond2f.disconnect();
            if (bond2f.atomIndex2 == this.index) {
                bond2f.connect(bond2f.atom1, intAtom);
            } else if (bond2f.atomIndex1 == this.index) {
                bond2f.connect(intAtom, bond2f.atom2);
            } else {
                System.err.println("CDXMLParser attachment failed! " + intAtom + " " + bond2f);
            }
        }

        public CDNode clone() {
            try {
                CDNode a = (CDNode)super.clone();
                a.index = CDXMLParser.this.atoms.size();
                a.id = CDXMLParser.this.nextID();
                CDXMLParser.this.mapCloned.put(this.id, a);
                a.clonedIndex = this.index;
                a.bsConnections = new BS();
                CDXMLParser.this.objectsByID.put(a.id, a);
                CDXMLParser.this.addAtom(a);
                return a;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public String toString() {
            return "[CDNode " + this.id + " " + this.elementNumber + " index=" + this.index + " ext=" + this.isExternalPt + " frag=" + this.isFragment + "  " + this.x + " " + this.y + "]";
        }

        public float distance(CDNode a2) {
            float dx = this.x - a2.x;
            float dy = this.y - a2.y;
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        public void addBracketedAtoms(BS bsBracketed) {
            if (this.isFragment) {
                bsBracketed.or(this.bsFragmentAtoms);
            } else if (!this.isExternalPt) {
                bsBracketed.set(this.index);
            }
        }
    }

    public static interface CDXReaderI {
        public int getBondOrder(String var1);

        public void handleCoordinates(Map<String, String> var1);

        public void setKeepChars(boolean var1);

        public void warn(String var1);
    }
}

