/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.ArrayTypeImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.BasicType;

public class ArrayReferenceImpl
extends ObjectReferenceImpl {
    private final int length;

    ArrayReferenceImpl(ReferenceTypeImpl type, Array aRef) {
        super(type, (Oop)aRef);
        this.length = (int)aRef.getLength();
    }

    public ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.referenceType();
    }

    public int length() {
        return this.length;
    }

    public ValueImpl getValue(int index) {
        return this.getValues(index, 1).get(0);
    }

    private void validateArrayAccess(int index, int len) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array index: " + index);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + len);
        }
        if (index + len > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + index + " to " + (index + len - 1));
        }
    }

    public List<ValueImpl> getValues(int index, int len) {
        if (len == -1) {
            len = this.length() - index;
        }
        this.validateArrayAccess(index, len);
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValueImpl> vals = new ArrayList<ValueImpl>(len);
        TypeArray typeArray = null;
        ObjArray objArray = null;
        if (this.ref() instanceof TypeArray) {
            typeArray = (TypeArray)this.ref();
        } else if (this.ref() instanceof ObjArray) {
            objArray = (ObjArray)this.ref();
        } else {
            throw new RuntimeException("should not reach here");
        }
        char c = this.arrayType().componentSignature().charAt(0);
        BasicType variableType = BasicType.charToBasicType((char)c);
        int limit = index + len;
        for (int ii = index; ii < limit; ++ii) {
            ValueImpl valueImpl;
            if (variableType == BasicType.T_BOOLEAN) {
                valueImpl = this.vm().mirrorOf(typeArray.getBooleanAt((long)ii));
            } else if (variableType == BasicType.T_CHAR) {
                valueImpl = this.vm().mirrorOf(typeArray.getCharAt((long)ii));
            } else if (variableType == BasicType.T_FLOAT) {
                valueImpl = this.vm().mirrorOf(typeArray.getFloatAt((long)ii));
            } else if (variableType == BasicType.T_DOUBLE) {
                valueImpl = this.vm().mirrorOf(typeArray.getDoubleAt((long)ii));
            } else if (variableType == BasicType.T_BYTE) {
                valueImpl = this.vm().mirrorOf(typeArray.getByteAt((long)ii));
            } else if (variableType == BasicType.T_SHORT) {
                valueImpl = this.vm().mirrorOf(typeArray.getShortAt((long)ii));
            } else if (variableType == BasicType.T_INT) {
                valueImpl = this.vm().mirrorOf(typeArray.getIntAt((long)ii));
            } else if (variableType == BasicType.T_LONG) {
                valueImpl = this.vm().mirrorOf(typeArray.getLongAt((long)ii));
            } else if (variableType == BasicType.T_OBJECT || variableType == BasicType.T_ARRAY) {
                valueImpl = this.vm().objectMirror(objArray.getOopHandleAt((long)ii));
            } else {
                throw new RuntimeException("should not reach here");
            }
            vals.add(valueImpl);
        }
        return vals;
    }

    @Override
    protected void visitReferences(ObjectReferenceImpl.HandleVisitor visitor) {
        if (this.ref() instanceof ObjArray) {
            ObjArray objArray = (ObjArray)this.ref();
            for (int i = 0; i < this.length; ++i) {
                OopHandle valueHandle = objArray.getOopHandleAt((long)i);
                if (valueHandle == null || !visitor.visit(valueHandle)) continue;
                return;
            }
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.arrayType().componentSignature() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 91;
    }
}

