/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.draw2d.graph.BreakCycles;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.HorizontalPlacement;
import org.eclipse.draw2d.graph.InitialRankSolver;
import org.eclipse.draw2d.graph.LocalOptimizer;
import org.eclipse.draw2d.graph.MinCross;
import org.eclipse.draw2d.graph.PopulateRanks;
import org.eclipse.draw2d.graph.RankAssignmentSolver;
import org.eclipse.draw2d.graph.RouteEdges;
import org.eclipse.draw2d.graph.TightSpanningTreeSolver;
import org.eclipse.draw2d.graph.TransposeMetrics;
import org.eclipse.draw2d.graph.VerticalPlacement;

public class DirectedGraphLayout {
    Deque<GraphVisitor> steps = new ArrayDeque<GraphVisitor>();

    public DirectedGraphLayout() {
        this.init();
    }

    void init() {
        this.steps.add(new TransposeMetrics());
        this.steps.add(new BreakCycles());
        this.steps.add(new RouteEdges());
        this.steps.add(new InitialRankSolver());
        this.steps.add(new TightSpanningTreeSolver());
        this.steps.add(new RankAssignmentSolver());
        this.steps.add(new PopulateRanks());
        this.steps.add(new VerticalPlacement());
        this.steps.add(new MinCross());
        this.steps.add(new LocalOptimizer());
        this.steps.add(new HorizontalPlacement());
    }

    public void visit(DirectedGraph graph) {
        if (graph.nodes.isEmpty()) {
            return;
        }
        this.steps.iterator().forEachRemaining(visitor -> visitor.visit(graph));
        this.steps.descendingIterator().forEachRemaining(visitor -> visitor.revisit(graph));
    }
}

