
use builtin;
use str;

set edit:completion:arg-completer[asciinema] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'asciinema'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'asciinema'= {
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand record 'Record a terminal session'
            cand rec 'Record a terminal session'
            cand stream 'Stream a terminal session'
            cand session 'Record and stream a terminal session'
            cand play 'Play back a terminal session'
            cand upload 'Upload a recording to an asciinema server'
            cand auth 'Authenticate this CLI with an asciinema server account'
            cand cat 'Concatenate multiple recordings'
            cand convert 'Convert a recording to another format'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'asciinema;record'= {
            cand -f 'Output file format [default: asciicast-v3]'
            cand --output-format 'Output file format [default: asciicast-v3]'
            cand -c 'Command to start in the session [default: $SHELL]'
            cand --command 'Command to start in the session [default: $SHELL]'
            cand --capture-env 'Comma-separated list of environment variables to capture [default: SHELL]'
            cand -t 'Title of the recording'
            cand --title 'Title of the recording'
            cand -i 'Limit idle time to a given number of seconds'
            cand --idle-time-limit 'Limit idle time to a given number of seconds'
            cand --window-size 'Override session''s terminal window size'
            cand --log-file 'Log file path'
            cand --cols 'cols'
            cand --rows 'rows'
            cand -I 'Enable input (keyboard) capture'
            cand --capture-input 'Enable input (keyboard) capture'
            cand -a 'Append to an existing recording file'
            cand --append 'Append to an existing recording file'
            cand --overwrite 'Overwrite the output file if it already exists'
            cand --headless 'Headless mode - don''t use the terminal for I/O'
            cand --return 'Return the session''s exit status'
            cand --raw 'raw'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;rec'= {
            cand -f 'Output file format [default: asciicast-v3]'
            cand --output-format 'Output file format [default: asciicast-v3]'
            cand -c 'Command to start in the session [default: $SHELL]'
            cand --command 'Command to start in the session [default: $SHELL]'
            cand --capture-env 'Comma-separated list of environment variables to capture [default: SHELL]'
            cand -t 'Title of the recording'
            cand --title 'Title of the recording'
            cand -i 'Limit idle time to a given number of seconds'
            cand --idle-time-limit 'Limit idle time to a given number of seconds'
            cand --window-size 'Override session''s terminal window size'
            cand --log-file 'Log file path'
            cand --cols 'cols'
            cand --rows 'rows'
            cand -I 'Enable input (keyboard) capture'
            cand --capture-input 'Enable input (keyboard) capture'
            cand -a 'Append to an existing recording file'
            cand --append 'Append to an existing recording file'
            cand --overwrite 'Overwrite the output file if it already exists'
            cand --headless 'Headless mode - don''t use the terminal for I/O'
            cand --return 'Return the session''s exit status'
            cand --raw 'raw'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;stream'= {
            cand -l 'Stream via the local HTTP server'
            cand --local 'Stream via the local HTTP server'
            cand -r 'Stream via remote asciinema server'
            cand --remote 'Stream via remote asciinema server'
            cand -c 'Command to start in the session [default: $SHELL]'
            cand --command 'Command to start in the session [default: $SHELL]'
            cand --capture-env 'Comma-separated list of environment variables to capture [default: SHELL]'
            cand -t 'Title of the session'
            cand --title 'Title of the session'
            cand --window-size 'Override session''s terminal window size'
            cand --log-file 'Log file path'
            cand --server-url 'asciinema server URL'
            cand -I 'Enable input (keyboard) capture'
            cand --capture-input 'Enable input (keyboard) capture'
            cand --headless 'Headless mode - don''t use the terminal for I/O'
            cand --return 'Return the session''s exit status'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;session'= {
            cand -o 'Save the session to a file'
            cand --output-file 'Save the session to a file'
            cand -f 'Output file format [default: asciicast-v3]'
            cand --output-format 'Output file format [default: asciicast-v3]'
            cand -l 'Stream via the local HTTP server'
            cand --stream-local 'Stream via the local HTTP server'
            cand -r 'Stream via remote asciinema server'
            cand --stream-remote 'Stream via remote asciinema server'
            cand -c 'Command to start in the session [default: $SHELL]'
            cand --command 'Command to start in the session [default: $SHELL]'
            cand --capture-env 'Comma-separated list of environment variables to capture [default: SHELL]'
            cand -t 'Title of the session'
            cand --title 'Title of the session'
            cand -i 'Limit idle time to a given number of seconds'
            cand --idle-time-limit 'Limit idle time to a given number of seconds'
            cand --window-size 'Override session''s terminal window size'
            cand --log-file 'Log file path'
            cand --server-url 'asciinema server URL'
            cand -I 'Enable input (keyboard) capture'
            cand --capture-input 'Enable input (keyboard) capture'
            cand -a 'Append to an existing recording file'
            cand --append 'Append to an existing recording file'
            cand --overwrite 'Overwrite the output file if it already exists'
            cand --headless 'Headless mode - don''t use the terminal for I/O'
            cand --return 'Return the session''s exit status'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;play'= {
            cand -s 'Set playback speed'
            cand --speed 'Set playback speed'
            cand -i 'Limit idle time to a given number of seconds'
            cand --idle-time-limit 'Limit idle time to a given number of seconds'
            cand -l 'Loop playback continuously'
            cand --loop 'Loop playback continuously'
            cand -m 'Automatically pause on markers'
            cand --pause-on-markers 'Automatically pause on markers'
            cand -r 'Auto-resize terminal to match original size'
            cand --resize 'Auto-resize terminal to match original size'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;upload'= {
            cand --server-url 'asciinema server URL'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;auth'= {
            cand --server-url 'asciinema server URL'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;cat'= {
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;convert'= {
            cand -f 'Output file format [default: asciicast-v3]'
            cand --output-format 'Output file format [default: asciicast-v3]'
            cand --overwrite 'Overwrite the output file if it already exists'
            cand -q 'Quiet mode - suppress diagnostic messages'
            cand --quiet 'Quiet mode - suppress diagnostic messages'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'asciinema;help'= {
            cand record 'Record a terminal session'
            cand stream 'Stream a terminal session'
            cand session 'Record and stream a terminal session'
            cand play 'Play back a terminal session'
            cand upload 'Upload a recording to an asciinema server'
            cand auth 'Authenticate this CLI with an asciinema server account'
            cand cat 'Concatenate multiple recordings'
            cand convert 'Convert a recording to another format'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'asciinema;help;record'= {
        }
        &'asciinema;help;stream'= {
        }
        &'asciinema;help;session'= {
        }
        &'asciinema;help;play'= {
        }
        &'asciinema;help;upload'= {
        }
        &'asciinema;help;auth'= {
        }
        &'asciinema;help;cat'= {
        }
        &'asciinema;help;convert'= {
        }
        &'asciinema;help;help'= {
        }
    ]
    $completions[$command]
}
