/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkIntensityWindowingImageFilter_h
#define sitkIntensityWindowingImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class IntensityWindowingImageFilter
\brief Applies a linear transformation to the intensity levels of the input Image that are inside a user-defined interval. Values below this interval are mapped to a constant. Values over the interval are mapped to another constant.

IntensityWindowingImageFilter applies pixel-wise a linear transformation to the intensity values of input image pixels. The linear transformation is defined by the user in terms of the minimum and maximum values that the output image should have and the lower and upper limits of the intensity window of the input image. This operation is very common in visualization, and can also be applied as a convenient preprocessing operation for image segmentation.

All computations are performed in the precision of the input pixel's RealType. Before assigning the computed value to the output pixel.

\see RescaleIntensityImageFilter
\sa itk::simple::IntensityWindowing for the procedural interface
\sa itk::IntensityWindowingImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT IntensityWindowingImageFilter : public ImageFilter {
    public:
      using Self = IntensityWindowingImageFilter;

      /** Destructor */
      virtual ~IntensityWindowingImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      IntensityWindowingImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/Get the values of the maximum and minimum intensities of the input intensity window.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetWindowMinimum ( double WindowMinimum ) { this->m_WindowMinimum = WindowMinimum; return *this; }

      /**
       * Set/Get the values of the maximum and minimum intensities of the input intensity window.
       */
      double GetWindowMinimum() const { return this->m_WindowMinimum; }\

      /**
       * Set/Get the values of the maximum and minimum intensities of the input intensity window.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetWindowMaximum ( double WindowMaximum ) { this->m_WindowMaximum = WindowMaximum; return *this; }

      /**
       * Set/Get the values of the maximum and minimum intensities of the input intensity window.
       */
      double GetWindowMaximum() const { return this->m_WindowMaximum; }\

      /**
       * Set/Get the values of the maximum and minimum intensities of the output image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputMinimum ( double OutputMinimum ) { this->m_OutputMinimum = OutputMinimum; return *this; }

      /**
       * Set/Get the values of the maximum and minimum intensities of the output image.
       */
      double GetOutputMinimum() const { return this->m_OutputMinimum; }\

      /**
       * Set/Get the values of the maximum and minimum intensities of the output image.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputMaximum ( double OutputMaximum ) { this->m_OutputMaximum = OutputMaximum; return *this; }

      /**
       * Set/Get the values of the maximum and minimum intensities of the output image.
       */
      double GetOutputMaximum() const { return this->m_OutputMaximum; }

      /** Name of this class */
      std::string GetName() const { return std::string ("IntensityWindowingImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_WindowMinimum{0.0};

      double  m_WindowMaximum{255.0};

      double  m_OutputMinimum{0.0};

      double  m_OutputMaximum{255.0};


      bool m_InPlace{false};
    };

    /**\
     * \brief Applies a linear transformation to the intensity levels of the input Image that are inside a user-defined interval. Values below this interval are mapped to a constant. Values over the interval are mapped to another constant.
     *
     * This function directly calls the execute method of IntensityWindowingImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::IntensityWindowingImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image IntensityWindowing ( Image&& image1, double windowMinimum = 0.0, double windowMaximum = 255.0, double outputMinimum = 0.0, double outputMaximum = 255.0 );
#endif
     SITKBasicFilters_EXPORT Image IntensityWindowing ( const Image& image1, double windowMinimum = 0.0, double windowMaximum = 255.0, double outputMinimum = 0.0, double outputMaximum = 255.0 );

     /** @} */
}
#endif
