/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.common.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.annotations.GwtCompatible;
import shaded.com.google.common.annotations.GwtIncompatible;
import shaded.com.google.common.annotations.J2ktIncompatible;
import shaded.com.google.common.annotations.VisibleForTesting;
import shaded.com.google.common.base.ElementTypesAreNonnullByDefault;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.IgnoreJRERequirement;
import shaded.com.google.common.base.Internal;
import shaded.com.google.common.base.NullnessCasts;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.ParametricNullness;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Supplier;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Suppliers {
    private Suppliers() {
    }

    public static <F, T> Supplier<T> compose(Function<? super F, T> function, Supplier<F> supplier) {
        return new SupplierComposition<F, T>(function, supplier);
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        if (delegate instanceof NonSerializableMemoizingSupplier || delegate instanceof MemoizingSupplier) {
            return delegate;
        }
        return delegate instanceof Serializable ? new MemoizingSupplier<T>(delegate) : new NonSerializableMemoizingSupplier<T>(delegate);
    }

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, long duration, TimeUnit unit) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(duration > 0L, "duration (%s %s) must be > 0", duration, (Object)unit);
        return new ExpiringMemoizingSupplier<T>(delegate, unit.toNanos(duration));
    }

    @J2ktIncompatible
    @GwtIncompatible
    @IgnoreJRERequirement
    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, Duration duration) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(!duration.isNegative() && !duration.isZero(), "duration (%s) must be > 0", (Object)duration);
        return new ExpiringMemoizingSupplier<T>(delegate, Internal.toNanosSaturated(duration));
    }

    public static <T> Supplier<T> ofInstance(@ParametricNullness T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    @J2ktIncompatible
    public static <T> Supplier<T> synchronizedSupplier(Supplier<T> delegate) {
        return new ThreadSafeSupplier<T>(delegate);
    }

    public static <T> Function<Supplier<T>, T> supplierFunction() {
        SupplierFunctionImpl sf = SupplierFunctionImpl.INSTANCE;
        return sf;
    }

    private static class SupplierComposition<F, T>
    implements Supplier<T>,
    Serializable {
        final Function<? super F, T> function;
        final Supplier<F> supplier;
        private static final long serialVersionUID = 0L;

        SupplierComposition(Function<? super F, T> function, Supplier<F> supplier) {
            this.function = Preconditions.checkNotNull(function);
            this.supplier = Preconditions.checkNotNull(supplier);
        }

        @Override
        @ParametricNullness
        public T get() {
            return this.function.apply(this.supplier.get());
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof SupplierComposition) {
                SupplierComposition that = (SupplierComposition)obj;
                return this.function.equals(that.function) && this.supplier.equals(that.supplier);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.function, this.supplier);
        }

        public String toString() {
            return "Suppliers.compose(" + this.function + ", " + this.supplier + ")";
        }
    }

    @VisibleForTesting
    static class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        private final Object lock = new Object();
        private static final Supplier<Void> SUCCESSFULLY_COMPUTED = () -> {
            throw new IllegalStateException();
        };
        private volatile Supplier<T> delegate;
        @CheckForNull
        private T value;

        NonSerializableMemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            if (this.delegate != SUCCESSFULLY_COMPUTED) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate != SUCCESSFULLY_COMPUTED) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.delegate = SUCCESSFULLY_COMPUTED;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            Supplier<T> delegate = this.delegate;
            return "Suppliers.memoize(" + (delegate == SUCCESSFULLY_COMPUTED ? "<supplier that returned " + this.value + ">" : delegate) + ")";
        }
    }

    @VisibleForTesting
    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private transient Object lock = new Object();
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        @CheckForNull
        transient T value;
        private static final long serialVersionUID = 0L;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            if (!this.initialized) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.initialized) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.initialized = true;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            return "Suppliers.memoize(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.lock = new Object();
        }
    }

    @VisibleForTesting
    static class ExpiringMemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private transient Object lock = new Object();
        final Supplier<T> delegate;
        final long durationNanos;
        @CheckForNull
        volatile transient T value;
        volatile transient long expirationNanos;
        private static final long serialVersionUID = 0L;

        ExpiringMemoizingSupplier(Supplier<T> delegate, long durationNanos) {
            this.delegate = delegate;
            this.durationNanos = durationNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            long nanos = this.expirationNanos;
            long now = System.nanoTime();
            if (nanos == 0L || now - nanos >= 0L) {
                Object object = this.lock;
                synchronized (object) {
                    if (nanos == this.expirationNanos) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        nanos = now + this.durationNanos;
                        this.expirationNanos = nanos == 0L ? 1L : nanos;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            return "Suppliers.memoizeWithExpiration(" + this.delegate + ", " + this.durationNanos + ", NANOS)";
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.lock = new Object();
        }
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        @ParametricNullness
        final T instance;
        private static final long serialVersionUID = 0L;

        SupplierOfInstance(@ParametricNullness T instance) {
            this.instance = instance;
        }

        @Override
        @ParametricNullness
        public T get() {
            return this.instance;
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof SupplierOfInstance) {
                SupplierOfInstance that = (SupplierOfInstance)obj;
                return Objects.equal(this.instance, that.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            return "Suppliers.ofInstance(" + this.instance + ")";
        }
    }

    @J2ktIncompatible
    private static class ThreadSafeSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        private static final long serialVersionUID = 0L;

        ThreadSafeSupplier(Supplier<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ParametricNullness
        public T get() {
            Supplier<T> supplier = this.delegate;
            synchronized (supplier) {
                return this.delegate.get();
            }
        }

        public String toString() {
            return "Suppliers.synchronizedSupplier(" + this.delegate + ")";
        }
    }

    private static enum SupplierFunctionImpl implements SupplierFunction<Object>
    {
        INSTANCE;


        @Override
        @CheckForNull
        public Object apply(Supplier<@Nullable Object> input) {
            return input.get();
        }

        public String toString() {
            return "Suppliers.supplierFunction()";
        }
    }

    private static interface SupplierFunction<T>
    extends Function<Supplier<T>, T> {
    }
}

