/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.misc.Coordinate;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STMessage;

public class STRuntimeMessage
extends STMessage {
    final Interpreter interp;
    public final int ip;
    public final InstanceScope scope;

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip) {
        this(interp, error, ip, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope2) {
        this(interp, error, ip, scope2, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope2, Object arg) {
        this(interp, error, ip, scope2, null, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope2, Throwable e, Object arg) {
        this(interp, error, ip, scope2, e, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope2, Throwable e, Object arg, Object arg2) {
        this(interp, error, ip, scope2, e, arg, arg2, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope2, Throwable e, Object arg, Object arg2, Object arg3) {
        super(error, scope2 != null ? scope2.st : null, e, arg, arg2, arg3);
        this.interp = interp;
        this.ip = ip;
        this.scope = scope2;
    }

    public String getSourceLocation() {
        if (this.ip < 0 || this.self.impl == null) {
            return null;
        }
        Interval I = this.self.impl.sourceMap[this.ip];
        if (I == null) {
            return null;
        }
        int i = I.a;
        Coordinate loc = Misc.getLineCharPosition(this.self.impl.template, i);
        return loc.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String loc = this.getSourceLocation();
        if (this.self != null) {
            buf.append("context [");
            if (this.interp != null) {
                buf.append(Interpreter.getEnclosingInstanceStackString(this.scope));
            }
            buf.append("]");
        }
        if (loc != null) {
            buf.append(" " + loc);
        }
        buf.append(" " + super.toString());
        return buf.toString();
    }
}

