/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation.dsl;

import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.span.SpanExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.AggregationBuilderHelper;
import org.opensearch.sql.opensearch.storage.serde.ExpressionSerializer;
import shaded.com.google.common.collect.ImmutableList;

public class CompositeAggregationBuilder {
    private final AggregationBuilderHelper helper;

    public CompositeAggregationBuilder(ExpressionSerializer serializer) {
        this.helper = new AggregationBuilderHelper(serializer);
    }

    public List<CompositeValuesSourceBuilder<?>> build(List<Triple<NamedExpression, SortOrder, MissingOrder>> groupList, boolean bucketNullable) {
        ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
        for (Triple<NamedExpression, SortOrder, MissingOrder> groupPair : groupList) {
            resultBuilder.add(this.buildCompositeValuesSourceBuilder(groupPair.getLeft(), groupPair.getMiddle(), groupPair.getRight(), bucketNullable));
        }
        return resultBuilder.build();
    }

    private CompositeValuesSourceBuilder<?> buildCompositeValuesSourceBuilder(NamedExpression expr, SortOrder sortOrder, MissingOrder missingOrder, boolean bucketNullable) {
        if (expr.getDelegated() instanceof SpanExpression) {
            SpanExpression spanExpr = (SpanExpression)expr.getDelegated();
            return CompositeAggregationBuilder.buildHistogram(expr.getName(), spanExpr.getField().toString(), spanExpr.getValue().valueOf().doubleValue(), spanExpr.getUnit(), missingOrder, bucketNullable);
        }
        CompositeValuesSourceBuilder sourceBuilder = new TermsValuesSourceBuilder(expr.getName()).order(sortOrder);
        if (bucketNullable) {
            sourceBuilder.missingBucket(true).missingOrder(missingOrder);
        }
        if (expr.getDelegated().type() instanceof OpenSearchDateType && List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(((OpenSearchDateType)expr.getDelegated().type()).getExprCoreType()) || List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(expr.getDelegated().type())) {
            sourceBuilder.userValuetypeHint(ValueType.LONG);
        }
        return this.helper.build(expr.getDelegated(), arg_0 -> ((CompositeValuesSourceBuilder)sourceBuilder).field(arg_0), arg_0 -> ((CompositeValuesSourceBuilder)sourceBuilder).script(arg_0));
    }

    public static CompositeValuesSourceBuilder<?> buildHistogram(String name, String field, Double value, SpanUnit unit, MissingOrder missingOrder, boolean bucketNullable) {
        switch (unit) {
            case NONE: {
                HistogramValuesSourceBuilder histogramBuilder = ((HistogramValuesSourceBuilder)new HistogramValuesSourceBuilder(name).field(field)).interval(value.doubleValue());
                if (bucketNullable) {
                    ((HistogramValuesSourceBuilder)histogramBuilder.missingBucket(true)).missingOrder(missingOrder);
                }
                return histogramBuilder;
            }
            case UNKNOWN: {
                throw new IllegalStateException("Invalid span unit");
            }
        }
        return CompositeAggregationBuilder.buildDateHistogram(name, field, value.intValue(), unit);
    }

    public static CompositeValuesSourceBuilder<?> buildDateHistogram(String name, String field, Integer value, SpanUnit unit) {
        String spanValue = value + unit.getName();
        switch (unit) {
            case MILLISECOND: 
            case MS: 
            case SECOND: 
            case S: 
            case MINUTE: 
            case m: 
            case HOUR: 
            case H: 
            case DAY: 
            case D: {
                return ((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(name).field(field)).fixedInterval(new DateHistogramInterval(spanValue));
            }
        }
        return ((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(name).field(field)).calendarInterval(new DateHistogramInterval(spanValue));
    }
}

