/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.calcite.plan.OpenSearchRules;
import org.opensearch.sql.calcite.plan.Scannable;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexEnumerator;
import org.opensearch.sql.opensearch.storage.scan.PushDownContext;

public class CalciteEnumerableIndexScan
extends AbstractCalciteIndexScan
implements Scannable,
EnumerableRel {
    private static final Logger LOG = LogManager.getLogger(CalciteEnumerableIndexScan.class);
    private volatile boolean isRequestBuilderUsedByEnumerator = false;

    public CalciteEnumerableIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        super(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    @Override
    protected AbstractCalciteIndexScan buildScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        return new CalciteEnumerableIndexScan(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    @Override
    public void register(RelOptPlanner planner) {
        for (RelOptRule rule : OpenSearchRules.OPEN_SEARCH_OPT_RULES) {
            planner.addRule(rule);
        }
        planner.removeRule(CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        Expression scanOperator = implementor.stash(this, CalciteEnumerableIndexScan.class);
        return implementor.result(physType, Blocks.toBlock(Expressions.call(scanOperator, "scan", new Expression[0])));
    }

    @Override
    public Enumerable<@Nullable Object> scan() {
        return new AbstractEnumerable<Object>(){

            @Override
            public Enumerator<Object> enumerator() {
                OpenSearchRequestBuilder requestBuilder = CalciteEnumerableIndexScan.this.getOrCreateRequestBuilder();
                return new OpenSearchIndexEnumerator(CalciteEnumerableIndexScan.this.osIndex.getClient(), CalciteEnumerableIndexScan.this.getFieldPath(), requestBuilder.getMaxResponseSize(), requestBuilder.getMaxResultWindow(), CalciteEnumerableIndexScan.this.osIndex.buildRequest(requestBuilder), CalciteEnumerableIndexScan.this.osIndex.createOpenSearchResourceMonitor());
            }
        };
    }

    private List<String> getFieldPath() {
        return this.getRowType().getFieldNames().stream().map(f -> this.osIndex.getAliasMapping().getOrDefault(f, (String)f)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenSearchRequestBuilder getOrCreateRequestBuilder() {
        PushDownContext pushDownContext = this.pushDownContext;
        synchronized (pushDownContext) {
            if (this.isRequestBuilderUsedByEnumerator) {
                return this.pushDownContext.createRequestBuilder();
            }
            this.isRequestBuilderUsedByEnumerator = true;
            return this.pushDownContext.getRequestBuilder();
        }
    }
}

