/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.binning;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class MinspanBucketFunction
extends ImplementorUDF {
    public MinspanBucketFunction() {
        super(new MinspanBucketImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.VARCHAR_2000;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC_NUMERIC_NUMERIC_NUMERIC;
    }

    public static class MinspanBucketImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression fieldValue = translatedOperands.get(0);
            Expression minSpan = translatedOperands.get(1);
            Expression dataRange = translatedOperands.get(2);
            Expression maxValue = translatedOperands.get(3);
            return Expressions.call(MinspanBucketImplementor.class, "calculateMinspanBucket", new Expression[]{Expressions.convert_(fieldValue, Number.class), Expressions.convert_(minSpan, Number.class), Expressions.convert_(dataRange, Number.class), Expressions.convert_(maxValue, Number.class)});
        }

        public static String calculateMinspanBucket(Number fieldValue, Number minSpanParam, Number dataRange, Number maxValue) {
            if (fieldValue == null || minSpanParam == null || dataRange == null || maxValue == null) {
                return null;
            }
            double value = fieldValue.doubleValue();
            double minSpan = minSpanParam.doubleValue();
            if (minSpan <= 0.0) {
                return null;
            }
            double range = dataRange.doubleValue();
            if (range <= 0.0) {
                return null;
            }
            double log10Minspan = Math.log10(minSpan);
            double ceilLog = Math.ceil(log10Minspan);
            double minspanWidth = Math.pow(10.0, ceilLog);
            double log10Range = Math.log10(range);
            double floorLog = Math.floor(log10Range);
            double defaultWidth = Math.pow(10.0, floorLog);
            boolean useDefault = defaultWidth >= minSpan;
            double selectedWidth = useDefault ? defaultWidth : minspanWidth;
            double binStart = Math.floor(value / selectedWidth) * selectedWidth;
            double binEnd = binStart + selectedWidth;
            return MinspanBucketImplementor.formatRange(binStart, binEnd, selectedWidth);
        }

        private static String formatRange(double binStart, double binEnd, double span) {
            if (MinspanBucketImplementor.isIntegerSpan(span) && MinspanBucketImplementor.isIntegerValue(binStart) && MinspanBucketImplementor.isIntegerValue(binEnd)) {
                return String.format("%d-%d", (long)binStart, (long)binEnd);
            }
            return MinspanBucketImplementor.formatFloatingPointRange(binStart, binEnd, span);
        }

        private static boolean isIntegerSpan(double span) {
            return span == Math.floor(span) && !Double.isInfinite(span);
        }

        private static boolean isIntegerValue(double value) {
            return Math.abs(value - (double)Math.round(value)) < 1.0E-10;
        }

        private static String formatFloatingPointRange(double binStart, double binEnd, double span) {
            int decimalPlaces = MinspanBucketImplementor.getAppropriateDecimalPlaces(span);
            String format = String.format("%%.%df-%%.%df", decimalPlaces, decimalPlaces);
            return String.format(format, binStart, binEnd);
        }

        private static int getAppropriateDecimalPlaces(double span) {
            if (span >= 1.0) {
                return 1;
            }
            if (span >= 0.1) {
                return 2;
            }
            if (span >= 0.01) {
                return 3;
            }
            return 4;
        }
    }
}

