/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.sql.data.type.ExprType;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.ImmutableSet;

public enum ExprCoreType implements ExprType
{
    UNKNOWN(new ExprCoreType[0]),
    UNDEFINED(new ExprCoreType[0]),
    BYTE(UNDEFINED),
    SHORT(BYTE),
    INTEGER(SHORT),
    LONG(INTEGER),
    FLOAT(LONG),
    DOUBLE(FLOAT),
    STRING(UNDEFINED),
    BOOLEAN(STRING),
    DATE(STRING),
    TIME(STRING),
    TIMESTAMP(STRING, DATE, TIME),
    INTERVAL(UNDEFINED),
    IP(STRING),
    GEO_POINT(UNDEFINED),
    BINARY(UNDEFINED),
    STRUCT(UNDEFINED),
    ARRAY(UNDEFINED);

    private final List<ExprType> parents = new ArrayList<ExprType>();
    private static final Map<ExprCoreType, String> LEGACY_TYPE_NAME_MAPPING;
    private static final Set<ExprType> NUMBER_TYPES;

    private ExprCoreType(ExprCoreType ... compatibleTypes) {
        for (ExprCoreType subType : compatibleTypes) {
            subType.parents.add(this);
        }
    }

    @Override
    public List<ExprType> getParent() {
        return this.parents.isEmpty() ? ExprType.super.getParent() : this.parents;
    }

    @Override
    public String typeName() {
        return this.name();
    }

    @Override
    public String legacyTypeName() {
        return LEGACY_TYPE_NAME_MAPPING.getOrDefault(this, this.name());
    }

    public static List<ExprCoreType> coreTypes() {
        return Arrays.stream(ExprCoreType.values()).filter(type2 -> type2 != UNKNOWN).filter(type2 -> type2 != UNDEFINED).collect(Collectors.toList());
    }

    public static Set<ExprType> numberTypes() {
        return NUMBER_TYPES;
    }

    static {
        LEGACY_TYPE_NAME_MAPPING = new ImmutableMap.Builder<ExprCoreType, String>().put(STRUCT, "OBJECT").put(ARRAY, "NESTED").put(STRING, "KEYWORD").build();
        NUMBER_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add(BYTE)).add(SHORT)).add(INTEGER)).add(LONG)).add(FLOAT)).add(DOUBLE)).build();
    }
}

