/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.binning.time.TimeUnitConfig;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class StandardTimeSpanHandler {
    public RexNode createExpression(RexNode fieldExpr, int intervalValue, TimeUnitConfig config, long alignmentOffsetMillis, CalcitePlanContext context) {
        RexNode epochValue = this.convertToTargetUnit(fieldExpr, config, context);
        long alignmentOffset = this.convertAlignmentOffset(alignmentOffsetMillis, config);
        RexNode adjustedValue = this.applyAlignmentOffset(epochValue, alignmentOffset, context);
        RexNode binValue = this.performBinning(adjustedValue, intervalValue, context);
        if (alignmentOffset != 0L) {
            binValue = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, binValue, context.relBuilder.literal(alignmentOffset));
        }
        return this.convertFromTargetUnit(binValue, config, context);
    }

    private RexNode convertToTargetUnit(RexNode fieldExpr, TimeUnitConfig config, CalcitePlanContext context) {
        RexNode epochSeconds = context.rexBuilder.makeCall(PPLBuiltinOperators.UNIX_TIMESTAMP, fieldExpr);
        if (this.isSubSecondUnit(config)) {
            RexNode epochMillis = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, epochSeconds, context.relBuilder.literal(1000L));
            if (config.getDivisionFactor() == 1L) {
                return epochMillis;
            }
            if (config.getDivisionFactor() > 1L) {
                return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, epochMillis, context.relBuilder.literal(config.getDivisionFactor()));
            }
            return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, epochMillis, context.relBuilder.literal(1000L));
        }
        if (config.getDivisionFactor() == 1L) {
            return epochSeconds;
        }
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, epochSeconds, context.relBuilder.literal(config.getDivisionFactor()));
    }

    private RexNode convertFromTargetUnit(RexNode binValue, TimeUnitConfig config, CalcitePlanContext context) {
        if (this.isSubSecondUnit(config)) {
            RexNode binMillis = config.getDivisionFactor() == 1L ? binValue : (config.getDivisionFactor() > 1L ? context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, binValue, context.relBuilder.literal(config.getDivisionFactor())) : context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, binValue, context.relBuilder.literal(1000L)));
            RexNode binSeconds = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, binMillis, context.relBuilder.literal(1000L));
            return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, binSeconds);
        }
        RexNode binSeconds = config.getDivisionFactor() == 1L ? binValue : context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, binValue, context.relBuilder.literal(config.getDivisionFactor()));
        return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, binSeconds);
    }

    private RexNode applyAlignmentOffset(RexNode epochValue, long alignmentOffset, CalcitePlanContext context) {
        if (alignmentOffset == 0L) {
            return epochValue;
        }
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, epochValue, context.relBuilder.literal(alignmentOffset));
    }

    private RexNode performBinning(RexNode adjustedValue, int intervalValue, CalcitePlanContext context) {
        RexLiteral intervalLiteral = context.relBuilder.literal(intervalValue);
        RexNode divided = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, adjustedValue, intervalLiteral);
        RexNode floored = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, divided);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, floored, intervalLiteral);
    }

    private long convertAlignmentOffset(long offsetMillis, TimeUnitConfig config) {
        if (offsetMillis == 0L || !config.supportsAlignment()) {
            return 0L;
        }
        return switch (config) {
            case TimeUnitConfig.MICROSECONDS -> offsetMillis * 1000L;
            case TimeUnitConfig.MILLISECONDS -> offsetMillis;
            case TimeUnitConfig.CENTISECONDS -> offsetMillis / 10L;
            case TimeUnitConfig.DECISECONDS -> offsetMillis / 100L;
            case TimeUnitConfig.SECONDS -> offsetMillis / 1000L;
            case TimeUnitConfig.MINUTES -> offsetMillis / 60000L;
            case TimeUnitConfig.HOURS -> offsetMillis / 3600000L;
            default -> 0L;
        };
    }

    private boolean isSubSecondUnit(TimeUnitConfig config) {
        return config == TimeUnitConfig.MICROSECONDS || config == TimeUnitConfig.MILLISECONDS || config == TimeUnitConfig.CENTISECONDS || config == TimeUnitConfig.DECISECONDS;
    }
}

