/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.annotation.MLAlgoOutput;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataframe.DataFrameType;
import org.opensearch.ml.common.dataframe.DefaultDataFrame;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.MLOutputType;

@MLAlgoOutput(value=MLOutputType.PREDICTION)
public class MLPredictionOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.PREDICTION;
    public static final String TASK_ID_FIELD = "task_id";
    public static final String STATUS_FIELD = "status";
    public static final String PREDICTION_RESULT_FIELD = "prediction_result";
    public static final String REMOTE_JOB_FIELD = "remote_job";
    String taskId;
    String status;
    Map<String, Object> remoteJob;
    DataFrame predictionResult;

    public MLPredictionOutput(String taskId, String status, DataFrame predictionResult) {
        super(OUTPUT_TYPE);
        this.taskId = taskId;
        this.status = status;
        this.predictionResult = predictionResult;
    }

    public MLPredictionOutput(String taskId, String status, Map<String, Object> remoteJob) {
        super(OUTPUT_TYPE);
        this.taskId = taskId;
        this.status = status;
        this.remoteJob = remoteJob;
    }

    public MLPredictionOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.taskId = in.readOptionalString();
        this.status = in.readOptionalString();
        if (in.readBoolean()) {
            DataFrameType dataFrameType = (DataFrameType)in.readEnum(DataFrameType.class);
            switch (dataFrameType) {
                default: 
            }
            this.predictionResult = new DefaultDataFrame(in);
        }
        if (in.readBoolean()) {
            this.remoteJob = in.readMap(s2 -> s2.readString(), s2 -> s2.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.status);
        if (this.predictionResult != null) {
            out.writeBoolean(true);
            this.predictionResult.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.remoteJob != null) {
            out.writeBoolean(true);
            out.writeMap(this.remoteJob, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.status != null) {
            builder.field(STATUS_FIELD, this.status);
        }
        if (this.predictionResult != null) {
            builder.startObject(PREDICTION_RESULT_FIELD);
            this.predictionResult.toXContent(builder, params);
            builder.endObject();
        }
        if (this.remoteJob != null) {
            builder.field(REMOTE_JOB_FIELD, this.remoteJob);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    @Generated
    public static MLPredictionOutputBuilder builder() {
        return new MLPredictionOutputBuilder();
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Map<String, Object> getRemoteJob() {
        return this.remoteJob;
    }

    @Generated
    public DataFrame getPredictionResult() {
        return this.predictionResult;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setRemoteJob(Map<String, Object> remoteJob) {
        this.remoteJob = remoteJob;
    }

    @Generated
    public void setPredictionResult(DataFrame predictionResult) {
        this.predictionResult = predictionResult;
    }

    @Generated
    public String toString() {
        return "MLPredictionOutput(taskId=" + this.getTaskId() + ", status=" + this.getStatus() + ", remoteJob=" + String.valueOf(this.getRemoteJob()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLPredictionOutput)) {
            return false;
        }
        MLPredictionOutput other = (MLPredictionOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, Object> this$remoteJob = this.getRemoteJob();
        Map<String, Object> other$remoteJob = other.getRemoteJob();
        if (this$remoteJob == null ? other$remoteJob != null : !((Object)this$remoteJob).equals(other$remoteJob)) {
            return false;
        }
        DataFrame this$predictionResult = this.getPredictionResult();
        DataFrame other$predictionResult = other.getPredictionResult();
        return !(this$predictionResult == null ? other$predictionResult != null : !this$predictionResult.equals(other$predictionResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLPredictionOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $taskId = this.getTaskId();
        result2 = result2 * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $status = this.getStatus();
        result2 = result2 * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, Object> $remoteJob = this.getRemoteJob();
        result2 = result2 * 59 + ($remoteJob == null ? 43 : ((Object)$remoteJob).hashCode());
        DataFrame $predictionResult = this.getPredictionResult();
        result2 = result2 * 59 + ($predictionResult == null ? 43 : $predictionResult.hashCode());
        return result2;
    }

    @Generated
    public static class MLPredictionOutputBuilder {
        @Generated
        private String taskId;
        @Generated
        private String status;
        @Generated
        private DataFrame predictionResult;
        @Generated
        private Map<String, Object> remoteJob;

        @Generated
        MLPredictionOutputBuilder() {
        }

        @Generated
        public MLPredictionOutputBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MLPredictionOutputBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public MLPredictionOutputBuilder predictionResult(DataFrame predictionResult) {
            this.predictionResult = predictionResult;
            return this;
        }

        @Generated
        public MLPredictionOutput build() {
            return new MLPredictionOutput(this.taskId, this.status, this.predictionResult);
        }

        @Generated
        public String toString() {
            return "MLPredictionOutput.MLPredictionOutputBuilder(taskId=" + this.taskId + ", status=" + this.status + ", predictionResult=" + String.valueOf(this.predictionResult) + ")";
        }

        @Generated
        public MLPredictionOutputBuilder remoteJob(Map<String, Object> remoteJob) {
            this.remoteJob = remoteJob;
            return this;
        }
    }
}

