/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.indexInsight;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.indexInsight.IndexInsightTaskStatus;
import org.opensearch.ml.common.indexInsight.MLIndexInsightType;

public class IndexInsight
implements ToXContentObject,
Writeable {
    public static final String INDEX_NAME_FIELD = "index_name";
    public static final String LAST_UPDATE_FIELD = "last_updated_time";
    public static final String CONTENT_FIELD = "content";
    public static final String STATUS_FIELD = "status";
    public static final String TASK_TYPE_FIELD = "task_type";
    private final String index;
    private final String content;
    private final IndexInsightTaskStatus status;
    private final MLIndexInsightType taskType;
    private final Instant lastUpdatedTime;
    private final String tenantId;

    public IndexInsight(String index, String content, IndexInsightTaskStatus status, MLIndexInsightType taskType, Instant lastUpdatedTime, String tenantId) {
        this.index = index;
        this.content = content;
        this.status = status;
        this.taskType = taskType;
        this.lastUpdatedTime = lastUpdatedTime;
        this.tenantId = tenantId;
    }

    public IndexInsight(StreamInput input) throws IOException {
        this.index = input.readString();
        this.status = IndexInsightTaskStatus.fromString(input.readString());
        this.taskType = MLIndexInsightType.fromString(input.readString());
        this.lastUpdatedTime = input.readInstant();
        this.content = input.readOptionalString();
        this.tenantId = input.readOptionalString();
    }

    public static IndexInsight parse(XContentParser parser) throws IOException {
        String indexName = null;
        String content = null;
        IndexInsightTaskStatus status = null;
        String taskType = null;
        Instant lastUpdatedTime = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = parser.text();
                    continue block16;
                }
                case "content": {
                    content = parser.text();
                    continue block16;
                }
                case "status": {
                    status = IndexInsightTaskStatus.fromString(parser.text());
                    continue block16;
                }
                case "task_type": {
                    taskType = parser.text();
                    continue block16;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block16;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return IndexInsight.builder().index(indexName).content(content).status(status).taskType(MLIndexInsightType.fromString(taskType)).lastUpdatedTime(lastUpdatedTime).tenantId(tenantId).build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeString(this.status.toString());
        out.writeString(this.taskType.toString());
        out.writeInstant(this.lastUpdatedTime);
        out.writeOptionalString(this.content);
        out.writeOptionalString(this.tenantId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.index != null) {
            builder.field(INDEX_NAME_FIELD, this.index);
        }
        if (this.content != null && !this.content.isEmpty()) {
            builder.field(CONTENT_FIELD, this.content);
        }
        if (this.status != null) {
            builder.field(STATUS_FIELD, this.status.toString());
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.field(TASK_TYPE_FIELD, this.taskType.toString());
        builder.field(LAST_UPDATE_FIELD, this.lastUpdatedTime.toEpochMilli());
        builder.endObject();
        return builder;
    }

    public static IndexInsight fromStream(StreamInput in) throws IOException {
        return new IndexInsight(in);
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.prettyPrint();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public static IndexInsightBuilder builder() {
        return new IndexInsightBuilder();
    }

    @Generated
    public IndexInsightBuilder toBuilder() {
        return new IndexInsightBuilder().index(this.index).content(this.content).status(this.status).taskType(this.taskType).lastUpdatedTime(this.lastUpdatedTime).tenantId(this.tenantId);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexInsight)) {
            return false;
        }
        IndexInsight other = (IndexInsight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        IndexInsightTaskStatus this$status = this.getStatus();
        IndexInsightTaskStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        MLIndexInsightType this$taskType = this.getTaskType();
        MLIndexInsightType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        Instant this$lastUpdatedTime = this.getLastUpdatedTime();
        Instant other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $index = this.getIndex();
        result2 = result2 * 59 + ($index == null ? 43 : $index.hashCode());
        String $content = this.getContent();
        result2 = result2 * 59 + ($content == null ? 43 : $content.hashCode());
        IndexInsightTaskStatus $status = this.getStatus();
        result2 = result2 * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        MLIndexInsightType $taskType = this.getTaskType();
        result2 = result2 * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        Instant $lastUpdatedTime = this.getLastUpdatedTime();
        result2 = result2 * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $tenantId = this.getTenantId();
        result2 = result2 * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result2;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public IndexInsightTaskStatus getStatus() {
        return this.status;
    }

    @Generated
    public MLIndexInsightType getTaskType() {
        return this.taskType;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public static class IndexInsightBuilder {
        @Generated
        private String index;
        @Generated
        private String content;
        @Generated
        private IndexInsightTaskStatus status;
        @Generated
        private MLIndexInsightType taskType;
        @Generated
        private Instant lastUpdatedTime;
        @Generated
        private String tenantId;

        @Generated
        IndexInsightBuilder() {
        }

        @Generated
        public IndexInsightBuilder index(String index) {
            this.index = index;
            return this;
        }

        @Generated
        public IndexInsightBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public IndexInsightBuilder status(IndexInsightTaskStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public IndexInsightBuilder taskType(MLIndexInsightType taskType) {
            this.taskType = taskType;
            return this;
        }

        @Generated
        public IndexInsightBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public IndexInsightBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public IndexInsight build() {
            return new IndexInsight(this.index, this.content, this.status, this.taskType, this.lastUpdatedTime, this.tenantId);
        }

        @Generated
        public String toString() {
            return "IndexInsight.IndexInsightBuilder(index=" + this.index + ", content=" + this.content + ", status=" + String.valueOf((Object)this.status) + ", taskType=" + String.valueOf((Object)this.taskType) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

