/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model.config;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.MicrosoftTeams;
import org.opensearch.commons.notifications.model.SesAccount;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Sns;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.commons.notifications.model.XParser;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.XContentParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/config/ConfigDataProperties;", "", "()V", "CONFIG_PROPERTIES_MAP", "", "Lorg/opensearch/commons/notifications/model/ConfigType;", "Lorg/opensearch/commons/notifications/model/config/ConfigDataProperties$ConfigProperty;", "createConfigData", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "configType", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "getReaderForConfigType", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "validateConfigData", "", "configData", "ConfigProperty", "common-utils"})
public final class ConfigDataProperties {
    @NotNull
    public static final ConfigDataProperties INSTANCE = new ConfigDataProperties();
    @NotNull
    private static final Map<ConfigType, ConfigProperty> CONFIG_PROPERTIES_MAP;

    private ConfigDataProperties() {
    }

    @NotNull
    public final Writeable.Reader<? extends BaseConfigData> getReaderForConfigType(@NotNull ConfigType configType) {
        Intrinsics.checkNotNullParameter((Object)configType, "configType");
        Writeable.Reader<? extends BaseConfigData> reader = CONFIG_PROPERTIES_MAP.get((Object)configType);
        if (reader == null || (reader = reader.getConfigDataReader()) == null) {
            throw new IllegalArgumentException("Transport action used with unknown ConfigType:" + configType);
        }
        return reader;
    }

    public final boolean validateConfigData(@NotNull ConfigType configType, @Nullable BaseConfigData configData) {
        Intrinsics.checkNotNullParameter((Object)configType, "configType");
        return switch (WhenMappings.$EnumSwitchMapping$0[configType.ordinal()]) {
            case 1 -> configData instanceof Slack;
            case 2 -> configData instanceof Webhook;
            case 3 -> configData instanceof Email;
            case 4 -> configData instanceof EmailGroup;
            case 5 -> configData instanceof SmtpAccount;
            case 6 -> configData instanceof Chime;
            case 7 -> configData instanceof Sns;
            case 8 -> configData instanceof SesAccount;
            case 9 -> configData instanceof MicrosoftTeams;
            case 10 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final BaseConfigData createConfigData(@NotNull ConfigType configType, @NotNull XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)configType, "configType");
        Intrinsics.checkNotNullParameter(parser, "parser");
        Object object = CONFIG_PROPERTIES_MAP.get((Object)configType);
        return object != null && (object = ((ConfigProperty)object).getConfigDataParser()) != null ? (BaseConfigData)object.parse(parser) : null;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<ConfigType, ConfigProperty>(ConfigType.SLACK, new ConfigProperty(Slack.Companion.getReader(), Slack.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.CHIME, new ConfigProperty(Chime.Companion.getReader(), Chime.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.WEBHOOK, new ConfigProperty(Webhook.Companion.getReader(), Webhook.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.EMAIL, new ConfigProperty(Email.Companion.getReader(), Email.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.SNS, new ConfigProperty(Sns.Companion.getReader(), Sns.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.SES_ACCOUNT, new ConfigProperty(SesAccount.Companion.getReader(), SesAccount.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.EMAIL_GROUP, new ConfigProperty(EmailGroup.Companion.getReader(), EmailGroup.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.SMTP_ACCOUNT, new ConfigProperty(SmtpAccount.Companion.getReader(), SmtpAccount.Companion.getXParser())), new Pair<ConfigType, ConfigProperty>(ConfigType.MICROSOFT_TEAMS, new ConfigProperty(MicrosoftTeams.Companion.getReader(), MicrosoftTeams.Companion.getXParser()))};
        CONFIG_PROPERTIES_MAP = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0011\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/commons/notifications/model/config/ConfigDataProperties$ConfigProperty;", "", "configDataReader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "configDataParser", "Lorg/opensearch/commons/notifications/model/XParser;", "(Lorg/opensearch/core/common/io/stream/Writeable$Reader;Lorg/opensearch/commons/notifications/model/XParser;)V", "getConfigDataParser", "()Lorg/opensearch/commons/notifications/model/XParser;", "getConfigDataReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "common-utils"})
    private static final class ConfigProperty {
        @NotNull
        private final Writeable.Reader<? extends BaseConfigData> configDataReader;
        @NotNull
        private final XParser<? extends BaseConfigData> configDataParser;

        public ConfigProperty(@NotNull Writeable.Reader<? extends BaseConfigData> configDataReader, @NotNull XParser<? extends BaseConfigData> configDataParser) {
            Intrinsics.checkNotNullParameter(configDataReader, "configDataReader");
            Intrinsics.checkNotNullParameter(configDataParser, "configDataParser");
            this.configDataReader = configDataReader;
            this.configDataParser = configDataParser;
        }

        @NotNull
        public final Writeable.Reader<? extends BaseConfigData> getConfigDataReader() {
            return this.configDataReader;
        }

        @NotNull
        public final XParser<? extends BaseConfigData> getConfigDataParser() {
            return this.configDataParser;
        }

        @NotNull
        public final Writeable.Reader<? extends BaseConfigData> component1() {
            return this.configDataReader;
        }

        @NotNull
        public final XParser<? extends BaseConfigData> component2() {
            return this.configDataParser;
        }

        @NotNull
        public final ConfigProperty copy(@NotNull Writeable.Reader<? extends BaseConfigData> configDataReader, @NotNull XParser<? extends BaseConfigData> configDataParser) {
            Intrinsics.checkNotNullParameter(configDataReader, "configDataReader");
            Intrinsics.checkNotNullParameter(configDataParser, "configDataParser");
            return new ConfigProperty(configDataReader, configDataParser);
        }

        public static /* synthetic */ ConfigProperty copy$default(ConfigProperty configProperty, Writeable.Reader reader, XParser xParser, int n, Object object) {
            if ((n & 1) != 0) {
                reader = configProperty.configDataReader;
            }
            if ((n & 2) != 0) {
                xParser = configProperty.configDataParser;
            }
            return configProperty.copy(reader, xParser);
        }

        @NotNull
        public String toString() {
            return "ConfigProperty(configDataReader=" + this.configDataReader + ", configDataParser=" + this.configDataParser + ")";
        }

        public int hashCode() {
            int result2 = this.configDataReader.hashCode();
            result2 = result2 * 31 + this.configDataParser.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigProperty)) {
                return false;
            }
            ConfigProperty configProperty = (ConfigProperty)other;
            if (!Intrinsics.areEqual(this.configDataReader, configProperty.configDataReader)) {
                return false;
            }
            return Intrinsics.areEqual(this.configDataParser, configProperty.configDataParser);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigType.values().length];
            try {
                nArray[ConfigType.SLACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.WEBHOOK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.EMAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.EMAIL_GROUP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SMTP_ACCOUNT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.CHIME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SNS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SES_ACCOUNT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.MICROSOFT_TEAMS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.NONE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

