/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class SqlMonikerImpl
implements SqlMoniker {
    private final ImmutableList<String> names;
    private final SqlMonikerType type;

    public SqlMonikerImpl(List<String> names, SqlMonikerType type2) {
        this.names = ImmutableList.copyOf(names);
        this.type = Objects.requireNonNull(type2, "type");
    }

    public SqlMonikerImpl(String name, SqlMonikerType type2) {
        this(ImmutableList.of(name), type2);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SqlMonikerImpl && this.type == ((SqlMonikerImpl)obj).type && this.names.equals(((SqlMonikerImpl)obj).names);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.names});
    }

    @Override
    public SqlMonikerType getType() {
        return this.type;
    }

    @Override
    public List<String> getFullyQualifiedNames() {
        return this.names;
    }

    @Override
    public SqlIdentifier toIdentifier() {
        return new SqlIdentifier(this.names, SqlParserPos.ZERO);
    }

    public String toString() {
        return Util.sepList(this.names, ".");
    }

    @Override
    public String id() {
        return (Object)((Object)this.type) + "(" + this + ")";
    }
}

