/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableCollection;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Multimap;

@Deprecated
public class CachingRelMetadataProvider
implements RelMetadataProvider {
    private final Map<List, CacheEntry> cache = new HashMap<List, CacheEntry>();
    private final RelMetadataProvider underlyingProvider;
    private final RelOptPlanner planner;

    public CachingRelMetadataProvider(RelMetadataProvider underlyingProvider, RelOptPlanner planner) {
        this.underlyingProvider = underlyingProvider;
        this.planner = planner;
    }

    @Override
    @Deprecated
    public <M extends Metadata> @Nullable UnboundMetadata<M> apply(Class<? extends RelNode> relClass, Class<? extends M> metadataClass) {
        UnboundMetadata function = this.underlyingProvider.apply(relClass, metadataClass);
        if (function == null) {
            return null;
        }
        return (rel, mq) -> {
            Metadata metadata2 = (Metadata)Objects.requireNonNull(function.bind(rel, mq), () -> "metadata must not be null, relClass=" + relClass + ", metadataClass=" + metadataClass);
            return (Metadata)metadataClass.cast(Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new CachingInvocationHandler(metadata2)));
        };
    }

    @Override
    @Deprecated
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        return this.underlyingProvider.handlers(def);
    }

    @Override
    public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> handlerClass) {
        return this.underlyingProvider.handlers(handlerClass);
    }

    private class CachingInvocationHandler
    implements InvocationHandler {
        private final Metadata metadata;

        CachingInvocationHandler(Metadata metadata2) {
            this.metadata = Objects.requireNonNull(metadata2, "metadata");
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, @Nullable Object[] args2) throws Throwable {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(method);
            builder.add(this.metadata.rel());
            if (args2 != null) {
                for (Object arg : args2) {
                    builder.add(NullSentinel.mask(arg));
                }
            }
            ImmutableCollection key = builder.build();
            long timestamp = CachingRelMetadataProvider.this.planner.getRelMetadataTimestamp(this.metadata.rel());
            CacheEntry entry = (CacheEntry)CachingRelMetadataProvider.this.cache.get(key);
            if (entry != null && timestamp == entry.timestamp) {
                return entry.result;
            }
            try {
                Object result2 = method.invoke((Object)this.metadata, args2);
                if (result2 != null) {
                    entry = new CacheEntry();
                    entry.timestamp = timestamp;
                    entry.result = result2;
                    CachingRelMetadataProvider.this.cache.put(key, entry);
                }
                return result2;
            }
            catch (InvocationTargetException e) {
                throw Nullness.castNonNull(e.getCause());
            }
        }
    }

    private static class CacheEntry {
        long timestamp;
        @Nullable Object result;

        private CacheEntry() {
        }
    }
}

