/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DeclarationStatement
extends Statement {
    public final int modifiers;
    public final ParameterExpression parameter;
    public final @Nullable Expression initializer;

    public DeclarationStatement(int modifiers, ParameterExpression parameter, @Nullable Expression initializer) {
        super(ExpressionType.Declaration, Void.TYPE);
        this.modifiers = modifiers;
        this.parameter = Objects.requireNonNull(parameter, "parameter");
        this.initializer = initializer;
    }

    @Override
    public DeclarationStatement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression initializer = this.initializer != null ? this.initializer.accept(shuttle) : null;
        return shuttle.visit(this, initializer);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(modifiers).append(' ');
        }
        writer.append(this.parameter.type).append(' ').append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
        writer.append(';');
        writer.newlineAndIndent();
    }

    public void accept2(ExpressionWriter writer, boolean withType) {
        if (withType) {
            String modifiers = Modifier.toString(this.modifiers);
            if (!modifiers.isEmpty()) {
                writer.append(modifiers).append(' ');
            }
            writer.append(this.parameter.type).append(' ');
        } else {
            writer.append(", ");
        }
        writer.append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeclarationStatement that = (DeclarationStatement)o;
        return this.modifiers == that.modifiers && Objects.equals(this.initializer, that.initializer) && this.parameter.equals(that.parameter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.modifiers, this.parameter, this.initializer});
    }
}

