/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.frequencies;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRegion;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.ArrayOfItemsSerDe;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.frequencies.ErrorType;
import com.yahoo.sketches.frequencies.PreambleUtil;
import com.yahoo.sketches.frequencies.ReversePurgeItemHashMap;
import com.yahoo.sketches.frequencies.ReversePurgeLongHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;

public class ItemsSketch<T> {
    private int lgMaxMapSize;
    private int curMapCap;
    private long offset;
    private long streamLength = 0L;
    private int sampleSize;
    private ReversePurgeItemHashMap<T> hashMap;

    public ItemsSketch(int maxMapSize) {
        this(Util.toLog2(maxMapSize, "maxMapSize"), 3);
    }

    ItemsSketch(int lgMaxMapSize, int lgCurMapSize) {
        this.lgMaxMapSize = Math.max(lgMaxMapSize, 3);
        int lgCurMapSz = Math.max(lgCurMapSize, 3);
        this.hashMap = new ReversePurgeItemHashMap(1 << lgCurMapSz);
        this.curMapCap = this.hashMap.getCapacity();
        int maxMapCap = (int)((double)(1 << lgMaxMapSize) * ReversePurgeItemHashMap.getLoadFactor());
        this.offset = 0L;
        this.sampleSize = Math.min(1024, maxMapCap);
    }

    public static <T> ItemsSketch<T> getInstance(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        boolean preLongsEqMax;
        long pre0 = PreambleUtil.checkPreambleSize(srcMem);
        int maxPreLongs = Family.FREQUENCY.getMaxPreLongs();
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int serVer = PreambleUtil.extractSerVer(pre0);
        int familyID = PreambleUtil.extractFamilyID(pre0);
        int lgMaxMapSize = PreambleUtil.extractLgMaxMapSize(pre0);
        int lgCurMapSize = PreambleUtil.extractLgCurMapSize(pre0);
        boolean empty = (PreambleUtil.extractFlags(pre0) & 4) != 0;
        boolean preLongsEq1 = preLongs == 1;
        boolean bl = preLongsEqMax = preLongs == maxPreLongs;
        if (!preLongsEq1 && !preLongsEqMax) {
            throw new SketchesArgumentException("Possible Corruption: PreLongs must be 1 or " + maxPreLongs + ": " + preLongs);
        }
        if (serVer != 1) {
            throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 1: " + serVer);
        }
        int actFamID = Family.FREQUENCY.getID();
        if (familyID != actFamID) {
            throw new SketchesArgumentException("Possible Corruption: FamilyID must be " + actFamID + ": " + familyID);
        }
        if (empty ^ preLongsEq1) {
            throw new SketchesArgumentException("Possible Corruption: (PreLongs == 1) ^ Empty == True.");
        }
        if (empty) {
            return new ItemsSketch<T>(lgMaxMapSize, 3);
        }
        long[] preArr = new long[preLongs];
        srcMem.getLongArray(0L, preArr, 0, preLongs);
        ItemsSketch<T> fis = new ItemsSketch<T>(lgMaxMapSize, lgCurMapSize);
        fis.streamLength = 0L;
        fis.offset = preArr[3];
        int preBytes = preLongs << 3;
        int activeItems = PreambleUtil.extractActiveItems(preArr[1]);
        long[] countArray = new long[activeItems];
        srcMem.getLongArray(preBytes, countArray, 0, activeItems);
        int itemsOffset = preBytes + 8 * activeItems;
        T[] itemArray = serDe.deserializeFromMemory(new MemoryRegion(srcMem, itemsOffset, srcMem.getCapacity() - (long)itemsOffset), activeItems);
        for (int i = 0; i < activeItems; ++i) {
            fis.update(itemArray[i], countArray[i]);
        }
        fis.streamLength = preArr[2];
        return fis;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        int outBytes;
        int preLongs;
        boolean empty = this.isEmpty();
        int activeItems = this.getNumActiveItems();
        byte[] bytes = null;
        if (empty) {
            preLongs = 1;
            outBytes = 8;
        } else {
            preLongs = Family.FREQUENCY.getMaxPreLongs();
            bytes = serDe.serializeToByteArray(this.hashMap.getActiveKeys());
            outBytes = (preLongs + activeItems << 3) + bytes.length;
        }
        byte[] outArr = new byte[outBytes];
        NativeMemory mem = new NativeMemory(outArr);
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertSerVer(1, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.FREQUENCY.getID(), pre0);
        pre0 = PreambleUtil.insertLgMaxMapSize(this.lgMaxMapSize, pre0);
        pre0 = PreambleUtil.insertLgCurMapSize(this.hashMap.getLgLength(), pre0);
        long l = pre0 = empty ? PreambleUtil.insertFlags(4, pre0) : PreambleUtil.insertFlags(0, pre0);
        if (empty) {
            mem.putLong(0L, pre0);
        } else {
            long pre = 0L;
            long[] preArr = new long[preLongs];
            preArr[0] = pre0;
            preArr[1] = PreambleUtil.insertActiveItems(activeItems, 0L);
            preArr[2] = this.streamLength;
            preArr[3] = this.offset;
            mem.putLongArray(0L, preArr, 0, preLongs);
            int preBytes = preLongs << 3;
            mem.putLongArray(preBytes, this.hashMap.getActiveValues(), 0, activeItems);
            mem.putByteArray(preBytes + (this.getNumActiveItems() << 3), bytes, 0, bytes.length);
        }
        return outArr;
    }

    public void update(T item) {
        this.update(item, 1L);
    }

    public void update(T item, long count) {
        if (item == null || count == 0L) {
            return;
        }
        if (count < 0L) {
            throw new SketchesArgumentException("Count may not be negative");
        }
        this.streamLength += count;
        this.hashMap.adjustOrPutValue(item, count);
        if (this.getNumActiveItems() > this.curMapCap) {
            if (this.hashMap.getLgLength() < this.lgMaxMapSize) {
                this.hashMap.resize(2 * this.hashMap.getLength());
                this.curMapCap = this.hashMap.getCapacity();
            } else {
                this.offset += this.hashMap.purge(this.sampleSize);
                if (this.getNumActiveItems() > this.getMaximumMapCapacity()) {
                    throw new SketchesStateException("Purge did not reduce active items.");
                }
            }
        }
    }

    public ItemsSketch<T> merge(ItemsSketch<T> other) {
        if (other == null) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        long streamLen = this.streamLength + other.streamLength;
        ReversePurgeItemHashMap.Iterator<T> iter = other.hashMap.iterator();
        while (iter.next()) {
            this.update(iter.getKey(), iter.getValue());
        }
        this.offset += other.offset;
        this.streamLength = streamLen;
        return this;
    }

    public long getEstimate(T item) {
        long itemCount = this.hashMap.get(item);
        return itemCount > 0L ? itemCount + this.offset : 0L;
    }

    public long getUpperBound(T item) {
        return this.hashMap.get(item) + this.offset;
    }

    public long getLowerBound(T item) {
        return this.hashMap.get(item);
    }

    public Row<T>[] getFrequentItems(long threshold, ErrorType errorType) {
        return this.sortItems(threshold > this.getMaximumError() ? threshold : this.getMaximumError(), errorType);
    }

    public Row<T>[] getFrequentItems(ErrorType errorType) {
        return this.sortItems(this.getMaximumError(), errorType);
    }

    Row<T>[] sortItems(long threshold, ErrorType errorType) {
        long est;
        ArrayList<Row<T>> rowList = new ArrayList<Row<T>>();
        ReversePurgeItemHashMap.Iterator<T> iter = this.hashMap.iterator();
        if (errorType == ErrorType.NO_FALSE_NEGATIVES) {
            while (iter.next()) {
                est = this.getEstimate(iter.getKey());
                long ub = this.getUpperBound(iter.getKey());
                long lb = this.getLowerBound(iter.getKey());
                if (ub < threshold) continue;
                Row<T> row = new Row<T>(iter.getKey(), est, ub, lb);
                rowList.add(row);
            }
        } else {
            while (iter.next()) {
                est = this.getEstimate(iter.getKey());
                long ub = this.getUpperBound(iter.getKey());
                long lb = this.getLowerBound(iter.getKey());
                if (lb < threshold) continue;
                Row<T> row = new Row<T>(iter.getKey(), est, ub, lb);
                rowList.add(row);
            }
        }
        rowList.sort(new Comparator<Row<T>>(){

            @Override
            public int compare(Row<T> r1, Row<T> r2) {
                return r2.compareTo(r1);
            }
        });
        Row[] rowsArr = rowList.toArray((Row[])Array.newInstance(Row.class, rowList.size()));
        return rowsArr;
    }

    public int getCurrentMapCapacity() {
        return this.curMapCap;
    }

    public long getMaximumError() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.getNumActiveItems() == 0;
    }

    public long getStreamLength() {
        return this.streamLength;
    }

    public int getMaximumMapCapacity() {
        return (int)((double)(1 << this.lgMaxMapSize) * ReversePurgeLongHashMap.getLoadFactor());
    }

    public int getNumActiveItems() {
        return this.hashMap.getNumActive();
    }

    public void reset() {
        this.hashMap = new ReversePurgeItemHashMap(8);
        this.curMapCap = this.hashMap.getCapacity();
        this.offset = 0L;
        this.streamLength = 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FrequentItemsSketch<T>:").append(Util.LS);
        sb.append("  Stream Length    : " + this.streamLength).append(Util.LS);
        sb.append("  Max Error Offset : " + this.offset).append(Util.LS);
        sb.append(this.hashMap.toString());
        return sb.toString();
    }

    public static class Row<T>
    implements Comparable<Row<T>> {
        final T item;
        final long est;
        final long ub;
        final long lb;
        private static final String FMT = "  %12d%12d%12d %s";
        private static final String HFMT = "  %12s%12s%12s %s";

        Row(T item, long estimate, long ub, long lb) {
            this.item = item;
            this.est = estimate;
            this.ub = ub;
            this.lb = lb;
        }

        public T getItem() {
            return this.item;
        }

        public long getEstimate() {
            return this.est;
        }

        public long getUpperBound() {
            return this.ub;
        }

        public long getLowerBound() {
            return this.lb;
        }

        public static String getRowHeader() {
            return String.format(HFMT, "Est", "UB", "LB", "Item");
        }

        public String toString() {
            return String.format(FMT, this.est, this.ub, this.lb, this.item.toString());
        }

        @Override
        public int compareTo(Row<T> that) {
            return this.est < that.est ? -1 : (this.est > that.est ? 1 : 0);
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (int)(this.est ^ this.est >>> 32);
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Row)) {
                return false;
            }
            Row that = (Row)obj;
            return this.est == that.est;
        }
    }
}

