/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.matching;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.PropertyPattern;
import com.facebook.presto.matching.pattern.EqualsPattern;
import com.facebook.presto.matching.pattern.FilterPattern;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class Property<F, T> {
    private final String name;
    private final Function<F, Optional<T>> function;

    public static <F, T> Property<F, T> property(String name, Function<F, T> function) {
        return Property.optionalProperty(name, source2 -> Optional.of(function.apply(source2)));
    }

    public static <F, T> Property<F, T> optionalProperty(String name, Function<F, Optional<T>> function) {
        return new Property<F, T>(name, function);
    }

    public Property(String name, Function<F, Optional<T>> function) {
        this.name = name;
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    public Function<F, Optional<?>> getFunction() {
        return this.function::apply;
    }

    public <R> PropertyPattern<F, R> matching(Pattern<R> pattern) {
        return PropertyPattern.of(this, pattern);
    }

    public PropertyPattern<F, T> capturedAs(Capture<T> capture) {
        Pattern<Object> matchAll = Pattern.any();
        return this.matching(matchAll.capturedAs(capture));
    }

    public PropertyPattern<F, T> equalTo(T expectedValue) {
        return this.matching(new EqualsPattern<T>(expectedValue, null));
    }

    public PropertyPattern<F, T> matching(Predicate<? super T> predicate) {
        return this.matching(new FilterPattern<T>(predicate, null));
    }
}

