/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrserverless.model.transform.ConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Configuration
implements Serializable,
Cloneable,
StructuredPojo {
    private String classification;
    private Map<String, String> properties;
    private List<Configuration> configurations;

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public String getClassification() {
        return this.classification;
    }

    public Configuration withClassification(String classification) {
        this.setClassification(classification);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties2) {
        this.properties = properties2;
    }

    public Configuration withProperties(Map<String, String> properties2) {
        this.setProperties(properties2);
        return this;
    }

    public Configuration addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public Configuration clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public Configuration withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new ArrayList<Configuration>(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public Configuration withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClassification() != null) {
            sb.append("Classification: ").append(this.getClassification()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (other.getClassification() == null ^ this.getClassification() == null) {
            return false;
        }
        if (other.getClassification() != null && !other.getClassification().equals(this.getClassification())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        return other.getConfigurations() == null || other.getConfigurations().equals(this.getConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getClassification() == null ? 0 : this.getClassification().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        return hashCode2;
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

