/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebAppStatUtils;
import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class WebAppStatManager {
    public static final String SYS_PROP_INSTANCES = "druid.web.webAppStat";
    private static final WebAppStatManager instance = new WebAppStatManager();
    private Set<Object> webAppStatSet = null;

    public static WebAppStatManager getInstance() {
        return instance;
    }

    public synchronized WebAppStat getWebAppStat(String contextPath) {
        Set<Object> stats = this.getWebAppStatSet();
        for (Object item : stats) {
            WebAppStat stat;
            if (!(item instanceof WebAppStat) || !StringUtils.equals((stat = (WebAppStat)item).getContextPath(), contextPath)) continue;
            return stat;
        }
        WebAppStat stat = new WebAppStat(contextPath);
        this.addWebAppStatSet(stat);
        return stat;
    }

    public Set<Object> getWebAppStatSet() {
        if (this.webAppStatSet == null) {
            this.webAppStatSet = DruidDataSourceStatManager.isRegisterToSystemProperty() ? WebAppStatManager.getWebAppStatSet0() : new CopyOnWriteArraySet<Object>();
        }
        return this.webAppStatSet;
    }

    public List<Map<String, Object>> getWebAppStatData() {
        Set<Object> stats = this.getWebAppStatSet();
        ArrayList<Map<String, Object>> statDataList = new ArrayList<Map<String, Object>>(stats.size());
        for (Object stat : stats) {
            Map<String, Object> statData = WebAppStatUtils.getStatData(stat);
            statDataList.add(statData);
        }
        return statDataList;
    }

    public List<Map<String, Object>> getURIStatData() {
        Set<Object> stats = this.getWebAppStatSet();
        ArrayList<Map<String, Object>> allAppUriStatDataList = new ArrayList<Map<String, Object>>();
        for (Object stat : stats) {
            List<Map<String, Object>> uriStatDataList = WebAppStatUtils.getURIStatDataList(stat);
            allAppUriStatDataList.addAll(uriStatDataList);
        }
        return allAppUriStatDataList;
    }

    public List<Map<String, Object>> getSessionStatData() {
        Set<Object> stats = this.getWebAppStatSet();
        ArrayList<Map<String, Object>> allAppUriStatDataList = new ArrayList<Map<String, Object>>();
        for (Object stat : stats) {
            List<Map<String, Object>> uriStatDataList = WebAppStatUtils.getSessionStatDataList(stat);
            allAppUriStatDataList.addAll(uriStatDataList);
        }
        return allAppUriStatDataList;
    }

    public Map<String, Object> getSessionStat(String sessionId) {
        Set<Object> stats = this.getWebAppStatSet();
        for (Object stat : stats) {
            Map<String, Object> statData = WebAppStatUtils.getSessionStatData(stat, sessionId);
            if (statData == null) continue;
            return statData;
        }
        return null;
    }

    public Map<String, Object> getURIStatData(String uri) {
        Set<Object> stats = this.getWebAppStatSet();
        for (Object stat : stats) {
            Map<String, Object> statData = WebAppStatUtils.getURIStatData(stat, uri);
            if (statData == null) continue;
            return statData;
        }
        return null;
    }

    public void addWebAppStatSet(Object webAppStat) {
        this.getWebAppStatSet().add(webAppStat);
    }

    public boolean remove(Object webAppStat) {
        return this.getWebAppStatSet().remove(webAppStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Object> getWebAppStatSet0() {
        Properties properties2 = System.getProperties();
        CopyOnWriteArraySet webAppStats = (CopyOnWriteArraySet)properties2.get(SYS_PROP_INSTANCES);
        if (webAppStats == null) {
            Properties properties3 = properties2;
            synchronized (properties3) {
                webAppStats = (Set)properties2.get(SYS_PROP_INSTANCES);
                if (webAppStats == null) {
                    webAppStats = new CopyOnWriteArraySet();
                    properties2.put(SYS_PROP_INSTANCES, webAppStats);
                }
            }
        }
        return webAppStats;
    }

    public void resetStat() {
        Set<Object> stats = this.getWebAppStatSet();
        for (Object stat : stats) {
            WebAppStatUtils.reset(stat);
        }
    }
}

