/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import java.io.IOException;
import java.lang.reflect.Array;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.hibernate.type.descriptor.jdbc.StructHelper;
import org.hibernate.type.format.JsonDocumentWriter;

public class JsonGeneratingVisitor {
    public static final JsonGeneratingVisitor INSTANCE = new JsonGeneratingVisitor();

    protected JsonGeneratingVisitor() {
    }

    public void visitArray(JavaType<?> elementJavaType, JdbcType elementJdbcType, Object[] values, WrapperOptions options, JsonDocumentWriter writer) {
        writer.startArray();
        if (values.length == 0) {
            writer.endArray();
            return;
        }
        if (elementJdbcType instanceof JsonJdbcType) {
            JsonJdbcType jsonElementJdbcType = (JsonJdbcType)elementJdbcType;
            EmbeddableMappingType embeddableMappingType = jsonElementJdbcType.getEmbeddableMappingType();
            for (Object value : values) {
                try {
                    this.visit(embeddableMappingType, value, options, writer);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not serialize JSON array value", e);
                }
            }
        } else {
            assert (!(elementJdbcType instanceof AggregateJdbcType));
            for (Object value : values) {
                if (value == null) {
                    writer.nullValue();
                    continue;
                }
                writer.serializeJsonValue(value, elementJavaType, elementJdbcType, options);
            }
        }
        writer.endArray();
    }

    private static boolean isArrayType(JdbcType type) {
        return type.getDefaultSqlTypeCode() == 2003 || type.getDefaultSqlTypeCode() == 3018;
    }

    public void visit(MappingType mappedType, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        if (this.handleNullOrLazy(value, writer)) {
            return;
        }
        if (mappedType instanceof EntityMappingType) {
            EntityMappingType entityType = (EntityMappingType)mappedType;
            this.serializeEntity(value, entityType, options, writer);
        } else if (mappedType instanceof ManagedMappingType) {
            ManagedMappingType managedMappingType = (ManagedMappingType)mappedType;
            this.serializeObject(managedMappingType, value, options, writer);
        } else if (mappedType instanceof BasicType) {
            BasicType basicType = (BasicType)mappedType;
            if (JsonGeneratingVisitor.isArrayType(basicType.getJdbcType())) {
                int length = Array.getLength(value);
                writer.startArray();
                if (length != 0) {
                    JavaType elementJavaType = ((BasicPluralJavaType)((Object)basicType.getJdbcJavaType())).getElementJavaType();
                    JdbcType elementJdbcType = ((ArrayJdbcType)basicType.getJdbcType()).getElementJdbcType();
                    Object domainArray = basicType.convertToRelationalValue(value);
                    for (int j = 0; j < length; ++j) {
                        writer.serializeJsonValue(Array.get(domainArray, j), elementJavaType, elementJdbcType, options);
                    }
                }
                writer.endArray();
            } else {
                writer.serializeJsonValue(basicType.convertToRelationalValue(value), basicType.getJdbcJavaType(), basicType.getJdbcType(), options);
            }
        } else {
            throw new UnsupportedOperationException("Support for mapping type not yet implemented: " + mappedType.getClass().getName());
        }
    }

    protected boolean handleNullOrLazy(Object value, JsonDocumentWriter writer) {
        if (value == null) {
            writer.nullValue();
            return true;
        }
        return false;
    }

    private void serializeObject(ManagedMappingType managedMappingType, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        writer.startObject();
        this.serializeObjectValues(managedMappingType, value, options, writer);
        writer.endObject();
    }

    protected void serializeObjectValues(ManagedMappingType managedMappingType, Object object, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        Object[] values = managedMappingType.getValues(object);
        for (int i = 0; i < values.length; ++i) {
            ValuedModelPart subPart = StructHelper.getSubPart(managedMappingType, i);
            Object value = values[i];
            this.serializeModelPart(subPart, value, options, writer);
        }
    }

    protected void serializeModelPart(ValuedModelPart modelPart, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        if (modelPart instanceof SelectableMapping) {
            SelectableMapping selectableMapping = (SelectableMapping)((Object)modelPart);
            writer.objectKey(selectableMapping.getSelectableName());
            this.visit(modelPart.getMappedType(), value, options, writer);
        } else if (modelPart instanceof EmbeddedAttributeMapping) {
            EmbeddedAttributeMapping embeddedAttribute = (EmbeddedAttributeMapping)modelPart;
            if (value != null) {
                EmbeddableMappingType mappingType = embeddedAttribute.getMappedType();
                SelectableMapping aggregateMapping = mappingType.getAggregateMapping();
                if (aggregateMapping == null) {
                    this.serializeObjectValues(mappingType, value, options, writer);
                } else {
                    String name = aggregateMapping.getSelectableName();
                    writer.objectKey(name);
                    this.visit(mappingType, value, options, writer);
                }
            }
        } else {
            throw new UnsupportedOperationException("Support for model part type not yet implemented: " + (modelPart != null ? modelPart.getClass().getName() : "null"));
        }
    }

    protected void serializeEntity(Object value, EntityMappingType entityType, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        EntityIdentifierMapping identifierMapping = entityType.getIdentifierMapping();
        this.serializeEntityIdentifier(value, identifierMapping, options, writer);
    }

    protected void serializeEntityIdentifier(Object value, EntityIdentifierMapping identifierMapping, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        Object identifier = identifierMapping.getIdentifier(value);
        if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
            SingleAttributeIdentifierMapping singleAttribute = (SingleAttributeIdentifierMapping)identifierMapping;
            writer.serializeJsonValue(identifier, singleAttribute.getJavaType(), singleAttribute.getSingleJdbcMapping().getJdbcType(), options);
        } else if (identifier instanceof CompositeIdentifierMapping) {
            CompositeIdentifierMapping composite = (CompositeIdentifierMapping)identifier;
            this.visit(composite.getMappedType(), identifier, options, writer);
        } else {
            throw new UnsupportedOperationException("Unsupported identifier type: " + identifier.getClass().getName());
        }
    }
}

