/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Objects;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedEmbeddedValuedSimplePath<T, S extends T>
extends SqmEmbeddedValuedSimplePath<S>
implements SqmTreatedPath<T, S> {
    private final SqmPath<T> wrappedPath;
    private final SqmEmbeddableDomainType<S> treatTarget;

    public SqmTreatedEmbeddedValuedSimplePath(SqmPath<T> wrappedPath, SqmEmbeddableDomainType<S> treatTarget) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getTypeName()), wrappedPath.getReferencedPathSource(), null, wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    private SqmTreatedEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPath<T> wrappedPath, SqmEmbeddableDomainType<S> treatTarget) {
        super(navigablePath, wrappedPath.getReferencedPathSource(), null, wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedEmbeddedValuedSimplePath<T, S> copy(SqmCopyContext context) {
        SqmTreatedEmbeddedValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedEmbeddedValuedSimplePath<T, S> path = context.registerCopy(this, new SqmTreatedEmbeddedValuedSimplePath<T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmTreatableDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmBindableType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public SqmTreatableDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.wrappedPath.getLhs();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getTypeName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedEmbeddedValuedSimplePath)) return false;
        SqmTreatedEmbeddedValuedSimplePath that = (SqmTreatedEmbeddedValuedSimplePath)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getTypeName(), that.treatTarget.getTypeName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treatTarget.getTypeName(), this.wrappedPath.getNavigablePath());
    }
}

