/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.securityprofile;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.idm.SecurityProfileConfiguration;
import org.keycloak.securityprofile.SecurityProfileProvider;
import org.keycloak.securityprofile.SecurityProfileProviderFactory;
import org.keycloak.services.clientpolicy.ClientPoliciesUtil;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.securityprofile.DefaultSecurityProfileProvider;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.FileUtils;

public class DefaultSecurityProfileProviderFactory
implements SecurityProfileProviderFactory {
    private static final Logger logger = Logger.getLogger(DefaultSecurityProfileProviderFactory.class);
    private String name;
    private volatile SecurityProfileConfiguration configuration;

    public SecurityProfileProvider create(KeycloakSession session) {
        return new DefaultSecurityProfileProvider(this.readConfiguration(session));
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("name").type("string").helpText("Name for the security configuration file to use. File `name`.json is searched in classapth and `conf` installation folder.").add().build();
    }

    public void init(Config.Scope config) {
        this.name = config.get("name", "none-security-profile");
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecurityProfileConfiguration readConfiguration(KeycloakSession session) {
        if (this.configuration == null) {
            DefaultSecurityProfileProviderFactory defaultSecurityProfileProviderFactory = this;
            synchronized (defaultSecurityProfileProviderFactory) {
                SecurityProfileConfiguration conf;
                String file = this.name + ".json";
                try {
                    try (InputStream is = FileUtils.getJsonFileFromClasspathOrConfFolder(file);){
                        conf = (SecurityProfileConfiguration)JsonSerialization.readValue((InputStream)is, SecurityProfileConfiguration.class);
                    }
                    conf.setDefaultClientProfiles(ClientPoliciesUtil.readGlobalClientProfilesRepresentation(session, conf.getClientProfiles()));
                    conf.setDefaultClientPolicies(ClientPoliciesUtil.readGlobalClientPoliciesRepresentation(session, conf.getClientPolicies(), conf.getDefaultClientProfiles()));
                }
                catch (IOException | ClientPolicyException e) {
                    throw new IllegalStateException("Error loading the security profile from file " + file, e);
                }
                this.configuration = conf;
            }
        }
        return this.configuration;
    }
}

