/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.CriterionPredicateRegistry;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.resolver.ResolverSupport;
import org.opensaml.core.criterion.SatisfyAnyCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.role.EvaluableRoleDescriptorCriterion;
import org.opensaml.saml.metadata.criteria.role.impl.RoleDescriptorCriterionPredicateRegistry;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.common.IsTimeboundSAMLObjectValidPredicate;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class PredicateRoleDescriptorResolver
extends AbstractIdentifiedInitializableComponent
implements RoleDescriptorResolver {
    @Nonnull
    private static final Predicate<XMLObject> IS_VALID_PREDICATE = new IsTimeboundSAMLObjectValidPredicate();
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PredicateRoleDescriptorResolver.class);
    private boolean requireValidMetadata;
    @Nonnull
    private MetadataResolver entityDescriptorResolver;
    private boolean satisfyAnyPredicates;
    @Nullable
    private CriterionPredicateRegistry<RoleDescriptor> criterionPredicateRegistry;
    private boolean useDefaultPredicateRegistry;
    private boolean resolveViaPredicatesOnly;

    public PredicateRoleDescriptorResolver(@Nonnull @ParameterName(name="mdResolver") MetadataResolver mdResolver) {
        this.entityDescriptorResolver = Constraint.isNotNull(mdResolver, "Resolver for EntityDescriptors may not be null");
        this.setId(UUID.randomUUID().toString());
        this.requireValidMetadata = true;
        this.useDefaultPredicateRegistry = true;
    }

    @Override
    public boolean isRequireValidMetadata() {
        return this.requireValidMetadata;
    }

    @Override
    public void setRequireValidMetadata(boolean require) {
        this.checkSetterPreconditions();
        this.requireValidMetadata = require;
    }

    public boolean isSatisfyAnyPredicates() {
        return this.satisfyAnyPredicates;
    }

    public void setSatisfyAnyPredicates(boolean flag) {
        this.checkSetterPreconditions();
        this.satisfyAnyPredicates = flag;
    }

    @NonnullAfterInit
    public CriterionPredicateRegistry<RoleDescriptor> getCriterionPredicateRegistry() {
        return this.criterionPredicateRegistry;
    }

    public void setCriterionPredicateRegistry(@Nullable CriterionPredicateRegistry<RoleDescriptor> registry) {
        this.checkSetterPreconditions();
        this.criterionPredicateRegistry = registry;
    }

    public boolean isUseDefaultPredicateRegistry() {
        return this.useDefaultPredicateRegistry;
    }

    public void setUseDefaultPredicateRegistry(boolean flag) {
        this.checkSetterPreconditions();
        this.useDefaultPredicateRegistry = flag;
    }

    public boolean isResolveViaPredicatesOnly() {
        return this.resolveViaPredicatesOnly;
    }

    public void setResolveViaPredicatesOnly(boolean flag) {
        this.checkSetterPreconditions();
        this.resolveViaPredicatesOnly = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getCriterionPredicateRegistry() == null && this.isUseDefaultPredicateRegistry()) {
            this.setCriterionPredicateRegistry(new RoleDescriptorCriterionPredicateRegistry());
        }
    }

    @Override
    @Nullable
    public RoleDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<RoleDescriptor> iterator;
        this.checkComponentActive();
        Iterable<RoleDescriptor> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    @Nonnull
    public Iterable<RoleDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        Predicate<XMLObject> predicate;
        this.checkComponentActive();
        Iterable<EntityDescriptor> entityDescriptorsSource = this.entityDescriptorResolver.resolve(criteria);
        if (!entityDescriptorsSource.iterator().hasNext()) {
            this.log.debug("Resolved no EntityDescriptors via underlying MetadataResolver, returning empty collection");
            return CollectionSupport.emptySet();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved {} source EntityDescriptors", (Object)Iterables.size(entityDescriptorsSource));
        }
        Predicate<XMLObject> predicate2 = predicate = this.isRequireValidMetadata() ? IS_VALID_PREDICATE : PredicateSupport.alwaysTrue();
        if (this.haveRoleCriteria(criteria)) {
            Iterable<RoleDescriptor> candidates = this.getCandidatesByRoleAndProtocol(entityDescriptorsSource, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolved {} RoleDescriptor candidates via role criteria, performing predicate filtering", (Object)Iterables.size(candidates));
            }
            return this.predicateFilterCandidates(Iterables.filter(candidates, predicate::test), criteria, false);
        }
        if (this.isResolveViaPredicatesOnly()) {
            Iterable<RoleDescriptor> candidates = this.getAllCandidates(entityDescriptorsSource);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolved {} RoleDescriptor total candidates for predicate-only resolution", (Object)Iterables.size(candidates));
            }
            return this.predicateFilterCandidates(Iterables.filter(candidates, predicate::test), criteria, true);
        }
        this.log.debug("Found no role criteria and predicate-only resolution is disabled, returning empty collection");
        return CollectionSupport.emptySet();
    }

    protected boolean haveRoleCriteria(@Nullable CriteriaSet criteria) {
        return criteria != null && criteria.contains(EntityRoleCriterion.class);
    }

    @Nonnull
    protected Iterable<RoleDescriptor> getCandidatesByRoleAndProtocol(@Nonnull Iterable<EntityDescriptor> entityDescriptors, @Nullable CriteriaSet criteria) {
        EntityRoleCriterion roleCriterion = Constraint.isNotNull(criteria != null ? criteria.get(EntityRoleCriterion.class) : null, "EntityRoleCriterion was not supplied");
        assert (criteria != null);
        ProtocolCriterion protocolCriterion = criteria.get(ProtocolCriterion.class);
        ArrayList<List<RoleDescriptor>> aggregate = new ArrayList<List<RoleDescriptor>>();
        for (EntityDescriptor entityDescriptor : entityDescriptors) {
            if (protocolCriterion != null) {
                aggregate.add(entityDescriptor.getRoleDescriptors(roleCriterion.getRole(), protocolCriterion.getProtocol()));
                continue;
            }
            aggregate.add(entityDescriptor.getRoleDescriptors(roleCriterion.getRole()));
        }
        return Iterables.concat(aggregate);
    }

    @Nonnull
    protected Iterable<RoleDescriptor> getAllCandidates(@Nonnull Iterable<EntityDescriptor> entityDescriptors) {
        ArrayList<List<RoleDescriptor>> aggregate = new ArrayList<List<RoleDescriptor>>();
        for (EntityDescriptor entityDescriptor : entityDescriptors) {
            aggregate.add(entityDescriptor.getRoleDescriptors());
        }
        return Iterables.concat(aggregate);
    }

    @Nonnull
    protected Iterable<RoleDescriptor> predicateFilterCandidates(@Nonnull Iterable<RoleDescriptor> candidates, @Nullable CriteriaSet criteria, boolean onEmptyPredicatesReturnEmpty) throws ResolverException {
        boolean satisfyAny;
        SatisfyAnyCriterion satisfyAnyCriterion;
        if (!candidates.iterator().hasNext()) {
            this.log.debug("Candidates iteration was empty, nothing to filter via predicates");
            return CollectionSupport.emptySet();
        }
        this.log.debug("Attempting to filter candidate RoleDescriptors via resolved Predicates");
        Set predicates = ResolverSupport.getPredicates(criteria, EvaluableRoleDescriptorCriterion.class, this.getCriterionPredicateRegistry());
        this.log.trace("Resolved {} Predicates: {}", (Object)predicates.size(), predicates);
        SatisfyAnyCriterion satisfyAnyCriterion2 = satisfyAnyCriterion = criteria != null ? criteria.get(SatisfyAnyCriterion.class) : null;
        if (satisfyAnyCriterion != null) {
            this.log.trace("CriteriaSet contained SatisfyAnyCriterion");
            satisfyAny = satisfyAnyCriterion.isSatisfyAny();
        } else {
            this.log.trace("CriteriaSet did NOT contain SatisfyAnyCriterion");
            satisfyAny = this.isSatisfyAnyPredicates();
        }
        this.log.trace("Effective satisyAny value: {}", (Object)satisfyAny);
        Iterable<RoleDescriptor> result = ResolverSupport.getFilteredIterable(candidates, predicates, satisfyAny, onEmptyPredicatesReturnEmpty);
        if (this.log.isDebugEnabled()) {
            this.log.debug("After predicate filtering {} RoleDescriptors remain", (Object)Iterables.size(result));
        }
        return result;
    }
}

