/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorForwardIndex;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorReader;
import org.opensearch.neuralsearch.sparse.cache.AccountableTracker;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.CacheableSparseVectorWriter;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.LruDocumentCache;
import org.opensearch.neuralsearch.sparse.cache.RamBytesRecorder;
import org.opensearch.neuralsearch.sparse.data.SparseVector;

public class ForwardIndexCacheItem
extends AccountableTracker
implements SparseVectorForwardIndex {
    @Generated
    private static final Logger log = LogManager.getLogger(ForwardIndexCacheItem.class);
    private final CacheKey cacheKey;
    private final AtomicReferenceArray<SparseVector> sparseVectors;
    private final RamBytesRecorder globalRamBytes;
    private final SparseVectorReader reader = new CacheSparseVectorReader();
    private final CacheableSparseVectorWriter writer = new CacheSparseVectorWriter();

    public CacheableSparseVectorWriter getWriter(Consumer<Long> circuitBreakerHandler) {
        return new CacheSparseVectorWriter(circuitBreakerHandler);
    }

    public ForwardIndexCacheItem(CacheKey cacheKey, int docCount, RamBytesRecorder globalRamBytes) {
        this.cacheKey = cacheKey;
        this.globalRamBytes = globalRamBytes;
        this.sparseVectors = new AtomicReferenceArray(docCount);
        this.recordUsedBytes(RamUsageEstimator.shallowSizeOf(this.sparseVectors) + RamUsageEstimator.alignObjectSize((long)((long)docCount * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF)));
        globalRamBytes.recordWithoutValidation(this.ramBytesUsed(), CircuitBreakerManager::addWithoutBreaking);
    }

    @Override
    @Generated
    public SparseVectorReader getReader() {
        return this.reader;
    }

    @Override
    @Generated
    public CacheableSparseVectorWriter getWriter() {
        return this.writer;
    }

    private class CacheSparseVectorWriter
    implements CacheableSparseVectorWriter {
        private final Consumer<Long> circuitBreakerTriggerHandler;

        private CacheSparseVectorWriter() {
            this.circuitBreakerTriggerHandler = ramBytesUsed -> LruDocumentCache.getInstance().evict((long)ramBytesUsed);
        }

        private CacheSparseVectorWriter(Consumer<Long> circuitBreakerTriggerHandler) {
            this.circuitBreakerTriggerHandler = circuitBreakerTriggerHandler;
        }

        @Override
        public void insert(int docId, SparseVector vector) {
            if (vector == null || docId < 0 || docId >= ForwardIndexCacheItem.this.sparseVectors.length() || ForwardIndexCacheItem.this.sparseVectors.get(docId) != null) {
                return;
            }
            long ramBytesUsed = vector.ramBytesUsed();
            if (!ForwardIndexCacheItem.this.globalRamBytes.record(ramBytesUsed) && this.circuitBreakerTriggerHandler != null) {
                this.circuitBreakerTriggerHandler.accept(ramBytesUsed);
                if (!ForwardIndexCacheItem.this.globalRamBytes.record(ramBytesUsed)) {
                    return;
                }
            }
            LruDocumentCache.DocumentKey documentKey = new LruDocumentCache.DocumentKey(ForwardIndexCacheItem.this.cacheKey, docId);
            LruDocumentCache.getInstance().updateAccess(documentKey);
            if (ForwardIndexCacheItem.this.sparseVectors.compareAndSet(docId, null, vector)) {
                ForwardIndexCacheItem.this.recordUsedBytes(ramBytesUsed);
            } else {
                ForwardIndexCacheItem.this.globalRamBytes.recordWithoutValidation(-ramBytesUsed, CircuitBreakerManager::addWithoutBreaking);
            }
        }

        @Override
        public long erase(int docId) {
            if (docId < 0 || docId >= ForwardIndexCacheItem.this.sparseVectors.length()) {
                return 0L;
            }
            SparseVector vector = ForwardIndexCacheItem.this.sparseVectors.get(docId);
            if (vector == null) {
                return 0L;
            }
            long ramBytesReleased = vector.ramBytesUsed();
            if (ForwardIndexCacheItem.this.sparseVectors.compareAndSet(docId, vector, null)) {
                ForwardIndexCacheItem.this.recordUsedBytes(-ramBytesReleased);
                ForwardIndexCacheItem.this.globalRamBytes.recordWithoutValidation(-ramBytesReleased, CircuitBreakerManager::addWithoutBreaking);
                return ramBytesReleased;
            }
            return 0L;
        }
    }

    private class CacheSparseVectorReader
    implements SparseVectorReader {
        private CacheSparseVectorReader() {
        }

        @Override
        public SparseVector read(int docId) throws IOException {
            if (docId < 0 || docId >= ForwardIndexCacheItem.this.sparseVectors.length()) {
                return null;
            }
            SparseVector vector = ForwardIndexCacheItem.this.sparseVectors.get(docId);
            if (vector != null) {
                LruDocumentCache.DocumentKey documentKey = new LruDocumentCache.DocumentKey(ForwardIndexCacheItem.this.cacheKey, docId);
                LruDocumentCache.getInstance().updateAccess(documentKey);
            }
            return vector;
        }
    }
}

